package net.gdface.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URL;

/**
 * 远程实现方法
 * @author guyadong
 *
 */
@Target({ ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
public @interface Remote {	
	boolean value() default true;
	Class<?> genericTypeClass() default URL.class;
	/**
	 * 原始方法名
	 * @return
	 */
	String primtiveName()default "";
	/**
	 * 远程解析的泛型参数名
	 * @return
	 */
	String[] genericParam() default {};
}
