/**   
* @Title: GenericParam.java 
* @Package net.gdface.annotation 
* @Description: TODO 
* @author guyadong   
* @date 2015年7月19日 下午12:31:50 
* @version V1.0   
*/
package net.gdface.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
/**
 * 服务端口(方法)定义<br>
 * @author guyadong
 *
 */
@Target({ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
@Inherited
public @interface ServicePort {
	
	/**端口(方法)名后缀,用于防止端口名冲突
	 * @return
	 */
	String suffix() default "";
	/**
	 * 指定要生成多态端口的参数名,默认不生成多态端口
	 * @return
	 */
	String[] genericParam() default {};
	/**
	 * 可以将{@link #bridgeType()}转成 {@link #targetType()}的数据类型列表<br>
	 * 会根据这个名字生成 "ByXXX"后缀的方法,例如:定义为{"URL","Base64"}<br>
	 * 不允许有重复的值,必须是{@link Service#genericTypes()}定义的子集<br>
	 * 为空时使用{@link Service#genericTypes()} 
	 * 
	 * @return
	 */
	String[] genericTypes() default {};
}
