package net.gdface.annotation;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.PARAMETER;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 
 * 用于定义数据类型字段/服务方法(端口)参数的特性<br>
 * 用于定义字段/参数的无效值
 * @author guyadong
 *
 */
@Target({ METHOD,FIELD, PARAMETER })
@Retention(RetentionPolicy.RUNTIME)
public @interface CodegenInvalidValue {
	/**
	 * 无效值定义,比如为'-1',则视'-1'为无效值
	 */
	String value() default "";
	/**
	 * 无效值判断表达式,当value()为空时有效<br>
	 * 比如{@code '$$<0 || $$>5'},即小于0大于5都为无效值,'$$'为变量名占位符
	 */
	String exp() default "";
}
