package net.gdface.annotation;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.PARAMETER;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 
 * 用于定义数据类型字段/服务方法(端口)参数的特性<br>
 * 当字段/参数的类型为String、数组、或集合类型时，用于定义要求的元素个数或最大元素个数
 * @author guyadong
 *
 */
@Target({ METHOD,FIELD, PARAMETER })
@Retention(RetentionPolicy.RUNTIME)
public @interface CodegenLength {
	/**
	 * 要求的元素个数
	 */
	int value() default -1;
	/**
	 * 要求元素最大个数
	 */
	int max() default -1;
	/**
	 * 是否为字段预分配空间,对于类字段为String,数组或集合类型时有效
	 */
	boolean prealloc() default false;
}
