package net.gdface.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 衍生方法生成描述
 * @author guyadong
 *
 */
@Target({ ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
public @interface DeriveMethod {	
	Class<?>[] localResolvedTypes() default {};
	Class<?>[] remoteResolveTypes() default {};
	/**
	 * 指定泛型参数名,所有类型为{@link Service#targetType()}的参数
	 */
	String[] genericParam() default {};
	String[] methodSuffix() default{};
	Class<?> bridgeType() default String.class;
	/** 方法分类,可以添加任意字符串命名的标签用于方法分类,一个方法可以有多个分类 */
	String[] catalogs() default{};
}
