package net.gdface.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 服务定义<br>
 * {@link #bridgeType()},{@link #targetType()},{@link #genericTypes()}用来定义成多态端口的方式<br>
 * 例如:{@link #portPrefix()}为"db_",{@link #bridgeType()}定义为{@link String},{@link #targetType()}定义为byte[],
 * {@link #genericTypes()}定义为{"URL","Base64"}<br>
 * 那么对于一个方法{@code public int addImage(byte[] img)}生成的的服务端口为:<br>
 * {@code public int db_addImage(byte[] img)}<br>
 * {@code public int db_addImageByURL(String img)}<br>
 * {@code public int db_addImageByBase64(String img)}<br>
 * 
 * @author guyadong
 *
 */
@Target({ ElementType.TYPE })
@Retention(RetentionPolicy.RUNTIME)
public @interface Service {
	/**
	 * 端口(方法)名前缀,防止多个接口实现之间的方法名冲突
	 * 
	 */
	String portPrefix() default "";

	/**
	 * 方法中需要生成多个端口的的桥接类型
	 * 
	 */
	Class<?> bridgeType() default Object.class;

	/**
	 * 目标参数类型<br>
	 * 具有该类型的方法参数 {@link #bridgeType()}和 {@link #genericTypes()}才有效
	 * 
	 */
	Class<?> targetType() default Object.class;

	/**
	 * 可以将{@link #bridgeType()}转成 {@link #targetType()}的数据类型列表<br>
	 * 会根据这个名字生成 "ByXXX"后缀的方法,例如:定义为{"URL","Base64"}<br>
	 * 不允许有重复的值
	 * 
	 */
	String[] genericTypes() default {};

	/**
	 * {@link #genericTypes()}中每个类型名对应的类<br>
	 * 不允许有重复的值,不允许为{@code null}
	 * 
	 */
	Class<?>[]genericTypeClasses() default {};
}
