/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.generic;

import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import net.gdface.annotation.AnnotationException;
import net.gdface.annotation.AnnotationRuntimeException;
import net.gdface.annotation.DefaultGenericTypes;
import net.gdface.annotation.DeriveMethod;
import net.gdface.annotation.Generic;
import net.gdface.annotation.GenericNameException;
import net.gdface.annotation.GenericParam;
import net.gdface.annotation.GenericParamException;
import net.gdface.codegen.AnnotationUtils;
import net.gdface.codegen.CodeGenUtils;
import net.gdface.codegen.InvalidAnnotationDefineException;
import net.gdface.codegen.InvalidNameException;
import net.gdface.codegen.Method;
import net.gdface.codegen.NewSourceInfoAbstract;
import net.gdface.codegen.ServiceInfo;
import net.gdface.codegen.generic.DefaultGenericTypesExceptoin;
import net.gdface.codegen.generic.DefaultParameterGenericTypes;
import net.gdface.codegen.generic.GenericInterfaceConstants;
import net.gdface.codegen.generic.GenericNameConflictException;
import net.gdface.codegen.generic.GenericParamRedefineException;
import net.gdface.utils.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericInterface<T>
extends NewSourceInfoAbstract<T>
implements GenericInterfaceConstants {
    private static final Logger logger = LoggerFactory.getLogger(NewSourceInfoAbstract.class);
    private DefaultParameterGenericTypes defaultGenericTypes;
    private Class<?> shellInterface;
    private ServiceInfo serviceInfo;
    private boolean hasRemoteResolveType;

    public GenericInterface(Class<T> interfaceClass, Class<? extends T> refClass, Class<?> shellInterface) {
        super(interfaceClass, refClass, null);
        Assert.notNull(shellInterface, (String)"shellInterface");
        this.shellInterface = shellInterface;
        if (!shellInterface.isInterface()) {
            throw new IllegalArgumentException(String.format("shellInterface must be a interface(\u5fc5\u987b\u662f\u63a5\u53e3)", new Object[0]));
        }
        if (!interfaceClass.isAssignableFrom(shellInterface)) {
            throw new IllegalArgumentException(String.format("shellInterface must  extends from  [%s] (\u5fc5\u987b\u5b9e\u73b0\u63a5\u53e3)", interfaceClass.getName()));
        }
    }

    public boolean compile() {
        boolean compileOk = false;
        try {
            this.defaultGenericTypes = new DefaultParameterGenericTypes(this.interfaceClass);
            this.serviceInfo = new ServiceInfo(AnnotationUtils.getServiceAnnotation(this.shellInterface));
            super.compile();
            this.importedList.remove(this.refClass.getSimpleName());
            this.importedList.remove(this.interfaceClass.getSimpleName());
            for (String name : this.defaultGenericTypes.names()) {
                if (!this.hasInClassGenericTypes(name)) continue;
                try {
                    throw new GenericNameConflictException(name, DefaultGenericTypes.class.getSimpleName(), this.defaultGenericTypes.toString());
                }
                catch (GenericNameConflictException e) {
                    throw new DefaultGenericTypesExceptoin((Throwable)((Object)e));
                }
            }
            for (Method method : this.methodsNeedGenerated) {
                this.compile(method);
            }
            compileOk = true;
        }
        catch (AnnotationException e) {
            logger.error(e.toString());
        }
        catch (AnnotationRuntimeException e) {
            logger.error(e.toString());
        }
        return compileOk;
    }

    private final void compile(Method method) throws GenericParamException, GenericNameException, GenericNameConflictException {
        for (Method.Parameter param : method.getParameters()) {
            try {
                this.compile(param);
            }
            catch (GenericParamRedefineException e) {
                logger.warn("{} is generic type({}) defined by class,can't be redefined in method:\n{}", new Object[]{param.name, param.genericType.toString(), method.toGenericString()});
            }
            catch (GenericNameException e) {
                throw new GenericNameException(String.format("the name of annotation %s of parameter [%s] must not have space char in method %s", Generic.class.getSimpleName(), param.name, method.toGenericString()));
            }
        }
        DeriveMethod deriveMethodAnnotation = this.getDeriveMethodAnnotation(method);
        if (deriveMethodAnnotation != null) {
            this.addImportedClass(deriveMethodAnnotation.localResolvedTypes());
            if (deriveMethodAnnotation.remoteResolveTypes().length > 0) {
                this.hasRemoteResolveType = true;
                this.addImportedClass(deriveMethodAnnotation.remoteResolveTypes());
            }
        }
    }

    private final void compile(Method.Parameter param) throws GenericParamRedefineException, GenericNameConflictException, GenericNameException {
        GenericParam genericParam = (GenericParam)param.getAnnotation(GenericParam.class);
        if (null != genericParam && genericParam.value() && param.genericType instanceof TypeVariable) {
            throw new GenericParamRedefineException();
        }
        if (null != genericParam && !genericParam.name().isEmpty()) {
            if (!Pattern.compile("^[A-Z]\\w*$").matcher(genericParam.name()).matches()) {
                throw new GenericNameException();
            }
            if (this.hasInClassGenericTypes(genericParam.name())) {
                throw new GenericNameConflictException(genericParam.name(), GenericParam.class.getSimpleName(), genericParam.toString());
            }
        }
    }

    protected void createMethodsNeedGenerated() {
        ArrayList<java.lang.reflect.Method> interfaceMethods = new ArrayList<java.lang.reflect.Method>(Arrays.asList(this.interfaceClass.getMethods()));
        Iterator<java.lang.reflect.Method> it = interfaceMethods.iterator();
        try {
            while (it.hasNext()) {
                java.lang.reflect.Method im = it.next();
                Method cm = new Method(im, this.paramTable.getParameterNames(im.getName(), (Class[])im.getParameterTypes()));
                if (!this.needGeneric(cm)) continue;
                this.methodsNeedGenerated.add(cm);
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public DefaultParameterGenericTypes getDefaultGenericTypes() {
        return this.defaultGenericTypes;
    }

    private boolean hasInClassGenericTypes(String name) {
        for (TypeVariable type : this.interfaceClass.getTypeParameters()) {
            if (!type.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private final boolean hasNeedGenericParameter(Method method) {
        for (Method.Parameter param : method.getParameters()) {
            if (!this.needGeneric(param)) continue;
            return true;
        }
        return false;
    }

    public boolean needGeneric(Method method) {
        Generic generic = (Generic)method.getAnnotation(Generic.class);
        return (null == generic || generic.value()) && this.hasNeedGenericParameter(method);
    }

    public final boolean needGeneric(Method.Parameter param) {
        GenericParam genericParam = (GenericParam)param.getAnnotation(GenericParam.class);
        return (null == genericParam || genericParam.value()) && this.defaultGenericTypes.hasType(param.type);
    }

    public final GenericParam getGenericParam(Method.Parameter param) {
        return (GenericParam)param.getAnnotation(GenericParam.class);
    }

    public final Set<String> getGenericNames(Method method) {
        HashSet<String> names = new HashSet<String>();
        for (Method.Parameter param : method.getParameters()) {
            if (!this.needGeneric(param)) continue;
            GenericParam genericParam = this.getGenericParam(param);
            if (null == genericParam) {
                names.add(this.defaultGenericTypes.getName(param.getType()));
                continue;
            }
            names.add(genericParam.name());
        }
        return names;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int c = 0;
        builder.append("//classes need imported in new Class:\n");
        for (Class clazz : this.importedList.values()) {
            builder.append("//[" + ++c + "]\nimported ").append(clazz.getName()).append(";\n");
        }
        builder.append("public interface NewClass{\n");
        c = 0;
        builder.append("//methods thad need generated in new Class:\n");
        for (Method m : this.methodsNeedGenerated) {
            builder.append("//[" + ++c + "]\n").append(m.toGenericString()).append(";\n");
        }
        builder.append("}\n");
        return builder.toString();
    }

    public Class<?> getShellInterface() {
        return this.shellInterface;
    }

    public DeriveMethod getDeriveMethodAnnotation(Method method) {
        try {
            return AnnotationUtils.getDeriveMethodAnnotation((Method)method, (ServiceInfo)this.serviceInfo);
        }
        catch (InvalidNameException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAnnotationDefineException e) {
            throw new RuntimeException(e);
        }
    }

    public ServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    public boolean isTargetType(Class<?> type) {
        return this.serviceInfo.getTargetType() == type;
    }

    public boolean needDeriveParam(Method method, Method.Parameter param) {
        DeriveMethod deriveMethod = this.getDeriveMethodAnnotation(method);
        if (deriveMethod != null) {
            Set set = CodeGenUtils.toSet((Object[])deriveMethod.genericParam());
            return this.needGeneric(param) && (set.isEmpty() || set.contains(param.name));
        }
        return false;
    }

    public ArrayList<String> getDeriveParameterNames(Method method) {
        ArrayList<String> list = new ArrayList<String>();
        for (Method.Parameter parameter : method.getParameters()) {
            if (!this.needDeriveParam(method, parameter)) continue;
            list.add(parameter.name);
        }
        return list;
    }

    public boolean isHasRemoteResolveType() {
        return this.hasRemoteResolveType;
    }
}

