/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.service;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.gdface.annotation.AnnotationException;
import net.gdface.annotation.AnnotationRuntimeException;
import net.gdface.annotation.Service;
import net.gdface.annotation.ServicePort;
import net.gdface.codegen.AnnotationUtils;
import net.gdface.codegen.CodeGenUtils;
import net.gdface.codegen.InvalidNameException;
import net.gdface.codegen.Method;
import net.gdface.codegen.MethodException;
import net.gdface.codegen.NewSourceInfoAbstract;
import net.gdface.codegen.ServiceInfo;
import net.gdface.codegen.WebServiceClassConstants;
import net.gdface.codegen.generator.GeneratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServiceClass<T>
extends NewSourceInfoAbstract<T>
implements WebServiceClassConstants {
    private static final Logger logger = LoggerFactory.getLogger(WebServiceClass.class);
    private ServiceInfo serviceInfo;

    public WebServiceClass(Class<T> interfaceClass, Class<? extends T> refClass) {
        super(interfaceClass, refClass, null);
    }

    public boolean compile() {
        boolean compileOk = false;
        try {
            if (super.compile()) {
                Service service = AnnotationUtils.getServiceAnnotation((Class)this.interfaceClass);
                if (null != service) {
                    this.addImportedClass(service.genericTypeClasses());
                }
                this.addImportedClass(new Type[]{this.refClass});
                this.serviceInfo = new ServiceInfo(service);
                for (Method method : this.methodsNeedGenerated) {
                    this.compile(method);
                }
                compileOk = true;
            }
        }
        catch (AnnotationException e) {
            logger.error(e.toString());
        }
        catch (AnnotationRuntimeException e) {
            logger.error(e.toString());
        }
        return compileOk;
    }

    private final void compile(Method method) throws InvalidNameException {
        ServicePort servicePort = (ServicePort)method.getAnnotation(ServicePort.class);
        if (null != servicePort) {
            if (!servicePort.suffix().isEmpty() && !servicePort.suffix().matches("^\\w+$")) {
                throw new InvalidNameException(String.format("the prefix of annotation [%s] in method %s of %s must not have space char ", ServicePort.class.getSimpleName(), method.getName(), method.getDeclaringClass().getSimpleName()));
            }
            Set nameSet = CodeGenUtils.toSetIfnotDup((Object[])servicePort.genericParam());
            if (null == nameSet) {
                throw new InvalidNameException(String.format("the genericParam of annotation [%s] in method %s of %s must not have duplicated element", ServicePort.class.getSimpleName(), method.getName(), method.getDeclaringClass().getSimpleName()));
            }
            for (String gp : nameSet) {
                if (gp.isEmpty()) {
                    throw new InvalidNameException(String.format("the genericParam of annotation [%s] in method %s of %s must not be empty element ", ServicePort.class.getSimpleName(), method.getName(), method.getDeclaringClass().getSimpleName()));
                }
                if (!gp.matches("^\\w+$")) {
                    throw new InvalidNameException(String.format("the prefix of annotation [%s] in method %s of %s must not have space char ", ServicePort.class.getSimpleName(), method.getName(), method.getDeclaringClass().getSimpleName()));
                }
                Method.Parameter parameter = method.getParameter(gp);
                if (null == parameter) {
                    throw new InvalidNameException(String.format("the genericParam of annotation [%s] in method %s of %s not one of  method's parameter names", ServicePort.class.getSimpleName(), method.getName(), method.getDeclaringClass().getSimpleName()));
                }
                if (parameter.type == this.getServiceInfo().getTargetType()) continue;
                throw new InvalidNameException(String.format("the parameter's type specified genericParam of annotation [%s] in method %s of %s is not target type defined in %s of class %s", ServicePort.class.getSimpleName(), method.getName(), method.getDeclaringClass().getSimpleName(), Service.class.getSimpleName(), this.interfaceClass.getSimpleName()));
            }
            Set typeSet = CodeGenUtils.toSetIfnotDup((Object[])servicePort.genericTypes());
            if (null == typeSet) {
                throw new InvalidNameException(String.format("the genericTypes of annotation [%s] in method %s of %s must not have duplicated element", ServicePort.class.getSimpleName(), method.getName(), method.getDeclaringClass().getSimpleName()));
            }
            typeSet.removeAll(this.getServiceInfo().getGenericTypeMap().keySet());
            if (!typeSet.isEmpty()) {
                throw new InvalidNameException(String.format("the elements of genericTypes of annotation [%s] in method %s of %s must defined in %s", ServicePort.class.getSimpleName(), method.getName(), method.getDeclaringClass().getSimpleName(), Service.class.getSimpleName()));
            }
        }
    }

    protected void createMethodsNeedGenerated() {
        ArrayList<java.lang.reflect.Method> interfaceMethods = new ArrayList<java.lang.reflect.Method>(Arrays.asList(this.interfaceClass.getMethods()));
        java.lang.reflect.Method[] refMethods = this.refClass.getDeclaredMethods();
        java.lang.reflect.Method[] superMethods = this.refClass.getSuperclass().getMethods();
        Iterator<java.lang.reflect.Method> it = interfaceMethods.iterator();
        try {
            while (it.hasNext()) {
                java.lang.reflect.Method im = it.next();
                if (null != im.getAnnotation(ServicePort.class)) {
                    this.methodsNeedGenerated.add(new Method(im, this.paramTable.getParameterNames(im.getName(), (Class[])im.getParameterTypes())));
                    continue;
                }
                java.lang.reflect.Method bm = WebServiceClass.getImplementedMethod((java.lang.reflect.Method[])superMethods, (java.lang.reflect.Method)im);
                if (null == bm) {
                    java.lang.reflect.Method rm = WebServiceClass.getImplementedMethod((java.lang.reflect.Method[])refMethods, (java.lang.reflect.Method)im);
                    assert (rm != null);
                    this.methodsNeedGenerated.add(new Method(rm, this.paramTable.getParameterNames(im.getName(), (Class[])im.getParameterTypes())));
                    continue;
                }
                if (null == bm.getAnnotation(ServicePort.class)) continue;
                this.methodsNeedGenerated.add(new Method(bm, this.paramTable.getParameterNames(im.getName(), (Class[])im.getParameterTypes())));
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public final ServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    public final ServicePort getServicePort(Method method) {
        return (ServicePort)method.getAnnotation(ServicePort.class);
    }

    public final Method getMatchedGenericMethod(Class<?> clazz, Method method, Class<?> expectedType) throws MethodException {
        ServicePort servicePort = (ServicePort)method.getAnnotation(ServicePort.class);
        if (servicePort == null) {
            throw new MethodException(String.format("not defined annotation %s in method %s ", ServicePort.class.getSimpleName(), method.getDocSignature(false)));
        }
        return this.getMatchedGenericMethod(null == clazz ? this.interfaceClass : clazz, method, expectedType, servicePort.genericParam(), this.getServiceInfo().getTargetType());
    }

    public final Method getMatchedGenericMethodFromInterface(Method method, Class<?> expectedType) throws MethodException {
        return this.getMatchedGenericMethod(this.interfaceClass, method, expectedType);
    }

    public final List<Class<? extends Throwable>> getThrowsByMatchedGenericMethod(Class<?> clazz, Method method, Class<?> expectedType) throws MethodException {
        Set srcSet = CodeGenUtils.toSet((Object[])this.getMatchedGenericMethod(clazz, method, expectedType).getExceptionTypes());
        HashSet retain = new HashSet(srcSet);
        retain.retainAll(CodeGenUtils.toSet((Object[])method.getExceptionTypes()));
        srcSet.removeAll(retain);
        ArrayList<Class> res = new ArrayList<Class>();
        Iterator it = srcSet.iterator();
        while (it.hasNext()) {
            res.add((Class)it.next());
        }
        return GeneratorUtils.sortAndFilterThrowable(res, (Class[])new Class[]{RuntimeException.class});
    }

    public final List<Class<? extends Throwable>> getThrowsByMatchedGenericMethod(Method method, Class<?> expectedType) throws MethodException {
        return this.getThrowsByMatchedGenericMethod(this.interfaceClass, method, expectedType);
    }
}

