/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.service;

import java.util.ArrayList;
import net.gdface.codegen.generator.GeneratorConfiguration;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class WebServiceClassConfiguration
extends GeneratorConfiguration {
    private Class<?>[] refClass;
    private Class<?>[] interfaceClass;

    public void loadConfig(Options options, CommandLine cmd) throws ParseException {
        super.loadConfig(options, cmd);
        ArrayList<String> ics = new ArrayList<String>();
        for (String ic : cmd.getOptionValue("ic").split("[,;=]")) {
            if (ic.isEmpty()) continue;
            ics.add(ic);
        }
        ArrayList<String> rcs = new ArrayList<String>();
        for (String rc : cmd.getOptionValue("rc").split("[,;=]")) {
            if (rc.isEmpty()) continue;
            rcs.add(rc);
        }
        if (ics.size() != rcs.size()) {
            throw new ParseException(String.format("%s[%s] %s[%s] has diiferent argument number", "ic", cmd.getOptionValue("ic"), "rc", cmd.getOptionValue("rc")));
        }
        if (ics.size() == 0) {
            throw new ParseException(String.format("%s %s must not empty", "ic", "rc"));
        }
        this.interfaceClass = new Class[ics.size()];
        this.refClass = new Class[ics.size()];
        try {
            for (int i = 0; i < ics.size(); ++i) {
                this.interfaceClass[i] = Class.forName((String)ics.get(i));
                this.refClass[i] = Class.forName((String)rcs.get(i));
            }
        }
        catch (ClassNotFoundException e) {
            throw new ParseException(e.toString());
        }
        this.setProperty("interface-class", this.interfaceClass);
        this.setProperty("reference-class", this.refClass);
    }

    public Class<?>[] getRefClass() {
        return this.refClass;
    }

    public Class<?>[] getInterfaceClass() {
        return this.interfaceClass;
    }
}

