package net.gdface.codegen.service;

import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.gdface.cli.Context;
import net.gdface.codegen.generator.Generator;
import net.gdface.codegen.generator.GeneratorConfiguration;

public class WebServiceClassGenerator extends Generator {
	public static void main(String[] args) {
		new WebServiceClassGenerator().parseCommandLine(args).initEngine().generate();
	}

	private static final Logger logger = LoggerFactory.getLogger(WebServiceClassGenerator.class);
	private final WebServiceClassOptions options = WebServiceClassOptions.getInstance();
	private final WebServiceClassConfiguration config = new WebServiceClassConfiguration();

	public WebServiceClassGenerator() {
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	public Context createEngineContext() {
		Class<?>[] interfaceClass = config.getInterfaceClass();
		Class<?>[] refClass = config.getRefClass();
		if (interfaceClass.length != refClass.length) {
			logger.error(
					"the parameters from option \"{}\"and\"{}\" is different number\nPlease check your command line parameters",
					REFERENCE_CLASS_OPTION, INTERFACE_CLASS_OPTION);
			System.exit(1);
		}
		WebServiceClass newSourceInfo[] = new WebServiceClass[interfaceClass.length];
		for (int i = 0; i < interfaceClass.length; i++) {
			newSourceInfo[i] = new WebServiceClass(interfaceClass[i], refClass[i]);
			if (!newSourceInfo[i].compile())
				System.exit(1);
		}
		Context context = super.createEngineContext();
		context.setProperty(SOURCE_INFO, newSourceInfo);
		return context;
	}

	@Override
	protected GeneratorConfiguration getGeneratorConfiguration() {
		return this.config;
	}

	@Override
	protected Options getOptions() {
		return options.getOptions();
	}

}
