package net.gdface.codegen.service;

import org.apache.commons.cli.Option;

import net.gdface.codegen.generator.GeneratorOptions;

public class WebServiceClassOptions extends GeneratorOptions {
	private final static WebServiceClassOptions instance = new WebServiceClassOptions();

	/**
	 * 
	 */
	protected WebServiceClassOptions() {
		super();
		options.addOption(Option.builder(INTERFACE_CLASS_OPTION).longOpt(INTERFACE_CLASS_OPTION_LONG)
				.desc("interface classes,splited with [,]without blank space,must maped with -rc")
				.argName("className,..,className").numberOfArgs(1).required().build());
		options.addOption(Option.builder(REFERENCE_CLASS_OPTION).longOpt(REFERENCE_CLASS_OPTION_LONG)
				.desc("reference classes,splited with [,]without blank space,must maped with -ic")
				.argName("className,..,className").numberOfArgs(1).required().build());
	}

	/**
	 * @return instance
	 */
	public static WebServiceClassOptions getInstance() {
		return instance;
	}

}
