package net.gdface.codegen.service;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

import net.gdface.codegen.generator.GeneratorConfiguration;

public class WebServiceClassConfiguration extends GeneratorConfiguration {

	private Class<?>[] refClass;
	private Class<?>[] interfaceClass;

	@Override
	public void loadConfig(Options options, CommandLine cmd) throws ParseException {
		super.loadConfig(options, cmd);
		List<String> ics = new ArrayList<String>();
		for (String ic : cmd.getOptionValue(INTERFACE_CLASS_OPTION).split("[,;=]"))
			if (!ic.isEmpty())
				ics.add(ic);
		List<String> rcs = new ArrayList<String>();
		for (String rc : cmd.getOptionValue(REFERENCE_CLASS_OPTION).split("[,;=]"))
			if (!rc.isEmpty())
				rcs.add(rc);

		if (ics.size() != rcs.size())
			throw new ParseException(String.format("%s[%s] %s[%s] has diiferent argument number",
					INTERFACE_CLASS_OPTION, cmd.getOptionValue(INTERFACE_CLASS_OPTION), REFERENCE_CLASS_OPTION,
					cmd.getOptionValue(REFERENCE_CLASS_OPTION)));
		else if (ics.size() == 0)
			throw new ParseException(String.format("%s %s must not empty", INTERFACE_CLASS_OPTION,
					REFERENCE_CLASS_OPTION));

		interfaceClass = new Class<?>[ics.size()];
		refClass = new Class<?>[ics.size()];
		try {
			for (int i = 0; i < ics.size(); i++) {
				interfaceClass[i] = Class.forName(ics.get(i));
				refClass[i] = Class.forName(rcs.get(i));
			}
		} catch (ClassNotFoundException e) {
			throw new ParseException(e.toString());
		}
		setProperty(INTERFACE_CLASS_OPTION_LONG, interfaceClass);
		setProperty(REFERENCE_CLASS_OPTION_LONG, refClass);
	}

	/**
	 * @return refClass
	 */
	public Class<?>[] getRefClass() {
		return refClass;
	}

	/**
	 * @return interfaceClass
	 */
	public Class<?>[] getInterfaceClass() {
		return interfaceClass;
	}

}
