package net.gdface.codegen.thrift;

import java.util.List;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

import net.gdface.codegen.plugin.BasePlugin;

/**
 * {@link ThriftServiceDecoratorGenerator}生成器运行插件
 * @author guyadong
 *
 */
@Mojo(name = "generate")
public class ThriftServicePlugin extends BasePlugin{
	/**
	 * interface class name
	 */
	@Parameter(required = true)
	private String interfaceClass;
	@Parameter(required = false)
	private String refClass = null;
	@Parameter(alias="package",required =true)
	private String pkg ;
	@Parameter(required = false)
	private String thriftPackage = null;
	@Parameter(alias="gt",required =true)
	private String taskType;
	@Parameter(alias="lg",defaultValue="JAVA")
	private String language;
	public ThriftServicePlugin() {
	}
	@Override
	protected String getTemplateFolder() {
		return ThriftServiceDecoratorConfiguration.DEFAULT_TEMPLATE_FOLDER;
	}

	@Override
	public void execute() throws MojoExecutionException, MojoFailureException {
		ThriftServiceDecoratorGenerator.main(makeArgs().toArray(new String[0]));
	}

	@Override
	protected List<String> makeArgs() {
		List<String> args = super.makeArgs();
		args.add("--" + ThriftServiceDecoratorConfiguration.INTERFACE_CLASS_OPTION_LONG);
		args.add(interfaceClass);
		args.add("--" + ThriftServiceDecoratorConfiguration.PACKAGE_OPTION_LONG);
		args.add(pkg);
		if(null != refClass){
			args.add("--" + ThriftServiceDecoratorConfiguration.REFERENCE_CLASS_OPTION_LONG);
			args.add(refClass);
		}
		args.add("--" + ThriftServiceDecoratorConfiguration.TASK_TYPE_OPTION_LONG);
		args.add(taskType);
		args.add("--" + ThriftServiceDecoratorConfiguration.LANGUAGE_OPTION_LONG);
		args.add(language);
		if(null !=thriftPackage){
			args.add("--" + ThriftServiceDecoratorConfiguration.THRIFT_CLIENT_PKG_OPTION_LONG);
			args.add(thriftPackage);
		}
		
		return args;
	}

}
