/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.thrift;

import com.google.common.base.Strings;
import java.util.List;
import net.gdface.codegen.plugin.BasePlugin;
import net.gdface.codegen.thrift.ThriftServiceDecoratorGenerator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate")
public class ThriftServicePlugin
extends BasePlugin {
    @Parameter(required=true)
    private String interfaceClass;
    @Parameter(required=false)
    private String refClass = null;
    @Parameter(alias="package", required=true)
    private String pkg;
    @Parameter(required=false)
    private String thriftPackage = null;
    @Parameter(alias="gt", required=true)
    private String taskType;
    @Parameter(alias="lg", defaultValue="JAVA")
    private String language;
    @Parameter(alias="cg")
    private String config;
    @Parameter
    private String sourcePath;
    @Parameter
    private String classPath;
    @Parameter
    private String requiredTags;

    protected String getTemplateFolder() {
        return "thrift";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        ThriftServiceDecoratorGenerator.main((String[])this.makeArgs().toArray(new String[0]));
    }

    protected List<String> makeArgs() {
        List args = super.makeArgs();
        args.add("--interface-class");
        args.add(this.interfaceClass);
        args.add("--package");
        args.add(this.pkg);
        if (!Strings.isNullOrEmpty((String)this.refClass)) {
            args.add("--reference-class");
            args.add(this.refClass);
        }
        args.add("--task-type");
        args.add(this.taskType);
        args.add("--language");
        args.add(this.language);
        if (!Strings.isNullOrEmpty((String)this.thriftPackage)) {
            args.add("--thrift-package");
            args.add(this.thriftPackage);
        }
        if (!Strings.isNullOrEmpty((String)this.config)) {
            args.add("--config");
            args.add(this.config);
        }
        if (null != this.sourcePath) {
            args.add("--source-path");
            args.add(this.sourcePath);
        }
        if (null != this.classPath) {
            args.add("--class-path");
            args.add(this.classPath);
        }
        if (null != this.requiredTags) {
            args.add("--tags");
            args.add(this.requiredTags);
        }
        return args;
    }
}

