package net.gdface.codegen.thrift;

import java.util.List;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

import com.google.common.base.Strings;

import net.gdface.codegen.plugin.BasePlugin;

/**
 * {@link ThriftServiceDecoratorGenerator}生成器运行插件
 * @author guyadong
 *
 */
@Mojo(name = "generate")
public class ThriftServicePlugin extends BasePlugin{
	/**
	 * interface class name
	 */
	@Parameter(required = true)
	private String interfaceClass;
	/**
	 * reference class name
	 */
	@Parameter(required = false)
	private String refClass = null;
	/**
	 * package name for generate class
	 */
	@Parameter(alias="package",required =true)
	private String pkg ;
	/**
	 * package for thrift client class
	 */
	@Parameter(required = false)
	private String thriftPackage = null;
	@Parameter(alias="gt",required =true)
	private String taskType;
	/**
	 * language of  generated code 
	 */
	@Parameter(alias="lg",defaultValue="JAVA")
	private String language;
	/**
	 * config file
	 */
	@Parameter(alias="cg")
	private String config;
	/**
	 * path list of source separated by semicolon
	 */
	@Parameter()
	private String sourcePath;
	/**
	 * Specifies the paths where javadoc will look for referenced classes (.class files)
	 */
	@Parameter()
	private String classPath;
	/**
	 * comma separated tag list for filtering service port,default:empty
	 */
	@Parameter()
	private String requiredTags;
	public ThriftServicePlugin() {
	}
	@Override
	protected String getTemplateFolder() {
		return ThriftServiceDecoratorConfiguration.DEFAULT_TEMPLATE_FOLDER;
	}

	@Override
	public void execute() throws MojoExecutionException, MojoFailureException {
		ThriftServiceDecoratorGenerator.main(makeArgs().toArray(new String[0]));
	}

	@Override
	protected List<String> makeArgs() {
		List<String> args = super.makeArgs();
		args.add("--" + ThriftServiceDecoratorConfiguration.INTERFACE_CLASS_OPTION_LONG);
		args.add(interfaceClass);
		args.add("--" + ThriftServiceDecoratorConfiguration.PACKAGE_OPTION_LONG);
		args.add(pkg);
		if(!Strings.isNullOrEmpty(refClass)){
			args.add("--" + ThriftServiceDecoratorConfiguration.REFERENCE_CLASS_OPTION_LONG);
			args.add(refClass);
		}
		args.add("--" + ThriftServiceDecoratorConfiguration.TASK_TYPE_OPTION_LONG);
		args.add(taskType);
		args.add("--" + ThriftServiceDecoratorConfiguration.LANGUAGE_OPTION_LONG);
		args.add(language);
		if(!Strings.isNullOrEmpty(thriftPackage)){
			args.add("--" + ThriftServiceDecoratorConfiguration.THRIFT_CLIENT_PKG_OPTION_LONG);
			args.add(thriftPackage);
		}
		if(!Strings.isNullOrEmpty(config)){
			args.add("--" + ThriftServiceDecoratorConfiguration.CONFIG_OPTION_LONG);
			args.add(config);
		}
		if(null != sourcePath){
			args.add("--" + ThriftServiceDecoratorConfiguration.SOURCE_PREFIX_OPTION_LONG);
			args.add(sourcePath);
		}
		if(null != classPath){
			args.add("--" + ThriftServiceDecoratorConfiguration.CLASS_PATH_OPTION_LONG);
			args.add(classPath);
		}
		if(null != requiredTags){
			args.add("--" + ThriftServiceDecoratorConfiguration.TAGS_OPTION_LONG);
			args.add(requiredTags);
		}
		return args;
	}

}
