/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.thrift;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.gdface.codegen.plugin.BasePlugin;
import net.gdface.codegen.thrift.ThriftServiceDecoratorGenerator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate")
public class ThriftServicePlugin
extends BasePlugin {
    @Parameter(required=true, property="codegen.thrift.interfaceClass")
    private String interfaceClass;
    @Parameter(required=false, property="codegen.thrift.refClass")
    private String refClass = null;
    @Parameter(alias="package", required=true, property="codegen.thrift.pkg")
    private String pkg;
    @Parameter(required=false, property="codegen.thrift.thriftPackage")
    private String thriftPackage = null;
    @Parameter(alias="gt", required=true, property="codegen.thrift.taskType")
    private String taskType;
    @Parameter(alias="lg", defaultValue="JAVA", property="codegen.thrift.language")
    private String language;
    @Parameter(alias="cg", property="codegen.thrift.config")
    private String config;
    @Parameter(property="codegen.thrift.sourcePath")
    private String sourcePath;
    @Parameter(property="codegen.thrift.classPath")
    private String classPath;
    @Parameter(property="codegen.thrift.requiredTags")
    private String requiredTags;
    @Parameter(property="codegen.thrift.commonTypes")
    private String commonTypes;
    @Parameter(property="codegen.thrift.erpcProgram")
    private String erpcProgram;
    @Parameter
    private String erpcPortPrefix;
    @Parameter(property="codegen.thrift.excludeMethods")
    private Map<String, String> excludeMethods = ImmutableMap.of();
    @Parameter(property="codegen.thrift.includeMethods")
    private Map<String, String> includeMethods = ImmutableMap.of();
    @Parameter(property="codegen.thrift.excludeFields")
    private Map<String, String> excludeFields = ImmutableMap.of();
    @Parameter(property="codegen.thrift.thriftServiceClass")
    private String thriftServiceClass;
    @Parameter(property="codegen.thrift.erpcForwardPort")
    private int erpcForwardPort = 0;
    @Parameter(property="codegen.thrift.erpcProxyPort")
    private int erpcProxyPort = 0;
    @Parameter(property="codegen.thrift.defaultMaxLength")
    private int defaultMaxLength = 0;
    @Parameter(property="codegen.thrift.errmsgMaxLength")
    private int errmsgMaxLength = 0;
    @Parameter(property="codegen.thrift.binaryOutputSize")
    private int binaryOutputSize = 0;
    @Parameter(property="codegen.thrift.extStructs")
    private String extStructs;
    @Parameter
    private String excludeVMs;
    @Parameter
    private String includeVMs;

    protected String getTemplateFolder() {
        return "thrift";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        ThriftServiceDecoratorGenerator.main((String[])this.makeArgs().toArray(new String[0]));
    }

    protected List<String> makeArgs() {
        List args = super.makeArgs();
        args.add("--interface-class");
        args.add(this.interfaceClass);
        args.add("--package");
        args.add(this.pkg);
        if (!Strings.isNullOrEmpty((String)this.refClass)) {
            args.add("--reference-class");
            args.add(this.refClass);
        }
        args.add("--task-type");
        args.add(this.taskType);
        args.add("--language");
        args.add(this.language);
        if (!Strings.isNullOrEmpty((String)this.thriftPackage)) {
            args.add("--thrift-package");
            args.add(this.thriftPackage);
        }
        if (!Strings.isNullOrEmpty((String)this.config)) {
            args.add("--config");
            args.add(this.config);
        }
        if (null != this.sourcePath) {
            args.add("--source-path");
            args.add(this.sourcePath);
        }
        if (null != this.classPath) {
            args.add("--class-path");
            args.add(this.classPath);
        }
        if (null != this.requiredTags) {
            args.add("--tags");
            args.add(this.requiredTags);
        }
        if (null != this.commonTypes) {
            args.add("--common-types");
            args.add(this.commonTypes);
        }
        if (null != this.erpcProgram) {
            args.add("--erpc-program");
            args.add(this.erpcProgram);
        }
        if (null != this.erpcPortPrefix) {
            args.add("--erpc-port-prefix");
            args.add(this.erpcPortPrefix);
        }
        if (!this.excludeMethods.isEmpty()) {
            for (Map.Entry<String, String> entry : this.excludeMethods.entrySet()) {
                args.add("--exclude-methods");
                args.add(entry.getKey() + ":" + entry.getValue());
            }
        }
        if (!this.includeMethods.isEmpty()) {
            for (Map.Entry<String, String> entry : this.includeMethods.entrySet()) {
                args.add("--include-methods");
                args.add(entry.getKey() + ":" + entry.getValue());
            }
        }
        if (!this.excludeFields.isEmpty()) {
            for (Map.Entry<String, String> entry : this.excludeFields.entrySet()) {
                args.add("--exclude-fields");
                args.add(entry.getKey() + ":" + entry.getValue());
            }
        }
        if (null != this.thriftServiceClass) {
            args.add("--thrift-service-class");
            args.add(this.thriftServiceClass);
        }
        if (this.erpcForwardPort > 0) {
            args.add("--erpc-forward-port");
            args.add(Integer.toString(this.erpcForwardPort));
        }
        if (this.erpcProxyPort > 0) {
            args.add("--erpc-proxy-port");
            args.add(Integer.toString(this.erpcProxyPort));
        }
        if (this.defaultMaxLength > 0) {
            args.add("--erpc-default-max-length");
            args.add(Integer.toString(this.defaultMaxLength));
        }
        if (this.errmsgMaxLength > 0) {
            args.add("--erpc-errmsg-max-length");
            args.add(Integer.toString(this.errmsgMaxLength));
        }
        if (this.binaryOutputSize > 0) {
            args.add("--erpc-binary-output-size");
            args.add(Integer.toString(this.binaryOutputSize));
        }
        if (null != this.extStructs) {
            args.add("--ext-structs");
            args.add(this.extStructs);
        }
        if (null != this.excludeVMs) {
            args.add("--exclude-vms");
            args.add(this.excludeVMs);
        }
        if (null != this.includeVMs) {
            args.add("--include-vms");
            args.add(this.includeVMs);
        }
        return args;
    }
}

