/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.thrift;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import net.gdface.codegen.thrift.CxxHelper;

public class CxxTypeMeta {
    public static final CxxTypeMeta BOOL = new CxxTypeMeta(ThriftProtocolType.TYPE_BOOL, "bool");
    public static final CxxTypeMeta BYTE = new CxxTypeMeta(ThriftProtocolType.TYPE_I8, "int8_t");
    public static final CxxTypeMeta DOUBLE = new CxxTypeMeta(ThriftProtocolType.TYPE_DOUBLE, "double");
    public static final CxxTypeMeta I16 = new CxxTypeMeta(ThriftProtocolType.TYPE_I16, "int16_t");
    public static final CxxTypeMeta I32 = new CxxTypeMeta(ThriftProtocolType.TYPE_I32, "int32_t");
    public static final CxxTypeMeta I64 = new CxxTypeMeta(ThriftProtocolType.TYPE_I64, "int64_t");
    public static final CxxTypeMeta STRING = new CxxTypeMeta(ThriftProtocolType.TYPE_STRING, "std::string");
    public static final CxxTypeMeta BINARY = new CxxTypeMeta(ThriftProtocolType.TYPE_BINARY, "std::string");
    public static final CxxTypeMeta VOID = new CxxTypeMeta(ThriftProtocolType.TYPE_VOID, "void");
    private Supplier<String> arraySupplier = new Supplier<String>(){

        public String get() {
            StringBuilder sb = new StringBuilder();
            sb.append("std::vector<").append(CxxTypeMeta.this.valueType.getType()).append(">");
            return sb.toString();
        }
    };
    private Supplier<String> listSupplier = new Supplier<String>(){

        public String get() {
            StringBuilder sb = new StringBuilder();
            sb.append("std::vector<").append(CxxTypeMeta.this.valueType.getType()).append(">");
            return sb.toString();
        }
    };
    private Supplier<String> setSupplier = new Supplier<String>(){

        public String get() {
            StringBuilder sb = new StringBuilder();
            sb.append("std::set<").append(CxxTypeMeta.this.valueType.getType()).append(">");
            return sb.toString();
        }
    };
    private Supplier<String> mapSupplier = new Supplier<String>(){

        public String get() {
            StringBuilder sb = new StringBuilder();
            sb.append("std::map<").append(CxxTypeMeta.this.keyType.getType()).append(",").append(CxxTypeMeta.this.valueType.getType()).append(">");
            return sb.toString();
        }
    };
    private final ThriftProtocolType protocolType;
    private final CxxTypeMeta keyType;
    private final CxxTypeMeta valueType;
    private final Supplier<String> type;
    private final boolean isArray;

    static CxxTypeMeta struct(String cxxType) {
        NameSupplier supplier = new NameSupplier(cxxType);
        return new CxxTypeMeta(ThriftProtocolType.TYPE_STRUCT, supplier);
    }

    static CxxTypeMeta enumType(String cxxType) {
        NameSupplier supplier = new NameSupplier(cxxType);
        return new CxxTypeMeta(ThriftProtocolType.TYPE_ENUM, supplier);
    }

    static <K, V> CxxTypeMeta map(CxxTypeMeta keyType, CxxTypeMeta valueType) {
        if (null == valueType || null == valueType) {
            return null;
        }
        return new CxxTypeMeta(ThriftProtocolType.TYPE_MAP, keyType, valueType, false);
    }

    static <E> CxxTypeMeta set(CxxTypeMeta valueType) {
        if (null == valueType) {
            return null;
        }
        return new CxxTypeMeta(ThriftProtocolType.TYPE_SET, null, valueType, false);
    }

    static <E> CxxTypeMeta list(CxxTypeMeta valueType) {
        if (null == valueType) {
            return null;
        }
        return new CxxTypeMeta(ThriftProtocolType.TYPE_LIST, null, valueType, false);
    }

    static CxxTypeMeta array(CxxTypeMeta valueType) {
        if (null == valueType) {
            return null;
        }
        return new CxxTypeMeta(ThriftProtocolType.TYPE_LIST, null, valueType, true);
    }

    private CxxTypeMeta(ThriftProtocolType protocolType, CxxTypeMeta keyType, CxxTypeMeta valueType, boolean isArray) {
        Preconditions.checkArgument((null != protocolType ? 1 : 0) != 0, (Object)"protocolType is null");
        Preconditions.checkArgument((protocolType.equals((Object)ThriftProtocolType.TYPE_BINARY) || protocolType.isContainer ? 1 : 0) != 0, (Object)"protocolType must be SET,MAP,LIST,BINARY");
        if (isArray) {
            Preconditions.checkArgument((protocolType.equals((Object)ThriftProtocolType.TYPE_LIST) || protocolType.equals((Object)ThriftProtocolType.TYPE_BINARY) ? 1 : 0) != 0, (Object)"protocolType must be LIST or BINARY,if isArray");
            if (protocolType.equals((Object)ThriftProtocolType.TYPE_BINARY)) {
                Preconditions.checkArgument((boolean)BYTE.equals(valueType), (Object)"valueType must be BYTE,if isArray is true and protocolType is TYPE_LIST");
            }
        }
        this.protocolType = protocolType;
        this.isArray = isArray;
        this.type = isArray ? this.arraySupplier : protocolType.getTypeSupplier(this);
        this.keyType = keyType;
        this.valueType = (CxxTypeMeta)Preconditions.checkNotNull((Object)valueType, (Object)"valueType is null");
    }

    private CxxTypeMeta(ThriftProtocolType protocolType, String cxxType) {
        this(protocolType, (Supplier<String>)Suppliers.ofInstance((Object)Preconditions.checkNotNull((Object)cxxType, (Object)"cxxType is null")));
    }

    private CxxTypeMeta(ThriftProtocolType protocolType, Supplier<String> cxxType) {
        Preconditions.checkNotNull((Object)((Object)protocolType), (Object)"protocolType is null");
        Preconditions.checkArgument((!protocolType.isContainer ? 1 : 0) != 0, (Object)"protocolType must not be SET,MAP,LIST");
        Preconditions.checkNotNull(cxxType, (Object)"cxxType is null");
        this.protocolType = protocolType;
        this.isArray = false;
        this.type = cxxType;
        this.keyType = null;
        this.valueType = null;
    }

    public String getType() {
        return (String)this.type.get();
    }

    public String getSampleType() {
        if (this.protocolType == ThriftProtocolType.TYPE_STRUCT || this.protocolType == ThriftProtocolType.TYPE_ENUM) {
            return CxxHelper.simpleName((String)this.type.get());
        }
        return (String)this.type.get();
    }

    public String getFullType() {
        if (this.type instanceof NameSupplier) {
            return ((NameSupplier)this.type).cxxType;
        }
        return (String)this.type.get();
    }

    public String getNamespace() {
        if (this.type instanceof NameSupplier) {
            return CxxHelper.getCxxNamespace(((NameSupplier)this.type).cxxType);
        }
        return CxxHelper.getCxxNamespace((String)this.type.get());
    }

    public CxxTypeMeta getKeyType() {
        Preconditions.checkState((this.keyType != null ? 1 : 0) != 0, (String)"%s does not have a key", (Object)((Object)this.protocolType));
        return this.keyType;
    }

    public CxxTypeMeta getValueType() {
        Preconditions.checkState((this.valueType != null ? 1 : 0) != 0, (String)"%s does not have a value", (Object)((Object)this.protocolType));
        return this.valueType;
    }

    public ThriftProtocolType getProtocolType() {
        return this.protocolType;
    }

    public boolean isBool() {
        return ThriftProtocolType.TYPE_BOOL.equals((Object)this.getProtocolType());
    }

    public boolean isVoid() {
        return ThriftProtocolType.TYPE_VOID.equals((Object)this.getProtocolType());
    }

    public boolean isString() {
        return ThriftProtocolType.TYPE_STRING.equals((Object)this.getProtocolType());
    }

    public boolean isBinary() {
        return ThriftProtocolType.TYPE_BINARY.equals((Object)this.getProtocolType());
    }

    public boolean isMap() {
        return ThriftProtocolType.TYPE_MAP.equals((Object)this.getProtocolType());
    }

    public boolean isSet() {
        return ThriftProtocolType.TYPE_SET.equals((Object)this.getProtocolType());
    }

    public boolean isList() {
        return ThriftProtocolType.TYPE_LIST.equals((Object)this.getProtocolType());
    }

    public boolean isEnum() {
        return ThriftProtocolType.TYPE_ENUM.equals((Object)this.getProtocolType());
    }

    public boolean isStruct() {
        return ThriftProtocolType.TYPE_STRUCT.equals((Object)this.getProtocolType());
    }

    public boolean isContainer() {
        return this.getProtocolType().isContainer;
    }

    public boolean isBaseType() {
        return this.getProtocolType().isBaseType;
    }

    public boolean isNumber() {
        return this.getProtocolType().isNumber;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isByValue() {
        return this.isBool() || this.isNumber() || this.isEnum();
    }

    public boolean isByReference() {
        return !this.isByValue() && !this.isVoid();
    }

    public boolean isCanMove() {
        return this.isBinary() || this.isString() || this.isContainer() || this.isStruct();
    }

    public CxxTypeMeta castName(String name) {
        Preconditions.checkArgument((null != name ? 1 : 0) != 0, (Object)"ns is null");
        Preconditions.checkArgument((this.isEnum() || this.isStruct() ? 1 : 0) != 0, (Object)"only ENUM or STRUCT can be cast namespace");
        return new CxxTypeMeta(this.protocolType, this.getNamespace() + "::" + name);
    }

    public CxxTypeMeta cast(String cxxType) {
        Preconditions.checkArgument((null != cxxType ? 1 : 0) != 0, (Object)"cxxType is null");
        return new CxxTypeMeta(this.protocolType, cxxType);
    }

    public CxxTypeMeta cast(CxxTypeMeta keyType, CxxTypeMeta valueType, boolean isArray) {
        return new CxxTypeMeta(this.protocolType, keyType, valueType, isArray);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CxxTypeMeta [protocolType=");
        builder.append((Object)this.protocolType);
        builder.append(", type=");
        builder.append((String)this.type.get());
        builder.append(", isArray=");
        builder.append(this.isArray);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.protocolType == null ? 0 : this.protocolType.hashCode());
        result = 31 * result + (this.type == null ? 0 : ((String)this.type.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CxxTypeMeta other = (CxxTypeMeta)obj;
        if (this.protocolType != other.protocolType) {
            return false;
        }
        return !(this.type == null ? other.type != null : !((String)this.type.get()).equals(other.type.get()));
    }

    private static class NameSupplier
    implements Supplier<String> {
        private String cxxType;

        public NameSupplier(String cxxType) {
            Preconditions.checkArgument((null != cxxType ? 1 : 0) != 0, (Object)"cxxType is null");
            this.cxxType = cxxType;
        }

        public String get() {
            return CxxHelper.getTypeName(this.cxxType);
        }
    }

    static enum ThriftProtocolType {
        TYPE_VOID(true, false, false),
        TYPE_STRING(true, false, false),
        TYPE_BOOL(true, false, false),
        TYPE_I8(true, false, true),
        TYPE_I16(true, false, true),
        TYPE_I32(true, false, true),
        TYPE_I64(true, false, true),
        TYPE_DOUBLE(true, false, true),
        TYPE_BINARY(true, false, false),
        TYPE_STRUCT(false, false, false),
        TYPE_MAP(false, true, false),
        TYPE_SET(false, true, false),
        TYPE_LIST(false, true, false),
        TYPE_ENUM(false, false, false);

        public final boolean isBaseType;
        public final boolean isContainer;
        public final boolean isNumber;

        private ThriftProtocolType(boolean isBaseType, boolean isContainer, boolean isNumber) {
            this.isBaseType = isBaseType;
            this.isContainer = isContainer;
            this.isNumber = isNumber;
        }

        private Supplier<String> getTypeSupplier(CxxTypeMeta meta) {
            switch (this) {
                case TYPE_MAP: {
                    return meta.mapSupplier;
                }
                case TYPE_SET: {
                    return meta.setSupplier;
                }
                case TYPE_LIST: {
                    return meta.listSupplier;
                }
            }
            return meta.type;
        }
    }
}

