/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.thrift;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.gdface.annotation.DeriveMethod;
import net.gdface.codegen.thrift.ThriftServiceDecoratorConfiguration;
import net.gdface.utils.FaceUtilits;
import org.apache.commons.configuration2.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodFilter
implements Predicate<Method> {
    private static final Logger logger = LoggerFactory.getLogger(MethodFilter.class);
    private static final String SUFFIX_INCLUDE = ".include";
    private static final String SUFFIX_EXCLUDE = ".exclude";
    private final Configuration configuration = ThriftServiceDecoratorConfiguration.INSTANCE.getConfig();
    private Set<Method> includeMethods;
    private Set<Method> excludeMethods;

    public MethodFilter(Class<?> interfaceClass) {
        Preconditions.checkArgument((interfaceClass != null ? 1 : 0) != 0, (Object)"interfaceClass is null");
        ImmutableMap methods = Maps.uniqueIndex(Arrays.asList(interfaceClass.getDeclaredMethods()), (Function)new Function<Method, String>(){

            public String apply(Method input) {
                StringBuffer buffer = new StringBuffer(input.getName());
                DeriveMethod dm = input.getAnnotation(DeriveMethod.class);
                if (dm != null && dm.methodSuffix().length > 0) {
                    buffer.append('.').append(dm.methodSuffix()[0]);
                }
                return buffer.toString();
            }
        });
        String includeKey = interfaceClass.getName() + SUFFIX_INCLUDE;
        String excludeKey = interfaceClass.getName() + SUFFIX_EXCLUDE;
        this.includeMethods = this.getMethodList(includeKey, interfaceClass, (Map<String, Method>)methods);
        this.excludeMethods = this.getMethodList(excludeKey, interfaceClass, (Map<String, Method>)methods);
        if (!this.includeMethods.isEmpty() && !this.excludeMethods.isEmpty()) {
            logger.warn("{} and {} all defined, this first used preferentially", (Object)includeKey, (Object)excludeKey);
        }
    }

    private Set<Method> getMethodList(String key, Class<?> interfaceClass, Map<String, Method> methods) {
        HashSet sets = Sets.newHashSet();
        if (this.configuration.containsKey(key)) {
            for (String port : FaceUtilits.elementsOf((String)this.configuration.getString(key))) {
                if (!methods.containsKey(port)) {
                    logger.warn("NOT FOUND Method named '{}' in {}", (Object)port, (Object)interfaceClass.getName());
                    continue;
                }
                sets.add(methods.get(port));
            }
        }
        return sets;
    }

    public boolean apply(Method input) {
        if (!this.includeMethods.isEmpty()) {
            return this.includeMethods.contains(input);
        }
        if (!this.excludeMethods.isEmpty()) {
            return !this.excludeMethods.contains(input);
        }
        return true;
    }
}

