/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.thrift;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.gdface.codegen.Method;
import net.gdface.codegen.thrift.CxxHelper;
import net.gdface.codegen.thrift.CxxType;
import net.gdface.codegen.thrift.CxxTypeMeta;
import net.gdface.codegen.thrift.ThriftConstants;
import net.gdface.codegen.thrift.ThriftServiceDecorator;
import net.gdface.codegen.thrift.ThriftServiceDecoratorConfiguration;
import net.gdface.codegen.thrift.ThriftStructDecorator;
import net.gdface.thrift.ThriftUtils;
import net.gdface.thrift.TypeTransformer;
import net.gdface.thrift.exception.ServiceRuntimeException;
import net.gdface.utils.BeanRelativeUtilits;
import net.gdface.utils.NameStringUtils;

public class ThriftSchema
implements ThriftConstants {
    private final Set<ThriftStructDecorator> thriftStructDecorators = Sets.newLinkedHashSet();
    private final Set<ThriftStructDecorator> thriftStructs = Sets.newLinkedHashSet();
    private final List<ThriftServiceDecorator<?>> thriftServiceDecorators = Lists.newLinkedList();
    private final Predicate<ThriftStructDecorator> exceptionFilter = new Predicate<ThriftStructDecorator>(){

        public boolean apply(ThriftStructDecorator input) {
            return input.isException();
        }
    };
    private final Predicate<ThriftStructDecorator> enumFilter = new Predicate<ThriftStructDecorator>(){

        public boolean apply(ThriftStructDecorator input) {
            return input.isEnum();
        }
    };
    private final Predicate<ThriftStructDecorator> beanFilter = new Predicate<ThriftStructDecorator>(){

        public boolean apply(ThriftStructDecorator input) {
            return input.isBean();
        }
    };
    private final Predicate<ThriftStructDecorator> findString = new Predicate<ThriftStructDecorator>(){

        public boolean apply(ThriftStructDecorator input) {
            return null != input && input.isUseString();
        }
    };
    private final Predicate<ThriftStructDecorator> findMap = new Predicate<ThriftStructDecorator>(){

        public boolean apply(ThriftStructDecorator input) {
            return null != input && input.isUseMap();
        }
    };
    private final Predicate<ThriftStructDecorator> findSet = new Predicate<ThriftStructDecorator>(){

        public boolean apply(ThriftStructDecorator input) {
            return null != input && input.isUseSet();
        }
    };
    private final Predicate<ThriftStructDecorator> findVector = new Predicate<ThriftStructDecorator>(){

        public boolean apply(ThriftStructDecorator input) {
            return null != input && input.isUseVector();
        }
    };
    private final Predicate<ThriftStructDecorator> findException = new Predicate<ThriftStructDecorator>(){

        public boolean apply(ThriftStructDecorator input) {
            return null != input && input.isException();
        }
    };

    public ThriftSchema(Map<Class<?>, Class<?>> interfaceClasses) {
        for (Map.Entry<Class<?>, Class<?>> entry : interfaceClasses.entrySet()) {
            Class<?> interfaceClass = entry.getKey();
            Class<?> refClass = entry.getValue();
            if (refClass == ThriftServiceDecoratorConfiguration.DEF_REF_CLASS) {
                refClass = null;
            }
            ThriftServiceDecorator service = new ThriftServiceDecorator(interfaceClass, refClass);
            this.thriftServiceDecorators.add(service);
        }
        if (!this.compile()) {
            throw new IllegalStateException("compile fail");
        }
    }

    public List<ThriftStructDecorator> getAllStructDecorators() {
        return Lists.newArrayList(this.thriftStructDecorators);
    }

    public List<ThriftStructDecorator> getExceptionDecorators() {
        return Lists.newArrayList((Iterable)Sets.filter(this.thriftStructDecorators, this.exceptionFilter));
    }

    public List<ThriftStructDecorator> getEnumDecorators() {
        return Lists.newArrayList((Iterable)Sets.filter(this.thriftStructDecorators, this.enumFilter));
    }

    public List<ThriftStructDecorator> getBeanDecorators() {
        return Lists.newArrayList((Iterable)Sets.filter(this.thriftStructDecorators, this.beanFilter));
    }

    public List<ThriftServiceDecorator<?>> getThriftServiceDecorators() {
        return this.thriftServiceDecorators;
    }

    private boolean compile() {
        for (ThriftServiceDecorator<?> thriftServiceDecorator : this.getThriftServiceDecorators()) {
            if (!thriftServiceDecorator.compile()) {
                return false;
            }
            this.thriftStructDecorators.addAll(thriftServiceDecorator.getDecorateTypes());
            this.thriftStructs.addAll(thriftServiceDecorator.getThriftTypes());
        }
        for (ThriftStructDecorator thriftStructDecorator : this.getAllStructDecorators()) {
            if (!thriftStructDecorator.compile()) {
                return false;
            }
            this.thriftStructDecorators.addAll(thriftStructDecorator.getDecorateTypes());
            this.thriftStructs.addAll(thriftStructDecorator.getThriftTypes());
        }
        return true;
    }

    public boolean isThriftBuildinType(Type type) {
        return ThriftUtils.isThriftBuildinType((Type)type);
    }

    public boolean isCastType(Type type) {
        return ThriftUtils.isCastType((Type)type);
    }

    public boolean isDecoratorType(Type type) {
        return this.getDecoratorType(type) != null;
    }

    public ThriftStructDecorator getDecoratorType(final Type type) {
        Optional result = Iterables.tryFind(this.thriftStructDecorators, (Predicate)new Predicate<ThriftStructDecorator>(){

            public boolean apply(ThriftStructDecorator input) {
                return input.getBaseClass().equals(type);
            }
        });
        return result.isPresent() ? (ThriftStructDecorator)result.get() : null;
    }

    public boolean isThriftStruct(Type type) {
        return ThriftUtils.isThriftStruct((Type)type);
    }

    public boolean isPrimitivefloat(Type type) {
        return ThriftUtils.isPrimitivefloat((Type)type);
    }

    public boolean isfloat(Type type) {
        return ThriftUtils.isfloat((Type)type);
    }

    public boolean isPrimitiveArray(Type type) {
        return ThriftUtils.isPrimitiveArray((Type)type);
    }

    public boolean isMap(Type type) {
        return TypeToken.of((Type)type).getRawType() == Map.class;
    }

    public boolean isList(Type type) {
        return TypeToken.of((Type)type).getRawType() == List.class;
    }

    public boolean isSet(Type type) {
        return TypeToken.of((Type)type).getRawType() == Set.class;
    }

    public boolean isCollection(Type type) {
        return this.isList(type) || this.isSet(type);
    }

    public boolean isArray(Type type) {
        return this.isList(type) || this.isSet(type);
    }

    public boolean isBinary(Type type) {
        return type == byte[].class;
    }

    public final Type wrap(Type type) {
        return TypeToken.of((Type)type).wrap().getType();
    }

    public String escapeThrift(String name) {
        return NameStringUtils.isThriftReserved((String)name) ? name + "_" : name;
    }

    public String escapeField(String name) {
        if (NameStringUtils.isJavaReserved((String)name)) {
            return "_" + name;
        }
        return this.escapeThrift(name);
    }

    public static boolean isIsLocalMethod(java.lang.reflect.Method method) {
        return ThriftUtils.isIsLocalMethod((java.lang.reflect.Method)method);
    }

    public static boolean isIsLocalMethod(Method method) {
        return ThriftUtils.isIsLocalMethod((java.lang.reflect.Method)method.delegate());
    }

    public Type[] getActualTypeArguments(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return new Type[0];
    }

    public Class<?> getServiceRuntimeExceptionClass() {
        return ServiceRuntimeException.class;
    }

    public Class<?> getTypeTransformerClass() {
        return TypeTransformer.class;
    }

    public String toStubType(Class<?> clazz) {
        Preconditions.checkArgument((null != clazz ? 1 : 0) != 0, (Object)"clazz is null");
        if (this.isThriftStruct(clazz) || Enum.class.isAssignableFrom(clazz) || this.isDecoratorType(clazz)) {
            return ThriftServiceDecoratorConfiguration.INSTANCE.getThriftClientPackage() + "." + clazz.getSimpleName();
        }
        throw new IllegalArgumentException(String.format("%s is not thrift stub type", clazz.getName()));
    }

    public String toStubCxxType(Class<?> clazz) {
        return CxxHelper.cxxNamespace("::" + this.toStubType(clazz), true);
    }

    public List<ThriftStructDecorator> getThriftStructDecorator(final String pkg) {
        ArrayList list = Lists.newArrayList((Iterable)Iterables.filter(this.thriftStructDecorators, (Predicate)new Predicate<ThriftStructDecorator>(){

            public boolean apply(ThriftStructDecorator input) {
                return input.getBaseClass().getPackage().getName().equals(pkg);
            }
        }));
        return Ordering.natural().sortedCopy((Iterable)list);
    }

    protected List<ThriftStructDecorator> getGenSequence(boolean thriftStructIncluded) {
        List<ThriftStructDecorator> types = this.getAllStructDecorators();
        if (thriftStructIncluded) {
            types.addAll(this.thriftStructs);
        }
        List list = BeanRelativeUtilits.sortByField(types, (String)"name");
        ArrayDeque<ThriftStructDecorator> seq = new ArrayDeque<ThriftStructDecorator>();
        for (ThriftStructDecorator struct : list) {
            this.traverseMember(struct, seq);
        }
        return Lists.newArrayList(seq.descendingIterator());
    }

    private void traverseMember(ThriftStructDecorator parent, Deque<ThriftStructDecorator> seq) {
        if (!seq.contains(parent)) {
            List members = BeanRelativeUtilits.sortByField(parent.getDecorateTypes(), (String)"name");
            for (ThriftStructDecorator struct : members) {
                this.traverseMember(struct, seq);
            }
            seq.push(parent);
        }
    }

    public ListMultimap<String, Collection<ThriftStructDecorator>> getStructGenSequenceAsMultimap(boolean thriftStructIncluded) {
        List<ThriftStructDecorator> seqlist = this.getGenSequence(thriftStructIncluded);
        seqlist.add(new ThriftStructDecorator(this.getServiceRuntimeExceptionClass()));
        LinkedListMultimap seq = LinkedListMultimap.create();
        String curPkg = null;
        List sub = null;
        for (ThriftStructDecorator struct : seqlist) {
            String pkg = struct.getPackage();
            if (!pkg.equals(curPkg)) {
                if (null != curPkg) {
                    seq.put(curPkg, (Object)sub);
                }
                sub = Lists.newLinkedList();
                curPkg = struct.getPackage();
            }
            sub.add(struct);
        }
        if (null != curPkg) {
            seq.put(curPkg, sub);
        }
        return seq;
    }

    public boolean isUseStringInTypes() {
        return Iterables.tryFind(this.thriftStructDecorators, this.findString).isPresent();
    }

    public boolean isUseMapInTypes() {
        return Iterables.tryFind(this.thriftStructDecorators, this.findMap).isPresent();
    }

    public boolean isUseSetInTypes() {
        return Iterables.tryFind(this.thriftStructDecorators, this.findSet).isPresent();
    }

    public boolean isUseVectorInTypes() {
        return Iterables.tryFind(this.thriftStructDecorators, this.findVector).isPresent();
    }

    public boolean isUseExceptionInTypes() {
        return Iterables.tryFind(this.thriftStructDecorators, this.findException).isPresent();
    }

    public boolean isCanMove(CxxType cxxType) {
        if (null == cxxType) {
            return false;
        }
        CxxTypeMeta uiType = cxxType.getUiType();
        if (uiType.isCanMove() && !uiType.isStruct()) {
            return true;
        }
        ThriftStructDecorator memSturct = this.getDecoratorType(cxxType.getJavaType());
        return null != memSturct && memSturct.isHasCanMoveField();
    }
}

