/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.thrift;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.gdface.annotation.AnnotationException;
import net.gdface.annotation.AnnotationRuntimeException;
import net.gdface.annotation.DeriveMethod;
import net.gdface.annotation.ServicePort;
import net.gdface.codegen.AbstractSchema;
import net.gdface.codegen.AnnotationUtils;
import net.gdface.codegen.InvalidAnnotationDefineException;
import net.gdface.codegen.InvalidNameException;
import net.gdface.codegen.Method;
import net.gdface.codegen.NewSourceInfoAbstract;
import net.gdface.codegen.ServiceInfo;
import net.gdface.codegen.thrift.CxxHelper;
import net.gdface.codegen.thrift.CxxType;
import net.gdface.codegen.thrift.CxxTypeMeta;
import net.gdface.codegen.thrift.MethodFilter;
import net.gdface.codegen.thrift.ThriftConstants;
import net.gdface.codegen.thrift.ThriftServiceDecoratorConfiguration;
import net.gdface.codegen.thrift.ThriftStructDecorator;
import net.gdface.codegen.thrift.TypeHelper;
import net.gdface.thrift.ThriftUtils;
import net.gdface.thrift.TypeTransformer;
import net.gdface.thrift.exception.ServiceRuntimeException;
import net.gdface.utils.NameStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftServiceDecorator<T>
extends NewSourceInfoAbstract<T>
implements ThriftConstants {
    private static final Logger logger = LoggerFactory.getLogger(ThriftServiceDecorator.class);
    private ServiceInfo serviceInfo;
    private final Map<Method, String> servicePorts = Maps.newHashMap();
    private final TypeHelper typeHelper = new TypeHelper((AbstractSchema)this);
    private String generatePackage;
    private String clientInterfaceName;
    private Boolean isUseStringInService = null;
    private Boolean isUseVectorInService = null;
    private Boolean isUseExceptionInService = null;
    private final Set<CxxTypeMeta> containerTypes = Sets.newHashSet((Object[])new CxxTypeMeta[]{CxxType.getThriftType(ThriftUtils.mapToken((TypeToken)TypeToken.of(String.class), (TypeToken)TypeToken.of(String.class)).getType()).getStubType()});
    private final Predicate<Class<?>> findMap = new Predicate<Class<?>>(){

        public boolean apply(Class<?> input) {
            return null == input ? false : Map.class.isAssignableFrom(input);
        }
    };
    private final Predicate<Class<?>> findSet = new Predicate<Class<?>>(){

        public boolean apply(Class<?> input) {
            return null == input ? false : Set.class.isAssignableFrom(input);
        }
    };
    private final CxxType cxxType;
    private final CxxTypeMeta stubCxxTypeMeta;
    private final String thriftClientPackage;
    private final Predicate<Method> tagsFilter;

    public ThriftServiceDecorator(Class<T> interfaceClass, Class<? extends T> refClass) {
        super(interfaceClass, refClass, null);
        TypeHelper.VERIFYTYPE_MONITOR.set(new Predicate<Type>(){

            public boolean apply(Type input) {
                Class rawType;
                if (null == ThriftServiceDecorator.this.isUseVectorInService && ((rawType = TypeToken.of((Type)input).getRawType()).isArray() && rawType.getComponentType() != Byte.TYPE || List.class.isAssignableFrom(rawType))) {
                    ThriftServiceDecorator.this.isUseVectorInService = Boolean.TRUE;
                }
                if (input instanceof Class) {
                    if (null == ThriftServiceDecorator.this.isUseStringInService && (String.class == input || byte[].class == input || input instanceof Class && ByteBuffer.class.isAssignableFrom((Class)input))) {
                        ThriftServiceDecorator.this.isUseStringInService = Boolean.TRUE;
                    }
                    if (null == ThriftServiceDecorator.this.isUseExceptionInService && Exception.class.isAssignableFrom((Class)input)) {
                        ThriftServiceDecorator.this.isUseExceptionInService = Boolean.TRUE;
                    }
                }
                try {
                    CxxTypeMeta meta = CxxType.getThriftType(input).getUiType();
                    if (meta.isContainer()) {
                        ThriftServiceDecorator.this.containerTypes.add(meta);
                    }
                }
                catch (Exception e) {
                    logger.debug(e.getMessage());
                }
                return false;
            }
        });
        this.thriftClientPackage = ThriftServiceDecoratorConfiguration.INSTANCE.getThriftClientPackage();
        this.clientInterfaceName = this.thriftClientPackage + "." + this.interfaceClass.getSimpleName();
        this.cxxType = CxxType.struct(interfaceClass);
        this.stubCxxTypeMeta = this.cxxType.getStubType().cast("::" + CxxHelper.cxxNamespace(this.clientInterfaceName, true));
        this.tagsFilter = new Predicate<Method>(){

            public boolean apply(Method input) {
                return input.tagsMatched(ThriftServiceDecoratorConfiguration.INSTANCE.getReqiredTags());
            }
        };
    }

    public boolean compile() {
        boolean compileOk = false;
        try {
            super.compile();
            this.serviceInfo = new ServiceInfo(AnnotationUtils.getServiceAnnotation((Class)this.interfaceClass));
            for (Method method : this.methodsNeedGenerated) {
                this.compile(method);
            }
            if (this.typeHelper.needTransformer()) {
                this.addImportedClass(new Type[]{TypeTransformer.class});
            }
            this.addImportedClass(new Type[]{ServiceRuntimeException.class});
            compileOk = true;
            TypeHelper.VERIFYTYPE_MONITOR.remove();
        }
        catch (AnnotationException e) {
            logger.error(e.toString());
        }
        catch (AnnotationRuntimeException e) {
            logger.error(e.toString());
        }
        return compileOk;
    }

    private final void compile(Method method) throws InvalidNameException {
        TypeHelper.checkNotGeneric(method);
        ThriftServiceDecorator.checkPortSuffix(method);
        String portName = this.getPortName(method);
        if (this.servicePorts.containsKey(portName)) {
            throw new InvalidNameException(String.format("duplicated method name %s", portName));
        }
        this.typeHelper.checkType(method);
        this.typeHelper.addReferTypes(method);
        this.servicePorts.put(method, portName);
        if (NameStringUtils.isThriftReserved((String)portName)) {
            logger.warn("portName(method name) '{}' of '{}' is thrift IDL reserved word", (Object)portName, (Object)this.getInterfaceClass().getName());
        }
        for (Method.Parameter param : method.getParameters()) {
            if (!NameStringUtils.isThriftReserved((String)param.getName())) continue;
            logger.warn("parameter name '{}' of method '{}' is thrift IDL reserved word", (Object)param.getName(), (Object)portName);
        }
    }

    private static void checkPortSuffix(Method method) throws InvalidNameException {
        ServicePort servicePort = (ServicePort)method.getAnnotation(ServicePort.class);
        if (null != servicePort && !servicePort.suffix().isEmpty() && !servicePort.suffix().matches("^\\w+$")) {
            throw new InvalidNameException(String.format("the suffix of annotation [%s] in method %s of %s must not have space char ", ServicePort.class.getSimpleName(), method.getName(), method.getDeclaringClass().getSimpleName()));
        }
    }

    protected void checkClass(Class<T> interfaceClass, Class<? extends T> refClass, Class<? extends T> baseClass) {
        Preconditions.checkNotNull(interfaceClass, (Object)"interfaceClass is null");
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("interfaceClass must be Interface(\u5fc5\u987b\u662f\u63a5\u53e3)");
        }
        TypeHelper.checkNotGeneric(interfaceClass);
        if (null != refClass) {
            if (!interfaceClass.isAssignableFrom(refClass) || refClass.isInterface()) {
                throw new IllegalArgumentException(String.format("refClass must  implement of [%s] (\u5fc5\u987b\u5b9e\u73b0\u63a5\u53e3)", interfaceClass.getName()));
            }
            if (!ThriftServiceDecorator.isFullImplemented(interfaceClass, refClass)) {
                logger.warn("{} not  implement all methods of [{}] (\u6ca1\u6709\u5b9e\u73b0\u63a5\u53e3\u6240\u6709\u65b9\u6cd5)", (Object)refClass.getName(), (Object)interfaceClass.getName());
            }
        }
    }

    protected void createMethodsNeedGenerated() {
        List methods = Lists.transform(Arrays.asList(this.interfaceClass.getMethods()), (Function)new Function<java.lang.reflect.Method, Method>(){

            public Method apply(java.lang.reflect.Method input) {
                return new Method(input, ThriftServiceDecorator.this.paramTable.getParameterNamesUnchecked(input.getName(), (Class[])input.getParameterTypes()));
            }
        });
        Iterable filteredByTags = Iterables.filter((Iterable)methods, this.tagsFilter);
        ArrayList filtered = Lists.newArrayList((Iterable)Iterables.filter((Iterable)filteredByTags, (Predicate)Predicates.compose((Predicate)new MethodFilter(this.interfaceClass), (Function)Method.TO_REFLECT_METHOD)));
        this.methodsNeedGenerated.addAll(filtered);
    }

    public ServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    public boolean isTargetType(Class<?> type) {
        return this.serviceInfo.getTargetType() == type;
    }

    public List<ThriftStructDecorator> getDecorateTypes() {
        return this.typeHelper.getDecorateTypes();
    }

    public List<ThriftStructDecorator> getThriftTypes() {
        return this.typeHelper.getThriftTypes();
    }

    public String toThriftType(Type type) {
        return this.typeHelper.toThriftType(type);
    }

    public String toClientThriftType(Type type) {
        return this.typeHelper.toClientThriftType(type);
    }

    public String toClientThriftyType(Type type) {
        return this.typeHelper.toClientThriftyType(type);
    }

    public boolean isClientThriftType(Type type) {
        return this.typeHelper.isClientThriftType(type);
    }

    public String toThriftyDecoratorType(Type type) {
        return this.typeHelper.toThriftyDecoratorType(type);
    }

    public String getClientInterfaceName() {
        return this.clientInterfaceName;
    }

    public String getPortName(Method method) {
        ServicePort servicePort = (ServicePort)method.getAnnotation(ServicePort.class);
        String portName = method.getName();
        if (null != servicePort) {
            portName = portName + servicePort.suffix();
        }
        return portName;
    }

    public String getGeneratePackage() {
        return this.generatePackage;
    }

    public void setGeneratePackage(String generatePackage) {
        this.generatePackage = generatePackage;
    }

    public void removeDecorateTypesFromImports() {
        Iterable it = Iterables.filter(this.typeHelper.getTypesWithDecorator(), (Predicate)new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return !input.isEnum();
            }
        });
        ArrayList types = Lists.newArrayList((Iterable)it);
        this.removeClassFromImports(types);
    }

    public void removeExceptionsFromImports() {
        this.removeClassFromImports(this.typeHelper.getReferExceptions());
    }

    public List<Class<?>> getReferExceptions() {
        return this.typeHelper.getReferExceptions();
    }

    public boolean isUseStringInService() {
        return Boolean.TRUE.equals(this.isUseStringInService);
    }

    public boolean isUseMapInService() {
        return Iterables.tryFind(this.getImportedList().values(), this.findMap).isPresent();
    }

    public boolean isUseSetInService() {
        return Iterables.tryFind(this.getImportedList().values(), this.findSet).isPresent();
    }

    public boolean isUseVectorInService() {
        return Boolean.TRUE.equals(this.isUseVectorInService);
    }

    public boolean isUseExceptionInService() {
        return Boolean.TRUE.equals(this.isUseExceptionInService);
    }

    public CxxTypeMeta makeStubCxxTypeMetaBySuffix(String suffix) {
        suffix = (String)MoreObjects.firstNonNull((Object)suffix, (Object)"");
        return this.stubCxxTypeMeta.castName(this.getInterfaceClass().getSimpleName() + suffix);
    }

    public CxxType getCxxType() {
        return this.cxxType;
    }

    public CxxTypeMeta getStubCxxTypeMeta() {
        return this.stubCxxTypeMeta;
    }

    public String getThriftClientNamespace() {
        return "::" + CxxHelper.cxxNamespace(this.thriftClientPackage);
    }

    public Set<CxxTypeMeta> getContainerTypes() {
        return this.containerTypes;
    }

    public DeriveMethod getDeriveMethodAnnotation(Method method) {
        try {
            return AnnotationUtils.getDeriveMethodAnnotation((Method)method, (ServiceInfo)this.serviceInfo);
        }
        catch (InvalidNameException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAnnotationDefineException e) {
            throw new RuntimeException(e);
        }
    }

    public String methodSuffix(Method method) {
        DeriveMethod deriveMethod = this.getDeriveMethodAnnotation(method);
        if (deriveMethod != null) {
            String[] suffixs = deriveMethod.methodSuffix();
            return suffixs != null && suffixs.length > 0 ? suffixs[0] : "";
        }
        return "";
    }
}

