/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.thrift;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.gdface.codegen.generator.CodeWriter;
import net.gdface.codegen.generator.CxxCodeWriter;
import net.gdface.codegen.generator.GeneratorConfiguration;
import net.gdface.codegen.generator.JavaCodeWriter;
import net.gdface.codegen.thrift.ThriftConstants;
import net.gdface.utils.FaceUtilits;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;

public class ThriftServiceDecoratorConfiguration
extends GeneratorConfiguration
implements ThriftConstants {
    private static final String ENCODING = "UTF-8";
    public static final String DEFAULT_TEMPLATE_FOLDER = "thrift";
    public static final String DEFAULT_LANGUAGE = "JAVA";
    public static final Class<?> DEF_REF_CLASS = Object.class;
    private static final String NO_REF_CLASS = "";
    private Map<Class<?>, Class<?>> interfaceClasses;
    private TaskType taskType;
    private LanguageType languageType;
    private String thriftClientPackage;
    private String sourcepath;
    private String classpath;
    private final PropertiesConfiguration config = new PropertiesConfiguration();
    private Set<String> reqiredTags = Collections.emptySet();
    public static final ThriftServiceDecoratorConfiguration INSTANCE = new ThriftServiceDecoratorConfiguration();

    private ThriftServiceDecoratorConfiguration() {
        this.defaultValue.setProperty("template-folder", (Object)DEFAULT_TEMPLATE_FOLDER);
        this.defaultValue.setProperty("reference-class", (Object)NO_REF_CLASS);
        this.defaultValue.setProperty("thrift-package", (Object)NO_REF_CLASS);
        this.defaultValue.setProperty("language", (Object)DEFAULT_LANGUAGE);
        this.defaultValue.setProperty("config", null);
        this.defaultValue.setProperty("source-path", (Object)NO_REF_CLASS);
        this.defaultValue.setProperty("class-path", (Object)NO_REF_CLASS);
        this.defaultValue.setProperty("tags", (Object)NO_REF_CLASS);
    }

    public void loadConfig(Options options, CommandLine cmd) throws ParseException {
        String tags;
        super.loadConfig(options, cmd);
        try {
            List<Class<?>> interfaceList = this.toClassArray((String)this.getProperty("interface-class"));
            List<Class<?>> refList = this.toClassArray((String)this.getProperty("reference-class"));
            this.thriftClientPackage = (String)this.getProperty("thrift-package");
            if (refList.size() > 0 && refList.size() != interfaceList.size()) {
                throw new ParseException("mismatch number interface class and reference class");
            }
            this.interfaceClasses = Maps.newLinkedHashMap();
            for (int i = 0; i < interfaceList.size(); ++i) {
                Class<?> key = interfaceList.get(i);
                if (interfaceList.get(i) == DEF_REF_CLASS) continue;
                try {
                    Class<?> value = refList.get(i);
                    this.interfaceClasses.put(key, value);
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    this.interfaceClasses.put(key, DEF_REF_CLASS);
                }
            }
            if (interfaceList.isEmpty()) {
                throw new ParseException("NOT FOUND VALID interface class define");
            }
        }
        catch (ClassNotFoundException e) {
            throw new ParseException("ClassNotFoundException:" + e.getMessage());
        }
        try {
            this.taskType = TaskType.valueOf((String)this.getProperty("task-type"));
            if ((this.taskType == TaskType.CLIENT || this.taskType == TaskType.CLIENT_THRIFTY) && this.thriftClientPackage.isEmpty()) {
                throw new IllegalArgumentException(String.format("must set param :%s", "thrift-package"));
            }
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage());
        }
        try {
            this.languageType = LanguageType.valueOf((String)this.getProperty("language"));
            LanguageType.setCurrent(this.languageType);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage());
        }
        if (this.hasProperty("config")) {
            File configFile = new File((String)this.getProperty("config"));
            Preconditions.checkArgument((configFile.isFile() && configFile.getName().endsWith(".properties") ? 1 : 0) != 0, (String)"%s must be a .properties file", (Object)"config");
            try {
                FileBasedConfigurationBuilder.setDefaultEncoding(PropertiesConfiguration.class, (String)ENCODING);
                new FileHandler((FileBased)this.config).load(configFile);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        this.sourcepath = (String)this.getProperty("source-path");
        this.classpath = (String)this.getProperty("class-path");
        this.classpath = this.classpath.replaceAll(",", File.pathSeparator);
        if (File.pathSeparatorChar != ';') {
            this.classpath = this.classpath.replaceAll(";", File.pathSeparator);
        }
        if (!Strings.isNullOrEmpty((String)(tags = (String)this.getProperty("tags")))) {
            this.reqiredTags = Sets.newHashSet((Iterable)FaceUtilits.elementsOf((String)tags));
        }
    }

    private List<Class<?>> toClassArray(String input) throws ClassNotFoundException {
        String[] classNames = input.split(",");
        ArrayList result = Lists.newArrayList();
        for (String name : classNames) {
            result.add(name.isEmpty() ? DEF_REF_CLASS : Class.forName(name));
        }
        return result;
    }

    public Map<Class<?>, Class<?>> getInterfaceClasses() {
        return this.interfaceClasses;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public LanguageType getLanguageType() {
        return this.languageType;
    }

    public String getTemplateFolder() {
        String folder = super.getTemplateFolder();
        StringBuilder sb = new StringBuilder(folder);
        if (DEFAULT_TEMPLATE_FOLDER.equals(folder)) {
            sb.append(this.getLanguageType().postfix);
        }
        sb.append("/").append(this.getTaskType().folder);
        return sb.toString();
    }

    public String getThriftClientPackage() {
        return this.thriftClientPackage;
    }

    public CodeWriter getCodeWriter() {
        return this.getLanguageType().getCodeWriter(this.getOutputLocation());
    }

    public Configuration getConfig() {
        return this.config;
    }

    public String getSourcepath() {
        return this.sourcepath;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public Set<String> getReqiredTags() {
        return this.reqiredTags;
    }

    public static enum LanguageType {
        JAVA(""),
        CPP("_cpp"),
        C_GLIB("_c_glib");

        private static LanguageType current;
        public final String postfix;

        private LanguageType(String postfix) {
            this.postfix = postfix;
        }

        public CodeWriter getCodeWriter(File outputFolder) {
            switch (this) {
                case JAVA: {
                    return new JavaCodeWriter(outputFolder);
                }
                case CPP: {
                    return new CxxCodeWriter(outputFolder);
                }
                case C_GLIB: {
                    return new CxxCodeWriter(outputFolder);
                }
            }
            throw new UnsupportedOperationException("unsupported language type:" + this.name());
        }

        public static LanguageType getCurrent() {
            return current;
        }

        public static synchronized void setCurrent(LanguageType current) {
            Preconditions.checkState((null == LanguageType.current || LanguageType.current.equals((Object)current) ? 1 : 0) != 0, (Object)"LanguageType.current can be initialized only onece");
            LanguageType.current = current;
        }

        static {
            current = null;
        }
    }

    public static enum TaskType {
        SERVICE("service"),
        CLIENT("client"),
        CLIENT_THRIFTY("client_thrifty");

        public final String folder;

        private TaskType(String folder) {
            this.folder = folder;
        }
    }
}

