/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.thrift;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.gdface.codegen.AbstractSchema;
import net.gdface.codegen.Method;
import net.gdface.codegen.thrift.ThriftConstants;
import net.gdface.codegen.thrift.ThriftServiceDecorator;
import net.gdface.codegen.thrift.ThriftServiceDecoratorConfiguration;
import net.gdface.codegen.thrift.ThriftStructDecorator;
import net.gdface.thrift.ThriftUtils;
import net.gdface.utils.BeanPropertyUtils;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeHelper
implements ThriftConstants {
    private static final Logger logger = LoggerFactory.getLogger(TypeHelper.class);
    private final Set<Class<?>> knownTypes = Sets.newHashSet();
    private final Set<Class<?>> referTypes = Sets.newHashSet();
    private final Map<Class<?>, ThriftStructDecorator> decorateTypes = Maps.newHashMap();
    private final List<ThriftStructDecorator> thriftTypes = Lists.newLinkedList();
    private final AbstractSchema parent;
    private final ThreadLocal<Deque<Class<?>>> stack = new ThreadLocal<Deque<Class<?>>>(){

        @Override
        protected Deque<Class<?>> initialValue() {
            return new ArrayDeque();
        }
    };
    public static final ThreadLocal<Predicate<Type>> VERIFYTYPE_MONITOR = new ThreadLocal();
    private final Predicate<PropertyDescriptor> expFieldfilter = new Predicate<PropertyDescriptor>(){

        public boolean apply(PropertyDescriptor input) {
            return input.getReadMethod().getDeclaringClass() != Throwable.class;
        }
    };

    public TypeHelper(AbstractSchema parent) {
        this.parent = (AbstractSchema)Preconditions.checkNotNull((Object)parent, (Object)"parent is null");
        this.knownTypes.addAll(ThriftUtils.THRIFT_BUILTIN_KNOWNTYPES);
        this.knownTypes.addAll(ThriftUtils.CAST_TYPES.keySet());
    }

    public final boolean verifyType(Type type) {
        if (null != VERIFYTYPE_MONITOR.get()) {
            VERIFYTYPE_MONITOR.get().apply((Object)type);
        }
        if (this.knownTypes.contains(type)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type rawType = paramType.getRawType();
            Type[] typeArgs = paramType.getActualTypeArguments();
            if (rawType == Map.class) {
                return this.verifyType(typeArgs[0]) && this.verifyType(typeArgs[1]);
            }
            if (rawType == List.class) {
                return this.verifyType(typeArgs[0]);
            }
            if (rawType == Set.class) {
                return this.verifyType(typeArgs[0]);
            }
            throw new IllegalArgumentException(String.format("not allow parameterized type %s", type.toString()));
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (null != clazz.getDeclaringClass() && !Modifier.isStatic(clazz.getModifiers())) {
                logger.error("unsupport not static member class {}", (Object)clazz);
                return false;
            }
            if (clazz.isPrimitive() || Primitives.isWrapperType((Class)clazz)) {
                logger.error("unsupport primitive type {}", (Object)clazz);
                return false;
            }
            if (ThriftUtils.isThriftStruct((Type)clazz)) {
                this.knownTypes.add(clazz);
                this.thriftTypes.add(this.makeThriftStructDecorator(clazz));
                return true;
            }
            if (Enum.class.isAssignableFrom(clazz)) {
                this.knownTypes.add(clazz);
                this.decorateTypes.put(clazz, this.makeThriftStructDecorator(clazz));
                return true;
            }
            if (clazz.isArray()) {
                if (!clazz.getComponentType().isArray()) {
                    return this.verifyType(clazz.getComponentType());
                }
                logger.error("unsupport multi dimension array {}", (Object)clazz.toString());
                return false;
            }
            if (ThriftUtils.isException((Type)clazz)) {
                return this.verifyException(clazz);
            }
            if (Object.class == clazz) {
                logger.error("unsupport not type Object.class");
                return false;
            }
            String pkg = clazz.getPackage().getName();
            if (pkg.startsWith("java.") || pkg.startsWith("javax.")) {
                logger.error("not allow type {}", (Object)type);
                return false;
            }
            return this.verifyStruct(clazz);
        }
        throw new IllegalArgumentException(String.format("not allow type %s", type.toString()));
    }

    private boolean verifyException(Class<?> clazz) {
        if (!ThriftUtils.isException(clazz)) {
            return false;
        }
        if (!this.verifyFields(clazz)) {
            return false;
        }
        if (null == ThriftUtils.getConstructor(clazz, (Class[])new Class[0]) && null == ThriftUtils.getConstructor(clazz, (Class[])new Class[]{String.class})) {
            logger.error("not found default constructor or consturctor with String.class argument for {}", (Object)clazz.getName());
            return false;
        }
        this.knownTypes.add(clazz);
        this.decorateTypes.put(clazz, this.makeThriftStructDecorator(clazz));
        return true;
    }

    private boolean verifyStruct(Class<?> clazz) {
        if (clazz.getTypeParameters().length > 0) {
            logger.error("unsupport generic class {}", (Object)clazz.getName());
            return false;
        }
        try {
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            logger.error("not found default consturctor for {}", (Object)clazz.getName());
            return false;
        }
        if (!this.verifyFields(clazz)) {
            return false;
        }
        this.knownTypes.add(clazz);
        this.decorateTypes.put(clazz, this.makeThriftStructDecorator(clazz));
        return true;
    }

    private boolean verifyFields(Class<?> clazz) {
        Map<String, PropertyDescriptor> fields = this.getFields(clazz);
        for (PropertyDescriptor descriptor : fields.values()) {
            if (this.verifyType(descriptor.getReadMethod().getGenericReturnType())) continue;
            logger.warn("invalid type for {} in {}", (Object)descriptor.getName(), (Object)clazz.getName());
            return false;
        }
        return true;
    }

    public Map<String, PropertyDescriptor> getFields(Class<?> clazz, Predicate<PropertyDescriptor> filter, boolean lenient) {
        Map fields = BeanPropertyUtils.getProperties(clazz, (int)3, (boolean)lenient);
        Predicate f = (Predicate)Preconditions.checkNotNull(filter, (Object)"filter is null");
        if (ThriftUtils.isException(clazz) && f != this.expFieldfilter) {
            f = Predicates.and((Predicate)f, this.expFieldfilter);
        }
        return Maps.filterValues((Map)fields, (Predicate)f);
    }

    public Map<String, PropertyDescriptor> getFields(Class<?> clazz, Predicate<PropertyDescriptor> filter) {
        return this.getFields(clazz, filter, false);
    }

    public Map<String, PropertyDescriptor> getFields(Class<?> clazz) {
        return this.getFields(clazz, (Predicate<PropertyDescriptor>)Predicates.alwaysTrue());
    }

    private boolean isDecoratorType(Type type) {
        return this.decorateTypes.containsKey(type);
    }

    public List<ThriftStructDecorator> getDecorateTypes() {
        return ImmutableList.copyOf(this.decorateTypes.values());
    }

    public List<ThriftStructDecorator> getThriftTypes() {
        return ImmutableList.copyOf(this.thriftTypes);
    }

    public String toThriftType(Type type) {
        Preconditions.checkArgument((null != type ? 1 : 0) != 0, (Object)"type is null");
        if (ThriftUtils.THRIFT_BUILTIN_KNOWNTYPES.contains(type)) {
            return this.parent.getTypeName(type);
        }
        if (ThriftUtils.CAST_TYPES.containsKey(type)) {
            return this.parent.getTypeName((Type)ThriftUtils.CAST_TYPES.get(type));
        }
        if (this.isDecoratorType(type)) {
            if (Enum.class.isAssignableFrom((Class)type)) {
                return this.parent.getTypeName(type);
            }
            return this.toDecoratorType(type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type rawType = paramType.getRawType();
            Type[] typeArgs = paramType.getActualTypeArguments();
            if (rawType == Map.class) {
                return String.format("Map<%s,%s>", this.toThriftType(typeArgs[0]), this.toThriftType(typeArgs[1]));
            }
            if (rawType == List.class) {
                return String.format("List<%s>", this.toThriftType(typeArgs[0]));
            }
            if (rawType == Set.class) {
                return String.format("Set<%s>", this.toThriftType(typeArgs[0]));
            }
            throw new IllegalArgumentException(String.format("not allow parameterized type %s", type.toString()));
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isPrimitive() || Primitives.isWrapperType((Class)clazz)) {
                throw new IllegalArgumentException(String.format("not allow type %s", clazz.toString()));
            }
            if (ThriftUtils.isThriftStruct((Type)clazz)) {
                return this.parent.getTypeName((Type)clazz);
            }
            if (clazz.isArray()) {
                Class<?> conmponentType = clazz.getComponentType();
                if (!conmponentType.isArray()) {
                    return String.format("java.util.List<%s>", this.toThriftType(Primitives.wrap(conmponentType)));
                }
                throw new IllegalArgumentException("unsupported type multi dimension array");
            }
        }
        throw new IllegalArgumentException(String.format("not allow type %s", type.toString()));
    }

    private String toClientThriftType0(Type type, boolean toDecorator) {
        Preconditions.checkArgument((null != type ? 1 : 0) != 0, (Object)"type is null");
        if (ThriftUtils.THRIFT_BUILTIN_KNOWNTYPES.contains(type) || type == Void.class) {
            return this.parent.getTypeName(type);
        }
        if (ThriftUtils.CAST_TYPES.containsKey(type)) {
            return this.parent.getTypeName((Type)ThriftUtils.CAST_TYPES.get(type));
        }
        if (toDecorator && this.isDecoratorType(type) && !Enum.class.isAssignableFrom((Class)type)) {
            return this.toDecoratorType(type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type rawType = paramType.getRawType();
            Type[] typeArgs = paramType.getActualTypeArguments();
            if (rawType == Map.class) {
                return String.format("Map<%s,%s>", this.toClientThriftType0(typeArgs[0], toDecorator), this.toClientThriftType0(typeArgs[1], toDecorator));
            }
            if (rawType == List.class) {
                return String.format("List<%s>", this.toClientThriftType0(typeArgs[0], toDecorator));
            }
            if (rawType == Set.class) {
                return String.format("Set<%s>", this.toClientThriftType0(typeArgs[0], toDecorator));
            }
            throw new IllegalArgumentException(String.format("not allow parameterized type %s", type.toString()));
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isPrimitive() || Primitives.isWrapperType((Class)clazz)) {
                throw new IllegalArgumentException(String.format("not allow type %s", clazz.toString()));
            }
            if (ThriftUtils.isThriftStruct((Type)clazz) || Enum.class.isAssignableFrom(clazz) || this.isDecoratorType(clazz)) {
                return ThriftServiceDecoratorConfiguration.INSTANCE.getThriftClientPackage() + "." + clazz.getSimpleName();
            }
            if (clazz.isArray()) {
                Class<?> conmponentType = clazz.getComponentType();
                if (!conmponentType.isArray()) {
                    return String.format("java.util.List<%s>", this.toClientThriftType0(Primitives.wrap(conmponentType), toDecorator));
                }
                throw new IllegalArgumentException("unsupported type multi dimension array");
            }
        }
        throw new IllegalArgumentException(String.format("not allow type %s", type.toString()));
    }

    public String toClientThriftType(Type type) {
        Preconditions.checkArgument((null != type ? 1 : 0) != 0, (Object)"type is null");
        if (type == ByteBuffer.class || type == byte[].class) {
            return this.parent.getTypeName(byte[].class);
        }
        return this.toClientThriftType0(type, false);
    }

    public String toClientThriftyType(Type type) {
        Preconditions.checkArgument((null != type ? 1 : 0) != 0, (Object)"type is null");
        if (type == ByteBuffer.class || type == byte[].class) {
            return this.parent.getTypeName(ByteString.class);
        }
        return this.toClientThriftType0(type, false);
    }

    public boolean isClientThriftType(Type type) {
        Preconditions.checkArgument((null != type ? 1 : 0) != 0, (Object)"type is null");
        if (type == ByteBuffer.class) {
            return false;
        }
        if (ThriftUtils.THRIFT_BUILTIN_KNOWNTYPES.contains(type) || type == byte[].class || type == Void.class) {
            return true;
        }
        if (ThriftUtils.CAST_TYPES.containsKey(type)) {
            return false;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type rawType = paramType.getRawType();
            Type[] typeArgs = paramType.getActualTypeArguments();
            if (rawType == Map.class) {
                return this.isClientThriftType(typeArgs[0]) && this.isClientThriftType(typeArgs[1]);
            }
            if (rawType == List.class) {
                return this.isClientThriftType(typeArgs[0]);
            }
            if (rawType == Set.class) {
                return this.isClientThriftType(typeArgs[0]);
            }
            throw new IllegalArgumentException(String.format("not allow parameterized type %s", type.toString()));
        }
        if (type instanceof Class) {
            return false;
        }
        throw new IllegalArgumentException(String.format("not allow type %s", type.toString()));
    }

    private String toDecoratorType(Type type) {
        if (this.isDecoratorType(type)) {
            ThriftStructDecorator decorator = this.decorateTypes.get(type);
            if (decorator.getDecoratorPackage().equals(this.getParentPackage()) && !this.parent.getImportedList().containsValue(type)) {
                return ((Class)type).getSimpleName();
            }
            return decorator.getDecoratorClassName();
        }
        return this.parent.getTypeName(type);
    }

    public String toThriftyDecoratorType(Type type) {
        if (type == ByteBuffer.class || type == byte[].class) {
            return this.parent.getTypeName(byte[].class);
        }
        return this.toClientThriftType0(type, true);
    }

    public void checkType(Type type) {
        if (!this.verifyType(type)) {
            throw new IllegalArgumentException(String.format("UNSUPPORTED TYPE %s", type.toString()));
        }
    }

    public void checkType(Method method) {
        this.checkParameter(method);
        this.checkReturnType(method);
        this.checkThrows(method);
    }

    public void checkParameter(Method method) {
        for (Method.Parameter param : method.getParameters()) {
            Type genericType = param.getGenericType();
            if (this.verifyType(genericType)) continue;
            throw new IllegalArgumentException(String.format("UNSUPPORTED TYPE %s of parameter %s in %s", genericType.toString(), param.name, method.getName()));
        }
    }

    public void checkReturnType(Method method) {
        Type returnType = method.getGenericReturnType();
        if (!this.verifyType(returnType)) {
            throw new IllegalArgumentException(String.format("UNSUPPORTED TYPE %s of return type for %s", returnType.toString(), method.getName()));
        }
    }

    public void checkThrows(Method method) {
        for (Type exp : method.getGenericExceptionTypes()) {
            if (this.verifyType(exp)) continue;
            throw new IllegalArgumentException(String.format("UNSUPPORTED EXCEPTION TYPE %s in %s", exp.toString(), method.getName()));
        }
    }

    public static void checkNotGeneric(Class<?> clazz) {
        if (clazz.getTypeParameters().length > 0) {
            throw new IllegalArgumentException(String.format("%s must not be a generic class", clazz.getName()));
        }
    }

    public static void checkNotGeneric(java.lang.reflect.Method method) {
        if (method.getTypeParameters().length > 0) {
            throw new IllegalArgumentException(String.format("%s must not be a generic method", method.getName()));
        }
    }

    public static void checkNotGeneric(Method method) {
        if (method.getTypeParameters().length > 0) {
            throw new IllegalArgumentException(String.format("%s must not be a generic method", method.getName()));
        }
    }

    private String getParentPackage() {
        if (this.parent instanceof ThriftStructDecorator) {
            return ((ThriftStructDecorator)this.parent).getDecoratorPackage();
        }
        if (this.parent instanceof ThriftServiceDecorator) {
            return ((ThriftServiceDecorator)this.parent).getGeneratePackage();
        }
        return null;
    }

    public void addReferTypes(Type type) {
        ThriftUtils.traverseTypes((Type)type, (ThriftUtils.Action)new ThriftUtils.Action(){

            public void doClass(Class<?> clazz) {
                TypeHelper.this.referTypes.add(clazz);
                TypeHelper.this.parent.addImportedClass(new Type[]{clazz});
                if (ThriftUtils.CAST_TYPES.containsKey(clazz)) {
                    TypeHelper.this.parent.addImportedClass(new Type[]{(Type)ThriftUtils.CAST_TYPES.get(clazz)});
                    TypeHelper.this.referTypes.add(ThriftUtils.CAST_TYPES.get(clazz));
                }
            }
        });
    }

    public void addReferTypes(Method method) {
        for (Method.Parameter parameter : method.getParameters()) {
            this.addReferTypes(parameter.getGenericType());
        }
        this.addReferTypes(method.getGenericReturnType());
        for (Type type : method.getGenericExceptionTypes()) {
            this.addReferTypes(type);
        }
    }

    public boolean needTransformer() {
        return Iterators.tryFind(this.referTypes.iterator(), (Predicate)new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return ThriftUtils.needTransformer(input);
            }
        }).isPresent();
    }

    public List<Class<?>> getTypesWithDecorator() {
        return Lists.transform(this.getDecorateTypes(), (Function)new Function<ThriftStructDecorator, Class<?>>(){

            public Class<?> apply(ThriftStructDecorator input) {
                return input.getBaseClass();
            }
        });
    }

    public List<Class<?>> getReferExceptions() {
        Iterable iterable = Iterables.filter(this.referTypes, (Predicate)new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return Exception.class.isAssignableFrom(input);
            }
        });
        return Lists.newArrayList((Iterable)iterable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThriftStructDecorator makeThriftStructDecorator(Class<?> structType) {
        Preconditions.checkNotNull(structType, (Object)"structType is null");
        Deque<Class<?>> stack = this.stack.get();
        if (stack.contains(structType)) {
            String path = Joiner.on((String)"->").join(Iterables.transform((Iterable)Iterables.concat(stack, (Iterable)ImmutableList.of(structType)), (Function)new Function<Class<?>, Object>(){

                public Object apply(Class<?> input) {
                    return TypeToken.of(input).getRawType().getName();
                }
            }));
            throw new IllegalArgumentException("Circular references are not allowed: " + path);
        }
        stack.push(structType);
        try {
            ThriftStructDecorator thriftStructDecorator = new ThriftStructDecorator(structType);
            return thriftStructDecorator;
        }
        finally {
            Class<?> top = stack.pop();
            Preconditions.checkState((boolean)structType.equals(top), (String)"ThriftCatalog circularity detection stack is corrupt: expected %s, but got %s", structType, top);
        }
    }
}

