package thrift.test.original;

import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftStruct;

import net.gdface.annotation.ServicePort;

/**
 * just for testing only
 * @author guyadong
 *
 */
public interface TestInterface {
	public TestBeanA testBean(TestBeanB input);
	public float list(String strInput,int intInput,Date dateInput,byte[] binary, Long longInput);
	public byte[] byteTest(byte[] input) throws TestException;
	public List<Integer> testList(Map<Date,TestBeanA> input);
	public List<TestBeanA> testArray(long[] input);
	public Integer[] testThriftStruct(Set<TestBeanB>input);
	@ServicePort(suffix="Url")
	public URL[] testURIURL(URI input);
	public URL[] testURIURL(String input);
	public Float testFloat(Float input);
	public EnumTest testEnum(EnumTest input);
	public void testVoid(int input);
	public enum EnumTest{HELLO,WORLD}
	public static class TestBeanA{
		private byte[] binary;
		private int[] intArray;
		private Map<String,Date> values;
		private List<Long> longList;
		private List<URL> urls;
		private Float rate;
		private List<Integer> list;
		private boolean _new;
		public byte[] getBinary() {
			return binary;
		}
		public void setBinary(byte[] binary) {
			this.binary = binary;
		}
		public int[] getIntArray() {
			return intArray;
		}
		public void setIntArray(int[] intArray) {
			this.intArray = intArray;
		}
		public Map<String, Date> getValues() {
			return values;
		}
		public void setValues(Map<String, Date> values) {
			this.values = values;
		}
		public List<Long> getLongList() {
			return longList;
		}
		public void setLongList(List<Long> longList) {
			this.longList = longList;
		}
		public List<URL> getUrls() {
			return urls;
		}
		public void setUrls(List<URL> urls) {
			this.urls = urls;
		}
		public Float getRate() {
			return rate;
		}
		public void setRate(Float rate) {
			this.rate = rate;
		}
		public List<Integer> getList() {
			return list;
		}
		public void setList(List<Integer> list) {
			this.list = list;
		}
		public boolean isNew() {
			return _new;
		}
		public void setNew(boolean _new) {
			this._new = _new;
		}		
	}
	@ThriftStruct
	public static final class TestBeanB{
		private ByteBuffer buffer;
		private List<Integer> intArray;
		private Map<String, Long> values;
		private Set<Double> doubleList;
		@ThriftField(value = 1)
		public ByteBuffer getBuffer() {
			return buffer;
		}
		@ThriftField
		public void setBuffer(ByteBuffer buffer) {
			this.buffer = buffer;
		}
		@ThriftField(value = 2)
		public List<Integer> getIntArray() {
			return intArray;
		}
		@ThriftField
		public void setIntArray(List<Integer> intArray) {
			this.intArray = intArray;
		}
		@ThriftField(value = 3)
		public Map<String, Long> getValues() {
			return values;
		}
		@ThriftField
		public void setValues(Map<String, Long> values) {
			this.values = values;
		}
		@ThriftField(value = 4)
		public Set<Double> getDoubleList() {
			return doubleList;
		}
		@ThriftField
		public void setDoubleList(Set<Double> doubleList) {
			this.doubleList = doubleList;
		}
	}
	public static class TestException extends Exception{
		private static final long serialVersionUID = 1L;

		public TestException() {
			super();
		}

		public TestException(String arg0, Throwable arg1) {
			super(arg0, arg1);
		}

		public TestException(String arg0) {
			super(arg0);
		}

		public TestException(Throwable arg0) {
			super(arg0);
		}
		
	}
	public static class BaseImpl implements TestInterface{

		@Override
		public float list(String strInput, int intInput, Date dateInput, byte[] binary, Long longInput) {
			return 0;
		}

		@Override
		public byte[] byteTest(byte[] input) throws TestException{
			return null;
		}

		@Override
		public List<Integer> testList(Map<Date, TestBeanA> input) {
			return null;
		}

		@Override
		public Integer[] testThriftStruct(Set<TestBeanB> input) {
			return null;
		}

		@Override
		public List<TestBeanA> testArray(long[] input) {
			return null;
		}

		@Override
		public URL[] testURIURL(URI input) {
			return null;
		}

		@Override
		public URL[] testURIURL(String input) {
			return null;
		}

		@Override
		public Float testFloat(Float input) {
			return null;
		}

		@Override
		public EnumTest testEnum(EnumTest input) {
			return null;
		}

		@Override
		public TestBeanA testBean(TestBeanB input) {
			return null;
		}

		@Override
		public void testVoid(int input) {
			// TODO 自动生成的方法存根
			
		}
		
	}
}
