package net.gdface.codegen.thrift;

import net.gdface.codegen.generator.GeneratorOptions;
import org.apache.commons.cli.Option;

/**
 * @author guyadong
 *
 */
public class ThriftServiceDecoratorOptions extends GeneratorOptions implements ThriftConstants{
	private final static ThriftServiceDecoratorOptions instance = new ThriftServiceDecoratorOptions();

	protected ThriftServiceDecoratorOptions() {
		super();
		options.addOption(Option.builder(INTERFACE_CLASS_OPTION).longOpt(INTERFACE_CLASS_OPTION_LONG)
				.desc("interface classes,splited with [,]without blank space,must maped with -rc")
				.argName("className,..,className").numberOfArgs(1).required().build());
		options.addOption(Option.builder(REFERENCE_CLASS_OPTION).longOpt(REFERENCE_CLASS_OPTION_LONG)
				.desc("reference classes,splited with [,]without blank space,must maped with -ic")
				.argName("className,..,className").numberOfArgs(1).build());
		options.addOption(Option.builder(TASK_TYPE_OPTION).longOpt(TASK_TYPE_OPTION_LONG)
				.desc(TASK_TYPE_OPTION_DESC).numberOfArgs(1).required().build());
		options.addOption(Option.builder().longOpt(THRIFT_CLIENT_PKG_OPTION_LONG)
				.desc(THRIFT_CLIENT_PKG_OPTION_DESC).numberOfArgs(1).build());
		options.addOption(Option.builder(LANGUAGE_OPTION).longOpt(LANGUAGE_OPTION_LONG)
				.desc(LANGUAGE_OPTION_DESC).numberOfArgs(1).build());
		options.addOption(Option.builder(CONFIG_OPTION).longOpt(CONFIG_OPTION_LONG)
				.desc(CONFIG_OPTION_DESC).numberOfArgs(1).build());
		options.addOption(Option.builder(SOURCE_PREFIX_OPTION).longOpt(SOURCE_PREFIX_OPTION_LONG)
				.desc(SOURCE_PREFIX_OPTION_DESC).numberOfArgs(1).build());
		options.addOption(Option.builder(CLASS_PATH_OPTION).longOpt(CLASS_PATH_OPTION_LONG)
				.desc(CLASS_PATH_OPTION_DESC).numberOfArgs(1).build());
		options.addOption(Option.builder().longOpt(TAGS_OPTION_LONG)
				.desc(TAGS_OPTION_DESC).numberOfArgs(1).build());
		options.addOption(Option.builder().longOpt(COMMON_TYPES_OPTION_LONG)
				.desc(COMMON_TYPES_OPTION_DESC).numberOfArgs(1).build());
		options.addOption(Option.builder().longOpt(ERPC_PROGRAM_OPTION_LONG)
				.desc(ERPC_PROGRAM_OPTION_DESC).numberOfArgs(1).build());
		options.addOption(Option.builder().longOpt(ERPC_PORT_PREFIX_OPTION_LONG)
				.desc(ERPC_PORT_PREFIX_OPTION_DESC).numberOfArgs(1).build());
		options.addOption(Option.builder().longOpt(EXCLUDE_METHODS_OPTION_LONG)
				.desc(EXCLUDE_METHODS_OPTION_DESC).numberOfArgs(Option.UNLIMITED_VALUES).build());
		options.addOption(Option.builder().longOpt(INCLUDE_METHODS_OPTION_LONG)
				.desc(INCLUDE_METHODS_OPTION_DESC).numberOfArgs(Option.UNLIMITED_VALUES).build());
		options.addOption(Option.builder().longOpt(EXCLUDE_FIELDS_OPTION_LONG)
				.desc(EXCLUDE_FIELDS_OPTION_DESC).numberOfArgs(Option.UNLIMITED_VALUES).build());
		options.addOption(Option.builder().longOpt(THRIFT_SERVICE_CLASS_OPTION_LONG)
				.desc(THRIFT_SERVICE_CLASS_OPTION_DESC).numberOfArgs(1).build());
		options.addOption(Option.builder().longOpt(ERPC_FORWARD_PORT_OPTION_LONG)
				.desc(ERPC_FORWARD_PORT_OPTION_DESC).numberOfArgs(1).type(Number.class).build());
		options.addOption(Option.builder().longOpt(ERPC_PROXY_PORT_OPTION_LONG)
				.desc(ERPC_PROXY_PORT_OPTION_DESC).numberOfArgs(1).type(Number.class).build());
		options.addOption(Option.builder().longOpt(ERPC_PROXY_PORT_OPTION_LONG)
				.desc(ERPC_PROXY_PORT_OPTION_DESC).numberOfArgs(1).type(Number.class).build());
		options.addOption(Option.builder().longOpt(ERPC_DEFAULT_MAX_LENGTH_OPTION_LONG)
				.desc(ERPC_DEFAULT_MAX_LENGTH_OPTION_DESC).numberOfArgs(1).type(Number.class).build());
		options.addOption(Option.builder().longOpt(ERPC_ERRMSG_MAX_LENGTH_OPTION_LONG)
				.desc(ERPC_ERRMSG_MAX_LENGTH_OPTION_DESC).numberOfArgs(1).type(Number.class).build());
		options.addOption(Option.builder().longOpt(ERPC_BINARY_OUTPUT_SIZE_OPTION_LONG)
				.desc(ERPC_BINARY_OUTPUT_SIZE_OPTION_DESC).numberOfArgs(1).type(Number.class).build());
		options.addOption(Option.builder().longOpt(EXTENSIVE_STRUCT_OPTION_LONG)
				.desc(EXTENSIVE_STRUCT_OPTION_DESC).numberOfArgs(1).build());
		
	}

	/**
	 * @return instance
	 */
	public static ThriftServiceDecoratorOptions getInstance() {
		return instance;
	}


}
