package net.gdface.codegen.thrift.metadata;

import com.facebook.swift.codec.metadata.DecoratorThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftFieldMetadataUtil;
import com.google.common.base.Predicate;
import com.google.common.reflect.TypeToken;

import net.gdface.annotation.CodegenInvalidValue;
import net.gdface.annotation.CodegenLength;
import net.gdface.annotation.CodegenRequired;

public class CodegenPreAllocFilter implements Predicate<DecoratorThriftFieldMetadata> {
	public static final CodegenPreAllocFilter PREALLOC_FILTER = new CodegenPreAllocFilter();
	public CodegenPreAllocFilter() {
	}

	 @Override
	public boolean apply(DecoratorThriftFieldMetadata input) {
		Class<?> javaType = TypeToken.of(input.getThriftType().getJavaType()).getRawType();
		if(javaType.isPrimitive() || javaType.isEnum()){
			return true;
		} 
		if(input.isCanPrimitive() && null !=ThriftFieldMetadataUtil.extractFieldAnnotation(input,CodegenInvalidValue.class)){
			return true;
		}
		CodegenLength codegenLength = ThriftFieldMetadataUtil.extractFieldAnnotation(input,CodegenLength.class);
		if(codegenLength != null){
			return codegenLength.prealloc();
		}
		CodegenRequired ann = ThriftFieldMetadataUtil.extractFieldAnnotation(input,CodegenRequired.class);
		if(null != ann){
			return ann.value();
		}
		return false;
	}

}
