package net.gdface.codegen.thrift.metadata;

import com.facebook.swift.codec.ThriftField.Requiredness;
import com.facebook.swift.codec.metadata.DecoratorThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftFieldMetadataUtil;
import com.google.common.base.Predicate;

import net.gdface.annotation.CodegenRequired;

import static net.gdface.codegen.thrift.metadata.CodegenPreAllocFilter.PREALLOC_FILTER;
public class CodegenErpcPointerFilter implements Predicate<DecoratorThriftFieldMetadata> {
	public static final CodegenErpcPointerFilter POINTER_FILTER = new CodegenErpcPointerFilter();
	public CodegenErpcPointerFilter() {
	}

	@Override
	public boolean apply(DecoratorThriftFieldMetadata input) {		
		if(!PREALLOC_FILTER.apply(input)){
			if(!Requiredness.REQUIRED.equals(input.getRequiredness())){
				CodegenRequired ann = ThriftFieldMetadataUtil.extractFieldAnnotation(input,CodegenRequired.class);				
				if(ann == null || !ann.value()){
					switch (input.getErpcType().getProtocolType()) {
					case STRING:
						return true;
					case LIST:
					case BINARY:
						return false;
					default:
						return true;
					}
				}	
			}			
		}
		return false;
	}

}
