package net.gdface.codegen.thrift.metadata;

import com.facebook.swift.codec.metadata.DecoratorThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftFieldMetadataUtil;
import com.google.common.base.Predicate;

import net.gdface.annotation.CodegenRequired;

public class CodegenRequirednessFilter implements Predicate<DecoratorThriftFieldMetadata> {
	public static final CodegenRequirednessFilter REQUIREDNESS_FILTER= new CodegenRequirednessFilter();
	public CodegenRequirednessFilter() {
	}

	 @Override
	public boolean apply(DecoratorThriftFieldMetadata input) {
		CodegenRequired ann = ThriftFieldMetadataUtil.extractFieldAnnotation(input,CodegenRequired.class);
		if(ann != null){
			return ann.value();
		}
		return false;
	}

}
