package net.gdface.codegen.thrift.metadata;

import com.facebook.swift.codec.ThriftField.Requiredness;
import com.facebook.swift.codec.metadata.DecoratorThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftFieldMetadataUtil;
import com.google.common.base.Function;

import net.gdface.annotation.CodegenRequired;
import static net.gdface.codegen.thrift.metadata.CodegenPreAllocFilter.PREALLOC_FILTER;

public class ErpcTypePrefixGetter implements Function<DecoratorThriftFieldMetadata, String> {
	public static final ErpcTypePrefixGetter TYPE_PREFIX_GETTER = new ErpcTypePrefixGetter();
	public ErpcTypePrefixGetter() {
	}

	@Override
	public String apply(DecoratorThriftFieldMetadata input) {		
		if(!PREALLOC_FILTER.apply(input)){
			if(!Requiredness.REQUIRED.equals(input.getRequiredness())){
				CodegenRequired ann = ThriftFieldMetadataUtil.extractFieldAnnotation(input,CodegenRequired.class);				
				if(ann == null || !ann.value()){
					switch (input.getErpcType().getProtocolType()) {
					case LIST:
					case STRING:
					case BINARY:
						return "";
					default:
						return "byref ";
					}
				}	
			}
			
		}
		return "";
	}

}
