/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.thrift;

import com.facebook.swift.codec.metadata.ReflectionHelper;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.gdface.codegen.thrift.CxxHelper;
import net.gdface.codegen.thrift.CxxTypeMeta;
import net.gdface.codegen.thrift.ThriftServiceDecoratorConfiguration;

public class CxxType {
    public static final CxxType BOOL = new CxxType(Boolean.TYPE, CxxTypeMeta.BOOL, null);
    public static final CxxType BYTE = new CxxType(Byte.TYPE, CxxTypeMeta.BYTE, null);
    public static final CxxType DOUBLE = new CxxType(Double.TYPE, CxxTypeMeta.DOUBLE, null);
    public static final CxxType I16 = new CxxType(Short.TYPE, CxxTypeMeta.I16, null);
    public static final CxxType I32 = new CxxType(Integer.TYPE, CxxTypeMeta.I32, null);
    public static final CxxType I64 = new CxxType(Long.TYPE, CxxTypeMeta.I64, null);
    public static final CxxType STRING = new CxxType((Type)((Object)String.class), CxxTypeMeta.STRING, null);
    public static final CxxType BINARY = new CxxType((Type)((Object)ByteBuffer.class), CxxTypeMeta.BINARY, null);
    public static final CxxType VOID = new CxxType(Void.TYPE, CxxTypeMeta.VOID, null);
    private static final ConcurrentMap<Class<?>, CxxType> manualTypes = new ConcurrentHashMap();
    public static final ImmutableMap<Class<?>, CxxType> THRIFT_BUILTIN_CXX_TYPES = ImmutableMap.builder().put(Boolean.TYPE, (Object)BOOL).put(Byte.TYPE, (Object)BYTE).put(Double.TYPE, (Object)DOUBLE).put(Short.TYPE, (Object)I16).put(Integer.TYPE, (Object)I32).put(Long.TYPE, (Object)I64).put(String.class, (Object)STRING).put(ByteBuffer.class, (Object)BINARY).put(Void.TYPE, (Object)VOID).put(Boolean.class, (Object)new CxxType((Type)((Object)Boolean.class), CxxTypeMeta.BOOL, null)).put(Byte.class, (Object)new CxxType((Type)((Object)Byte.class), CxxTypeMeta.BYTE, null)).put(Double.class, (Object)new CxxType((Type)((Object)Double.class), CxxTypeMeta.DOUBLE, null)).put(Short.class, (Object)new CxxType((Type)((Object)Short.class), CxxTypeMeta.I16, null)).put(Integer.class, (Object)new CxxType((Type)((Object)Integer.class), CxxTypeMeta.I32, null)).put(Long.class, (Object)new CxxType((Type)((Object)Long.class), CxxTypeMeta.I64, null)).put(Void.class, (Object)new CxxType((Type)((Object)Void.class), CxxTypeMeta.VOID, null)).build();
    private static final CxxTypeMeta CAST_VECTOR = CxxTypeMeta.BINARY.cast(null, CxxTypeMeta.BYTE, true);
    private static final CxxTypeMeta CAST_DATE = CxxTypeMeta.I64.cast("std::tm");
    private static final CxxTypeMeta CAST_FLOAT = CxxTypeMeta.DOUBLE.cast("float");
    public static final ImmutableMap<Class<?>, CxxType> THRIFT_CAST_CXX_TYPES = ImmutableMap.builder().put(byte[].class, (Object)new CxxType((Type)((Object)byte[].class), CxxTypeMeta.BINARY, null)).put(java.util.Date.class, (Object)new CxxType((Type)((Object)java.util.Date.class), CxxTypeMeta.I64, CAST_DATE)).put(Date.class, (Object)new CxxType((Type)((Object)Date.class), CxxTypeMeta.I64, CAST_DATE)).put(Time.class, (Object)new CxxType((Type)((Object)Time.class), CxxTypeMeta.I64, CAST_DATE)).put(Float.TYPE, (Object)new CxxType(Float.TYPE, CxxTypeMeta.DOUBLE, CAST_FLOAT)).put(Float.class, (Object)new CxxType((Type)((Object)Float.class), CxxTypeMeta.DOUBLE, CAST_FLOAT)).put(Character.TYPE, (Object)new CxxType(Character.TYPE, CxxTypeMeta.I16, null)).put(Character.class, (Object)new CxxType((Type)((Object)Character.class), CxxTypeMeta.I16, null)).put(URI.class, (Object)new CxxType((Type)((Object)URI.class), CxxTypeMeta.STRING, null)).put(URL.class, (Object)new CxxType((Type)((Object)URL.class), CxxTypeMeta.STRING, null)).build();
    private final Type javaType;
    private final CxxTypeMeta stubType;
    private final CxxTypeMeta uiType;

    public static CxxType struct(Type javaType) {
        Preconditions.checkNotNull((Object)javaType, (Object)"javaType is null");
        Preconditions.checkArgument((boolean)(javaType instanceof Class), (Object)"javaType must be a Class");
        Class type = (Class)javaType;
        String stubType = "::" + CxxHelper.cxxNamespace(ThriftServiceDecoratorConfiguration.INSTANCE.getThriftClientPackage(), true) + "::" + type.getSimpleName();
        String uiType = CxxHelper.cxxClassName((Class)javaType, true);
        return new CxxType(javaType, CxxTypeMeta.struct(stubType), CxxTypeMeta.struct(uiType));
    }

    public static CxxType exception(Type javaType) {
        Preconditions.checkNotNull((Object)javaType, (Object)"javaType is null");
        Preconditions.checkArgument((boolean)(javaType instanceof Class), (Object)"javaType must be a Class");
        Class type = (Class)javaType;
        String stubType = "::" + CxxHelper.cxxNamespace(ThriftServiceDecoratorConfiguration.INSTANCE.getThriftClientPackage(), true) + "::" + type.getSimpleName();
        String uiType = CxxHelper.cxxClassName((Class)javaType, true);
        return new CxxType(javaType, CxxTypeMeta.struct(stubType), CxxTypeMeta.struct(uiType));
    }

    public static CxxType enumType(Type javaType) {
        Preconditions.checkNotNull((Object)javaType, (Object)"javaType is null");
        Preconditions.checkArgument((javaType instanceof Class && Enum.class.isAssignableFrom((Class)javaType) ? 1 : 0) != 0, (String)"javaType (%s) must be a enum Class", (Object)javaType);
        Class type = (Class)javaType;
        String stubType = "::" + CxxHelper.cxxNamespace(ThriftServiceDecoratorConfiguration.INSTANCE.getThriftClientPackage(), true) + "::" + type.getSimpleName() + "::type";
        String uiType = CxxHelper.cxxClassName((Class)javaType, true);
        return new CxxType(javaType, CxxTypeMeta.enumType(stubType), CxxTypeMeta.enumType(uiType));
    }

    public static <K, V> CxxType map(CxxType keyType, CxxType valueType) {
        Preconditions.checkArgument((null != keyType ? 1 : 0) != 0, (Object)"keyType is null");
        Preconditions.checkArgument((null != valueType ? 1 : 0) != 0, (Object)"valueType is null");
        Type javaType = new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, TypeToken.of((Type)keyType.getJavaType())).where(new TypeParameter<V>(){}, TypeToken.of((Type)valueType.getJavaType())).getType();
        CxxTypeMeta uiType = null;
        if (null != keyType.uiType) {
            uiType = CxxTypeMeta.map(keyType.uiType, (CxxTypeMeta)MoreObjects.firstNonNull((Object)valueType.uiType, (Object)valueType.stubType));
        } else if (null != valueType.uiType) {
            uiType = CxxTypeMeta.map((CxxTypeMeta)MoreObjects.firstNonNull((Object)keyType.uiType, (Object)keyType.stubType), valueType.uiType);
        }
        CxxTypeMeta thriftCxxType = CxxTypeMeta.map(keyType.stubType, valueType.stubType);
        return new CxxType(javaType, thriftCxxType, uiType);
    }

    public static CxxType container(ParameterizedType type) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Class rawType = TypeToken.of((Type)type).getRawType();
        Type[] actTypes = type.getActualTypeArguments();
        if (Map.class.isAssignableFrom(rawType)) {
            return CxxType.map(CxxType.getThriftType(actTypes[0]), CxxType.getThriftType(actTypes[1]));
        }
        if (List.class.isAssignableFrom(rawType)) {
            return CxxType.list(CxxType.getThriftType(actTypes[0]));
        }
        if (Set.class.isAssignableFrom(rawType)) {
            return CxxType.set(CxxType.getThriftType(actTypes[0]));
        }
        throw new IllegalArgumentException("unsupported type, type must be one of Map,List,Set:" + type);
    }

    public static <E> CxxType set(CxxType valueType) {
        Preconditions.checkArgument((null != valueType ? 1 : 0) != 0, (Object)"valueType is null");
        Type javaType = new TypeToken<Set<E>>(){}.where(new TypeParameter<E>(){}, TypeToken.of((Type)valueType.getJavaType())).getType();
        CxxTypeMeta uiType = CxxTypeMeta.set(valueType.uiType);
        CxxTypeMeta thriftCxxType = CxxTypeMeta.set(valueType.stubType);
        return new CxxType(javaType, thriftCxxType, uiType);
    }

    public static <E> CxxType list(CxxType valueType) {
        Preconditions.checkArgument((null != valueType ? 1 : 0) != 0, (Object)"valueType is null");
        Type javaType = new TypeToken<List<E>>(){}.where(new TypeParameter<E>(){}, TypeToken.of((Type)valueType.getJavaType())).getType();
        CxxTypeMeta uiType = CxxTypeMeta.list(valueType.uiType);
        CxxTypeMeta thriftCxxType = CxxTypeMeta.list(valueType.stubType);
        return new CxxType(javaType, thriftCxxType, uiType);
    }

    public static CxxType array(CxxType valueType) {
        Preconditions.checkArgument((null != valueType ? 1 : 0) != 0, (Object)"valueType is null");
        Class javaType = ReflectionHelper.getArrayOfType((Type)valueType.getJavaType());
        CxxTypeMeta thriftCxxType = CxxTypeMeta.list(valueType.stubType);
        CxxTypeMeta uiType = CxxTypeMeta.array((CxxTypeMeta)MoreObjects.firstNonNull((Object)valueType.uiType, (Object)valueType.stubType));
        return new CxxType(javaType, thriftCxxType, uiType);
    }

    public static CxxType getThriftType(Type javaType) throws IllegalArgumentException {
        Preconditions.checkArgument((javaType instanceof Class || javaType instanceof ParameterizedType ? 1 : 0) != 0, (Object)("invalid javaType:" + javaType));
        Class rawType = TypeToken.of((Type)javaType).getRawType();
        CxxType manualType = (CxxType)manualTypes.get(rawType);
        if (manualType != null) {
            return manualType;
        }
        CxxType buildin = (CxxType)THRIFT_BUILTIN_CXX_TYPES.get((Object)rawType);
        if (null != buildin) {
            return buildin;
        }
        CxxType uiType = (CxxType)THRIFT_CAST_CXX_TYPES.get((Object)rawType);
        if (null != uiType) {
            return uiType;
        }
        if (Enum.class.isAssignableFrom(rawType)) {
            return CxxType.enumType(rawType);
        }
        if (rawType.isArray()) {
            Class<?> elementType = rawType.getComponentType();
            return CxxType.array(CxxType.getThriftType(elementType));
        }
        if (Map.class.isAssignableFrom(rawType)) {
            Type mapKeyType = ReflectionHelper.getMapKeyType((Type)javaType);
            Type mapValueType = ReflectionHelper.getMapValueType((Type)javaType);
            return CxxType.map(CxxType.getThriftType(mapKeyType), CxxType.getThriftType(mapValueType));
        }
        if (Set.class.isAssignableFrom(rawType)) {
            Type elementType = ReflectionHelper.getIterableType((Type)javaType);
            return CxxType.set(CxxType.getThriftType(elementType));
        }
        if (Iterable.class.isAssignableFrom(rawType)) {
            Type elementType = ReflectionHelper.getIterableType((Type)javaType);
            return CxxType.list(CxxType.getThriftType(elementType));
        }
        if (Exception.class.isAssignableFrom(rawType)) {
            return CxxType.exception(rawType);
        }
        Preconditions.checkArgument((Object.class != rawType ? 1 : 0) != 0, (Object)"unsupport not type Object.class");
        String pkg = rawType.getPackage().getName();
        Preconditions.checkArgument((!pkg.startsWith("java.") && !pkg.startsWith("javax.") ? 1 : 0) != 0, (String)"not allow type %s", (Object)javaType);
        return CxxType.struct(rawType);
    }

    public static void addThriftType(CxxType thriftType) {
        manualTypes.put(TypeToken.of((Type)thriftType.getJavaType()).getRawType(), thriftType);
    }

    private CxxType(Type javaType, CxxTypeMeta thriftCxxType, CxxTypeMeta uiType) {
        this.javaType = (Type)Preconditions.checkNotNull((Object)javaType, (Object)"javaType is null");
        this.stubType = (CxxTypeMeta)Preconditions.checkNotNull((Object)thriftCxxType, (Object)"thriftCxxType is null");
        this.uiType = uiType;
    }

    public CxxTypeMeta getUiType() {
        return (CxxTypeMeta)MoreObjects.firstNonNull((Object)this.uiType, (Object)this.stubType);
    }

    public CxxTypeMeta getStubType() {
        return this.stubType;
    }

    public CxxTypeMeta.ThriftProtocolType getProtocolType() {
        return this.getStubType().getProtocolType();
    }

    public Type getJavaType() {
        return this.javaType;
    }

    public boolean isException() {
        Class rawType = TypeToken.of((Type)this.javaType).getRawType();
        return Exception.class.isAssignableFrom(rawType);
    }

    public boolean isPrimitive() {
        return TypeToken.of((Type)this.getJavaType()).isPrimitive();
    }

    public boolean isEnum() {
        return TypeToken.of((Type)this.getJavaType()).getRawType().isEnum();
    }

    public boolean isDate() {
        Type type = this.getJavaType();
        return type instanceof Class && java.util.Date.class.isAssignableFrom((Class)type);
    }

    public boolean isNeedCast() {
        return !this.getUiType().equals(this.getStubType());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CxxType [javaType=");
        builder.append(this.javaType);
        builder.append(", uiType=");
        builder.append(this.uiType);
        builder.append(", stubType=");
        builder.append(this.stubType);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uiType == null ? 0 : this.uiType.hashCode());
        result = 31 * result + (this.javaType == null ? 0 : this.javaType.hashCode());
        result = 31 * result + (this.stubType == null ? 0 : this.stubType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CxxType other = (CxxType)obj;
        if (this.uiType == null ? other.uiType != null : !this.uiType.equals(other.uiType)) {
            return false;
        }
        if (this.javaType == null ? other.javaType != null : !this.javaType.equals(other.javaType)) {
            return false;
        }
        return !(this.stubType == null ? other.stubType != null : !this.stubType.equals(other.stubType));
    }
}

