/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.thrift;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.metadata.ThriftCatalogWithTransformer;
import com.facebook.swift.codec.metadata.ThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.gdface.annotation.CodegenDefaultvalue;
import net.gdface.annotation.CodegenInvalidValue;
import net.gdface.annotation.CodegenLength;
import net.gdface.annotation.CodegenRequired;
import net.gdface.codegen.AbstractSchema;
import net.gdface.codegen.generator.GeneratorUtils;
import net.gdface.codegen.thrift.CxxType;
import net.gdface.codegen.thrift.CxxTypeMeta;
import net.gdface.codegen.thrift.ThriftConstants;
import net.gdface.codegen.thrift.ThriftServiceDecoratorConfiguration;
import net.gdface.codegen.thrift.TypeHelper;
import net.gdface.thrift.BaseThriftUtils;
import net.gdface.thrift.ThriftDecorator;
import net.gdface.thrift.exception.BaseServiceException;
import net.gdface.utils.NameStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftStructDecorator
extends AbstractSchema
implements ThriftConstants,
Comparator<ThriftStructDecorator>,
Comparable<ThriftStructDecorator> {
    private static final Logger logger = LoggerFactory.getLogger(ThriftStructDecorator.class);
    private final Map<String, PropertyDescriptor> fields;
    private final String decoratorPackage;
    private final String decoratorClassName;
    private final Class<?> decoratorClass;
    private final TypeHelper typeHelper = new TypeHelper(this);
    private final Map<String, CxxType> cxxFields;
    private final boolean hasOptional;
    private final boolean hasCanMove;
    private final CxxType cxxType;
    private final TraverseTypeForTryFind findString = new TraverseTypeForTryFind(new Predicate<CxxTypeMeta>(){

        public boolean apply(CxxTypeMeta input) {
            return null != input && (input.isBinary() || input.isString());
        }
    });
    private final TraverseTypeForTryFind findBinary = new TraverseTypeForTryFind(new Predicate<CxxTypeMeta>(){

        public boolean apply(CxxTypeMeta input) {
            return null != input && input.isBinary();
        }
    });
    private final TraverseTypeForTryFind findMap = new TraverseTypeForTryFind(new Predicate<CxxTypeMeta>(){

        public boolean apply(CxxTypeMeta input) {
            return null != input && input.isMap();
        }
    });
    private final TraverseTypeForTryFind findSet = new TraverseTypeForTryFind(new Predicate<CxxTypeMeta>(){

        public boolean apply(CxxTypeMeta input) {
            return null != input && input.isSet();
        }
    });
    private final TraverseTypeForTryFind findArray = new TraverseTypeForTryFind(new Predicate<CxxTypeMeta>(){

        public boolean apply(CxxTypeMeta input) {
            return null != input && input.isList();
        }
    });
    private final Predicate<PropertyDescriptor> codegenInvalidValueFilter = new Predicate<PropertyDescriptor>(){

        public boolean apply(PropertyDescriptor input) {
            CodegenInvalidValue ann;
            if (input != null && (ann = (CodegenInvalidValue)GeneratorUtils.extractFieldAnnotation((PropertyDescriptor)input, CodegenInvalidValue.class)) != null) {
                if (GeneratorUtils.isString(input.getPropertyType()) || GeneratorUtils.isBinary(input.getPropertyType())) {
                    return true;
                }
                return ann.value().length() > 0 || ann.exp().length() > 0;
            }
            return false;
        }
    };
    private final Predicate<PropertyDescriptor> codegenDefaultvalueFilter = new Predicate<PropertyDescriptor>(){

        public boolean apply(PropertyDescriptor input) {
            CodegenDefaultvalue ann;
            if (input != null && (ann = (CodegenDefaultvalue)GeneratorUtils.extractFieldAnnotation((PropertyDescriptor)input, CodegenDefaultvalue.class)) != null) {
                if (GeneratorUtils.isString(input.getPropertyType()) || GeneratorUtils.isBinary(input.getPropertyType())) {
                    return true;
                }
                return ann.value().length() > 0;
            }
            return false;
        }
    };
    private final Predicate<PropertyDescriptor> codegenLengthFilter = new Predicate<PropertyDescriptor>(){

        public boolean apply(PropertyDescriptor input) {
            if (input != null && !input.getPropertyType().isPrimitive() && !Primitives.unwrap(input.getPropertyType()).isPrimitive()) {
                CodegenLength ann = (CodegenLength)GeneratorUtils.extractFieldAnnotation((PropertyDescriptor)input, CodegenLength.class);
                return ann != null && (ann.value() > 0 || ann.max() > 0);
            }
            return false;
        }
    };
    private final Predicate<PropertyDescriptor> codegenRequiredFilter = new Predicate<PropertyDescriptor>(){

        public boolean apply(PropertyDescriptor input) {
            if (input != null && !input.getPropertyType().isPrimitive() && !Primitives.unwrap(input.getPropertyType()).isPrimitive()) {
                CodegenRequired ann = (CodegenRequired)GeneratorUtils.extractFieldAnnotation((PropertyDescriptor)input, CodegenRequired.class);
                return ann != null && ann.value();
            }
            return false;
        }
    };
    private static final String FIELD_NEW_ = "_new";
    private static final String FIELD_NEW = "new";
    private static final String FIELD_MODIFIED = "modified";
    private static final String FIELD_INITIALIZED = "initialized";
    static String sql2javaBeanPkgPrefix = null;
    static final Predicate<ThriftStructDecorator> SQL2JAVA_BEAN_FILTER = new Predicate<ThriftStructDecorator>(){

        private boolean checkField(ThriftStructDecorator input, String name, Class<?> type) {
            try {
                PropertyDescriptor field = input.getField(name);
                return field.getPropertyType().equals(type) && field.getReadMethod() != null && field.getWriteMethod() != null;
            }
            catch (Exception e) {
                return false;
            }
        }

        public boolean apply(ThriftStructDecorator input) {
            try {
                boolean m;
                boolean m1 = this.checkField(input, ThriftStructDecorator.FIELD_NEW, Boolean.TYPE) && this.checkField(input, ThriftStructDecorator.FIELD_MODIFIED, Integer.TYPE) && this.checkField(input, ThriftStructDecorator.FIELD_INITIALIZED, Integer.TYPE);
                boolean m2 = this.checkField(input, ThriftStructDecorator.FIELD_NEW, Boolean.TYPE) && this.checkField(input, ThriftStructDecorator.FIELD_MODIFIED, int[].class) && this.checkField(input, ThriftStructDecorator.FIELD_INITIALIZED, int[].class);
                boolean bl = m = m1 || m2;
                if (!Strings.isNullOrEmpty((String)sql2javaBeanPkgPrefix)) {
                    m = m && input.getBaseClass().getPackage().getName().startsWith(sql2javaBeanPkgPrefix);
                }
                return m;
            }
            catch (Exception e) {
                return false;
            }
        }
    };

    public ThriftStructDecorator(Class<?> baseClass) {
        this.baseClass = (Class)Preconditions.checkNotNull(baseClass);
        TypeHelper.checkNotGeneric(baseClass);
        if (baseClass.isInterface()) {
            throw new IllegalArgumentException("baseClass must not be interface");
        }
        if (ThriftServiceDecoratorConfiguration.LanguageType.CPP.equals((Object)ThriftServiceDecoratorConfiguration.LanguageType.getCurrent()) && BaseThriftUtils.isException(baseClass) && !BaseThriftUtils.isThriftStruct(baseClass)) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.putAll(this.typeHelper.getFields(BaseServiceException.class, (Predicate<PropertyDescriptor>)Predicates.alwaysTrue(), true));
            builder.putAll(this.typeHelper.getFields(baseClass, (Predicate<PropertyDescriptor>)Predicates.alwaysTrue(), true));
            this.fields = builder.build();
        } else {
            this.fields = ImmutableMap.copyOf(this.typeHelper.getFields(baseClass, (Predicate<PropertyDescriptor>)Predicates.alwaysTrue(), true));
        }
        this.hasOptional = Iterables.tryFind(this.fields.values(), (Predicate)new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor input) {
                return !input.getReadMethod().getReturnType().isPrimitive();
            }
        }).isPresent();
        this.cxxFields = ThriftServiceDecoratorConfiguration.LanguageType.CPP.equals((Object)ThriftServiceDecoratorConfiguration.LanguageType.getCurrent()) ? ThriftStructDecorator.getThriftTypes(this.fields) : Collections.emptyMap();
        this.cxxType = CxxType.getThriftType(this.getBaseClass());
        this.hasCanMove = Iterables.tryFind(this.cxxFields.values(), (Predicate)new Predicate<CxxType>(){

            public boolean apply(CxxType input) {
                return input.getStubType().isCanMove();
            }
        }).isPresent();
        StringBuffer buffer = new StringBuffer(baseClass.getPackage().getName());
        buffer.append(".decorator");
        switch (ThriftServiceDecoratorConfiguration.INSTANCE.getTaskType()) {
            case CLIENT: {
                buffer.append(".").append("client");
                break;
            }
            case CLIENT_THRIFTY: {
                buffer.append(".").append("client");
                break;
            }
        }
        this.decoratorPackage = buffer.toString();
        this.decoratorClassName = this.decoratorPackage + "." + this.baseClass.getSimpleName();
        Class<?> clazz = null;
        if (!this.isThriftStruct()) {
            try {
                clazz = Class.forName(this.decoratorClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.decoratorClass = clazz;
    }

    public boolean compile() {
        for (Map.Entry<String, PropertyDescriptor> entry : this.fields.entrySet()) {
            PropertyDescriptor descriptor = entry.getValue();
            Type returnType = descriptor.getReadMethod().getGenericReturnType();
            this.typeHelper.checkType(returnType);
            this.typeHelper.addReferTypes(returnType);
            if (NameStringUtils.isThriftReserved((String)descriptor.getName())) {
                logger.warn("field name '{}' of {} is thrift IDL reserved word", (Object)descriptor.getName(), (Object)this.getBaseClass().getName());
            }
            if (!NameStringUtils.isJavaReserved((String)descriptor.getName())) continue;
            logger.warn("field name '{}' of {} is java reserved word", (Object)descriptor.getName(), (Object)this.getBaseClass().getName());
        }
        this.addImportedClass(new Type[]{ThriftDecorator.class});
        return true;
    }

    public Method getGetMethod(String field) {
        PropertyDescriptor descriptor = this.getField(field);
        return descriptor.getReadMethod();
    }

    public Method getSetMethod(String field) {
        PropertyDescriptor descriptor = this.getField(field);
        return descriptor.getWriteMethod();
    }

    public Type getFieldType(String field) {
        PropertyDescriptor descriptor = this.getField(field);
        return descriptor.getReadMethod().getGenericReturnType();
    }

    public PropertyDescriptor getField(String field) {
        PropertyDescriptor descriptor = this.fields.get(field);
        if (null == descriptor) {
            throw new IllegalArgumentException(String.format("INVALID field %s in %s", field, this.baseClass.getSimpleName()));
        }
        return descriptor;
    }

    public List<String> getFields() {
        if (this.isThriftStruct()) {
            ThriftStructMetadata thriftMetadata = ThriftCatalogWithTransformer.CATALOG.getThriftStructMetadata((Type)this.getBaseClass());
            if (this.isSql2javaBean()) {
                LinkedList list = Lists.newLinkedList();
                for (ThriftFieldMetadata field : thriftMetadata.getFields()) {
                    String name = field.getName();
                    if (name.equals(FIELD_NEW_) || name.equals(FIELD_INITIALIZED) || name.equals(FIELD_MODIFIED)) continue;
                    list.add(name);
                }
                return list;
            }
            LinkedList list = Lists.newLinkedList();
            for (ThriftFieldMetadata field : thriftMetadata.getFields()) {
                list.add(field.getName());
            }
            return list;
        }
        ArrayList<String> list = new ArrayList<String>(this.fields.keySet());
        Collections.sort(list);
        return list;
    }

    public List<String> getRefFields() {
        return Lists.newArrayList((Iterable)Iterables.filter(this.getFields(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !ThriftStructDecorator.this.getField(input).getPropertyType().isPrimitive();
            }
        }));
    }

    public Object getEnums() {
        if (this.isEnum()) {
            try {
                return this.baseClass.getMethod("values", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return Collections.emptyList();
    }

    public List<PropertyDescriptor> getFieldDescriptors() {
        return ImmutableList.copyOf(this.fields.values());
    }

    public String getDecoratorPackage() {
        return this.decoratorPackage;
    }

    public String getDecoratorClassName() {
        return this.decoratorClassName;
    }

    public List<ThriftStructDecorator> getDecorateTypes() {
        return this.typeHelper.getDecorateTypes();
    }

    public List<ThriftStructDecorator> getThriftTypes() {
        return this.typeHelper.getThriftTypes();
    }

    public boolean isException() {
        return Exception.class.isAssignableFrom(this.getBaseClass());
    }

    public boolean isThriftStruct() {
        return BaseThriftUtils.isThriftStruct((Type)this.getBaseClass());
    }

    public boolean isExtThriftStruct() {
        return ThriftServiceDecoratorConfiguration.INSTANCE.getExtStructs().contains(this.getBaseClass());
    }

    public Class<?> getThriftClass() {
        return this.isThriftStruct() ? this.getBaseClass() : this.decoratorClass;
    }

    public boolean isEnum() {
        return this.getBaseClass().isEnum();
    }

    public boolean isBean() {
        return !this.isException() && !this.isEnum();
    }

    public boolean isSql2javaBean() {
        return this.isBean() && SQL2JAVA_BEAN_FILTER.apply((Object)this);
    }

    public boolean hasStringConstructor() {
        return BaseThriftUtils.hasConstructor((Class)this.getBaseClass(), (Class[])new Class[]{String.class});
    }

    public String toThriftType(Type type) {
        return this.typeHelper.toThriftType(type);
    }

    public String toClientThriftType(Type type) {
        return this.typeHelper.toClientThriftType(type);
    }

    public String toThriftDecoratorType(Type type) {
        return this.typeHelper.toThriftDecoratorType(type);
    }

    public String toClientThriftyType(Type type) {
        return this.typeHelper.toClientThriftyType(type);
    }

    public String toThriftyDecoratorType(Type type) {
        return this.typeHelper.toThriftyDecoratorType(type);
    }

    public boolean sameWithClientThriftType(Type type) {
        return this.typeHelper.sameWithClientThriftType(type);
    }

    public boolean sameWithClientThriftyType(Type type) {
        return this.typeHelper.sameWithClientThriftyType(type);
    }

    public boolean sameWithThriftDecoratorType(Type type) {
        return this.typeHelper.sameWithThriftDecoratorType(type);
    }

    public boolean sameWithThriftyDecoratorType(Type type) {
        return this.typeHelper.sameWithThriftyDecoratorType(type);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.baseClass == null ? 0 : this.baseClass.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThriftStructDecorator)) {
            return false;
        }
        ThriftStructDecorator other = (ThriftStructDecorator)obj;
        return !(this.baseClass == null ? other.baseClass != null : !this.baseClass.equals(other.baseClass));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ThriftStructDecorator [baseClass=");
        builder.append(this.baseClass);
        builder.append("]");
        return builder.toString();
    }

    public void removeDecorateTypesFromImports() {
        Iterable it = Iterables.filter(this.typeHelper.getTypesWithDecorator(), (Predicate)new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return !input.isEnum();
            }
        });
        ArrayList types = Lists.newArrayList((Iterable)it);
        this.removeClassFromImports(types);
    }

    @Override
    public int compare(ThriftStructDecorator o1, ThriftStructDecorator o2) {
        return o1.getBaseClass().getSimpleName().compareTo(o2.getBaseClass().getSimpleName());
    }

    @Override
    public int compareTo(ThriftStructDecorator o) {
        return this.getBaseClass().getSimpleName().compareTo(o.getBaseClass().getSimpleName());
    }

    private static ImmutableMap<String, CxxType> getThriftTypes(Map<String, PropertyDescriptor> fields) {
        Map m = Maps.transformValues((Map)((Map)Preconditions.checkNotNull(fields, (Object)"fields is null")), (Function)new Function<PropertyDescriptor, CxxType>(){

            public CxxType apply(PropertyDescriptor input) {
                return CxxType.getThriftType(input.getReadMethod().getGenericReturnType());
            }
        });
        return ImmutableMap.copyOf((Map)m);
    }

    public ImmutableMap<String, CxxType> getCxxFieldsAsMap() {
        return ImmutableMap.copyOf(this.cxxFields);
    }

    public CxxType getCxxField(String name) {
        return this.cxxFields.get(Preconditions.checkNotNull((Object)name, (Object)"name is null"));
    }

    public boolean isHasOptionalField() {
        return this.hasOptional;
    }

    public boolean isHasCanMoveField() {
        return this.hasCanMove;
    }

    public CxxType getCxxType() {
        return this.cxxType;
    }

    public boolean isUseString() {
        return Iterables.tryFind(this.cxxFields.values(), (Predicate)this.findString).isPresent();
    }

    public boolean isUseBinary() {
        return Iterables.tryFind(this.cxxFields.values(), (Predicate)this.findBinary).isPresent();
    }

    public boolean isUseMap() {
        return Iterables.tryFind(this.cxxFields.values(), (Predicate)this.findMap).isPresent();
    }

    public boolean isUseSet() {
        return Iterables.tryFind(this.cxxFields.values(), (Predicate)this.findSet).isPresent();
    }

    public boolean isUseVector() {
        return Iterables.tryFind(this.cxxFields.values(), (Predicate)this.findArray).isPresent();
    }

    public boolean isUseCodegenInvalidValue() {
        return Iterables.tryFind(this.fields.values(), this.codegenInvalidValueFilter).isPresent();
    }

    public boolean isUseCodegenDefaultvalue() {
        return Iterables.tryFind(this.fields.values(), this.codegenDefaultvalueFilter).isPresent();
    }

    public boolean isUseCodegenLength() {
        return Iterables.tryFind(this.fields.values(), this.codegenLengthFilter).isPresent();
    }

    public boolean isUseCodegenRequired() {
        return Iterables.tryFind(this.fields.values(), this.codegenRequiredFilter).isPresent();
    }

    public boolean needRenderCodegen(PropertyDescriptor input) {
        return this.codegenInvalidValueFilter.apply((Object)input) || this.codegenDefaultvalueFilter.apply((Object)input) || this.codegenLengthFilter.apply((Object)input) || this.codegenRequiredFilter.apply((Object)input);
    }

    public String renderCodegenInvalidValue(PropertyDescriptor input) {
        if (this.codegenInvalidValueFilter.apply((Object)input)) {
            CodegenInvalidValue ann = (CodegenInvalidValue)GeneratorUtils.extractFieldAnnotation((PropertyDescriptor)input, CodegenInvalidValue.class);
            if (ann.value().length() > 0) {
                return String.format("@CodegenInvalidValue(\"%s\")", ann.value());
            }
            return String.format("@CodegenInvalidValue(exp=\"%s\")", ann.exp());
        }
        return null;
    }

    public String renderCodegenDefaultValue(PropertyDescriptor input) {
        if (this.codegenDefaultvalueFilter.apply((Object)input)) {
            CodegenDefaultvalue ann = (CodegenDefaultvalue)GeneratorUtils.extractFieldAnnotation((PropertyDescriptor)input, CodegenDefaultvalue.class);
            return String.format("@CodegenDefaultvalue(\"%s\")", ann.value());
        }
        return null;
    }

    public String renderCodegenLength(PropertyDescriptor input) {
        if (this.codegenLengthFilter.apply((Object)input)) {
            CodegenLength ann = (CodegenLength)GeneratorUtils.extractFieldAnnotation((PropertyDescriptor)input, CodegenLength.class);
            if (ann.value() > 0) {
                return String.format("@CodegenLength(%d,prealloc=%b)", ann.value(), ann.prealloc());
            }
            return String.format("@CodegenLength(max=%d,prealloc=%b)", ann.max(), ann.prealloc());
        }
        return null;
    }

    public String renderCodegenRequired(PropertyDescriptor input) {
        CodegenRequired ann;
        if (this.codegenRequiredFilter.apply((Object)input) && (ann = (CodegenRequired)GeneratorUtils.extractFieldAnnotation((PropertyDescriptor)input, CodegenRequired.class)).value()) {
            return "@CodegenRequired";
        }
        return null;
    }

    public Integer lengthLimitOf(PropertyDescriptor input) {
        if (this.codegenLengthFilter.apply((Object)input)) {
            CodegenLength ann = (CodegenLength)GeneratorUtils.extractFieldAnnotation((PropertyDescriptor)input, CodegenLength.class);
            int limit = ann.value() > 0 ? ann.value() : ann.max();
            if (String.class.equals(input.getPropertyType())) {
                ++limit;
            }
            return limit;
        }
        return null;
    }

    public String defaultValueOf(PropertyDescriptor input) {
        if (this.codegenDefaultvalueFilter.apply((Object)input)) {
            CodegenDefaultvalue ann = (CodegenDefaultvalue)GeneratorUtils.extractFieldAnnotation((PropertyDescriptor)input, CodegenDefaultvalue.class);
            return ann.value();
        }
        return null;
    }

    public String invalidValueOf(PropertyDescriptor input) {
        if (this.codegenInvalidValueFilter.apply((Object)input)) {
            CodegenInvalidValue ann = (CodegenInvalidValue)GeneratorUtils.extractFieldAnnotation((PropertyDescriptor)input, CodegenInvalidValue.class);
            if (ann.value().length() > 0) {
                return ann.value();
            }
            return ann.exp();
        }
        return null;
    }

    public String initValueOf(PropertyDescriptor input) {
        String initValue = this.invalidValueOf(input);
        return initValue == null ? this.defaultValueOf(input) : initValue;
    }

    public boolean isRequired(PropertyDescriptor input) {
        if (input != null) {
            CodegenRequired ann = (CodegenRequired)GeneratorUtils.extractFieldAnnotation((PropertyDescriptor)input, CodegenRequired.class);
            if (ann != null) {
                return ann.value();
            }
            ThriftField thriftField = (ThriftField)GeneratorUtils.extractFieldAnnotation((PropertyDescriptor)input, ThriftField.class);
            if (thriftField != null) {
                return ThriftField.Requiredness.REQUIRED.equals((Object)thriftField.requiredness());
            }
        }
        return false;
    }

    public boolean isRequired(String name) {
        return this.isRequired(this.fields.get(name));
    }

    public boolean isNeedTransformer() {
        return this.typeHelper.needTransformer();
    }

    private static class TraverseTypeForTryFind
    implements Predicate<CxxType> {
        private Predicate<CxxTypeMeta> finder;

        TraverseTypeForTryFind(Predicate<CxxTypeMeta> finder) {
            this.finder = finder;
        }

        public boolean apply(CxxType input) {
            if (null == input) {
                return false;
            }
            CxxTypeMeta type = input.getUiType();
            if (this.finder.apply((Object)type)) {
                return true;
            }
            if (type.isContainer()) {
                CxxTypeMeta keyType = type.getKeyType();
                CxxTypeMeta valueType = type.getValueType();
                if (null != keyType && this.finder.apply((Object)keyType)) {
                    return true;
                }
                if (null != valueType && this.finder.apply((Object)valueType)) {
                    return true;
                }
            }
            return false;
        }
    }
}

