/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.thrift;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.gdface.codegen.thrift.CxxType;

public class CxxHelper {
    private static ThreadLocal<ArrayList<String>> tlsPackageName = new ThreadLocal();
    private static ThreadLocal<Boolean> tlsMultiline = new ThreadLocal();

    private static String getCurrent(String separator) {
        ArrayList<String> pkg = tlsPackageName.get();
        if (pkg == null) {
            return "";
        }
        return Joiner.on((String)separator).join(pkg);
    }

    public static String getCurrentNamespace() {
        return CxxHelper.getCurrent("::");
    }

    public static String getCurrentPackageAsJava() {
        return CxxHelper.getCurrent(".");
    }

    public static boolean isCurrentPackage(Class<?> clazz) {
        return clazz == null ? false : clazz.getPackage().getName().equals(CxxHelper.getCurrentPackageAsJava());
    }

    public static String namespaceBegin(String packageName, boolean multiline) {
        packageName = (String)MoreObjects.firstNonNull((Object)packageName, (Object)"");
        ArrayList names = Lists.newArrayList((Iterable)Iterables.filter(Arrays.asList(packageName.split("(\\.|::)")), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !input.trim().isEmpty();
            }
        }));
        tlsPackageName.set(names);
        tlsMultiline.set(multiline);
        StringBuilder builder = new StringBuilder();
        for (String name : names) {
            builder.append(String.format("namespace %s{", name));
            if (!multiline) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    public static String namespaceBegin(Class<?> clazz) {
        return clazz == null ? "// class is null\n" : CxxHelper.namespaceBegin(clazz.getPackage().getName(), true);
    }

    public static String namespaceBegin(Class<?> clazz, boolean multiline) {
        return clazz == null ? "// class is null\n" : CxxHelper.namespaceBegin(clazz.getPackage().getName(), multiline);
    }

    public static String namespaceEnd() {
        List names = (List)MoreObjects.firstNonNull((Object)tlsPackageName.get(), Collections.emptyList());
        StringBuilder builder = new StringBuilder();
        for (String name : Lists.reverse((List)names)) {
            builder.append(String.format("} /* namespace %s */", name));
        }
        if (Boolean.TRUE.equals(tlsMultiline.get())) {
            builder.append("\n");
        }
        tlsPackageName.remove();
        tlsMultiline.remove();
        return builder.toString();
    }

    public static String cxxNamespace(String javaName, boolean isfull) {
        if (javaName == null || !isfull) {
            return "";
        }
        return javaName.replaceAll("[\\.\\$]", "::");
    }

    public static String cxxNamespace(Class<?> clazz, boolean isfull) {
        return clazz == null ? "// class is null\n" : CxxHelper.cxxNamespace(clazz.getPackage().getName(), isfull);
    }

    public static String cxxNamespace(String packageName) {
        return CxxHelper.cxxNamespace(packageName, true);
    }

    public static String cxxNamespace(Class<?> clazz) {
        return CxxHelper.cxxNamespace(clazz, true);
    }

    public static String cxxClassName(Class<?> clazz, boolean isfull) {
        if (clazz == null) {
            return "";
        }
        if (isfull) {
            return CxxHelper.cxxNamespace(String.valueOf(clazz.getPackage().getName()) + "." + clazz.getSimpleName(), true);
        }
        return clazz.getSimpleName();
    }

    public static String cxxClassName(Class<?> clazz) {
        return CxxHelper.getTypeName(CxxHelper.cxxClassName(clazz, true));
    }

    public static String simpleName(String cxxType) {
        if (cxxType != null) {
            return cxxType.replaceAll("^(?:::)?(?:\\w+::)*", "");
        }
        return cxxType;
    }

    public static String getCxxNamespace(String cxxType) {
        if (cxxType == null) {
            return "";
        }
        return cxxType.replaceAll("::\\w+$", "");
    }

    public static String getCxxNamespaceOfJava(String javaClassName) {
        if (javaClassName == null) {
            return "";
        }
        return CxxHelper.getCxxNamespace(CxxHelper.cxxNamespace(javaClassName, true));
    }

    public static String getTypeName(String cxxType) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cxxType) && cxxType.indexOf(46) == -1 ? 1 : 0) != 0, (String)"invalid c++ Type %s", (Object)cxxType);
        String cns = CxxHelper.getCurrentNamespace();
        if (!cns.isEmpty()) {
            cns = String.valueOf(CxxHelper.getCurrentNamespace()) + "::";
        }
        return cxxType.replaceFirst(cns, "");
    }

    public CxxType getCxxType(Type type) {
        return CxxType.getThriftType(type);
    }

    public boolean needCast(Type type) {
        return CxxType.getThriftType(type).isNeedCast();
    }
}

