/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.thrift;

import com.facebook.swift.codec.metadata.PatternFilter;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.gdface.annotation.DeriveMethod;
import net.gdface.codegen.thrift.ThriftServiceDecoratorConfiguration;
import net.gdface.utils.MiscellaneousUtils;
import org.apache.commons.configuration2.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodFilter
implements Predicate<Method> {
    private static final Logger logger = LoggerFactory.getLogger(MethodFilter.class);
    private static final String SUFFIX_INCLUDE = ".include";
    private static final String SUFFIX_EXCLUDE = ".exclude";
    private final Configuration configuration = ThriftServiceDecoratorConfiguration.INSTANCE.getConfig();
    private Set<Method> includeMethods;
    private Set<Method> excludeMethods;

    public MethodFilter(Class<?> inputClass) {
        Preconditions.checkArgument((inputClass != null ? 1 : 0) != 0, (Object)"inputClass is null");
        ImmutableMap methods = Maps.uniqueIndex(Arrays.asList(inputClass.getDeclaredMethods()), (Function)new Function<Method, String>(){

            public String apply(Method input) {
                StringBuffer buffer = new StringBuffer(input.getName());
                DeriveMethod dm = input.getAnnotation(DeriveMethod.class);
                if (dm != null && dm.methodSuffix().length > 0) {
                    buffer.append('.').append(dm.methodSuffix()[0]);
                }
                return buffer.toString();
            }
        });
        String includeKey = String.valueOf(inputClass.getName()) + SUFFIX_INCLUDE;
        String excludeKey = String.valueOf(inputClass.getName()) + SUFFIX_EXCLUDE;
        this.includeMethods = this.getMethodList(includeKey, inputClass, (Map<String, Method>)methods, false);
        this.excludeMethods = this.getMethodList(excludeKey, inputClass, (Map<String, Method>)methods, true);
        if (this.excludeMethods.isEmpty()) {
            this.excludeMethods = this.getExcludeMethodList(inputClass, (Map<String, Method>)methods);
        }
        if (this.includeMethods.isEmpty()) {
            this.includeMethods = this.getIncludeMethodList(inputClass, (Map<String, Method>)methods);
        }
        if (!this.includeMethods.isEmpty() && !this.excludeMethods.isEmpty()) {
            logger.warn("{} and {} all defined, this first used preferentially", (Object)includeKey, (Object)excludeKey);
        }
    }

    private List<Method> findMethod(String pattern, Map<String, Method> methods, boolean startsWithAsTrue) {
        ArrayList<Method> found = new ArrayList<Method>();
        for (Map.Entry<String, Method> entry : methods.entrySet()) {
            String key;
            String port = key = entry.getKey();
            if (key.indexOf(".") >= 0) {
                port = Joiner.on((String)"").join((Object[])key.split("\\."));
            }
            if (!PatternFilter.filter((String)pattern, (String)port, (boolean)startsWithAsTrue)) continue;
            found.add(entry.getValue());
        }
        return found;
    }

    private Set<Method> getMethodList(String key, Class<?> interfaceClass, Map<String, Method> methods, boolean startsWithAsTrue) {
        HashSet sets = Sets.newHashSet();
        if (this.configuration.containsKey(key)) {
            for (String name : MiscellaneousUtils.elementsOf((String)this.configuration.getString(key))) {
                List<Method> found = this.findMethod(name, methods, startsWithAsTrue);
                if (found.isEmpty()) {
                    logger.warn("NOT FOUND Method named '{}' in {}", (Object)name, (Object)interfaceClass.getName());
                    continue;
                }
                sets.addAll(found);
            }
        }
        return sets;
    }

    private Set<Method> getExcludeMethodList(Class<?> interfaceClass, Map<String, Method> methods) {
        HashSet sets = Sets.newHashSet();
        List<String> names = ThriftServiceDecoratorConfiguration.INSTANCE.getExcludeMethods().get(interfaceClass);
        if (names != null) {
            for (String name : names) {
                List<Method> found = this.findMethod(name, methods, true);
                if (found.isEmpty()) {
                    logger.warn("NOT FOUND Method named '{}' in {}", (Object)name, (Object)interfaceClass.getName());
                    continue;
                }
                sets.addAll(found);
            }
        }
        return sets;
    }

    private Set<Method> getIncludeMethodList(Class<?> interfaceClass, Map<String, Method> methods) {
        HashSet sets = Sets.newHashSet();
        List<String> names = ThriftServiceDecoratorConfiguration.INSTANCE.getIncludeMethods().get(interfaceClass);
        if (names != null) {
            for (String name : names) {
                List<Method> found = this.findMethod(name, methods, false);
                if (found.isEmpty()) {
                    logger.warn("NOT FOUND Method named '{}' in {}", (Object)name, (Object)interfaceClass.getName());
                    continue;
                }
                sets.addAll(found);
            }
        }
        return sets;
    }

    public boolean apply(Method input) {
        if (!this.includeMethods.isEmpty()) {
            return this.includeMethods.contains(input);
        }
        if (!this.excludeMethods.isEmpty()) {
            return !this.excludeMethods.contains(input);
        }
        return true;
    }
}

