/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.thrift;

import com.facebook.swift.codec.metadata.DecoratorThriftEnumMetadata;
import com.facebook.swift.codec.metadata.DecoratorThriftStructMetadata;
import com.facebook.swift.codec.metadata.Decorators;
import com.facebook.swift.codec.metadata.ErpcProxyReturnCode;
import com.facebook.swift.codec.metadata.ErpcType;
import com.facebook.swift.codec.metadata.ThriftCatalogWithTransformer;
import com.gitee.l0km.aocache.annotations.AoCacheable;
import com.gitee.l0km.aocache.aop.AocacheAnnotatedAspect;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.gdface.codegen.Method;
import net.gdface.codegen.thrift.CxxHelper;
import net.gdface.codegen.thrift.CxxType;
import net.gdface.codegen.thrift.CxxTypeMeta;
import net.gdface.codegen.thrift.ThriftConstants;
import net.gdface.codegen.thrift.ThriftSchema$AjcClosure1;
import net.gdface.codegen.thrift.ThriftSchema$AjcClosure3;
import net.gdface.codegen.thrift.ThriftSchema$AjcClosure5;
import net.gdface.codegen.thrift.ThriftServiceDecorator;
import net.gdface.codegen.thrift.ThriftServiceDecoratorConfiguration;
import net.gdface.codegen.thrift.ThriftStructDecorator;
import net.gdface.codegen.thrift.TypeHelper;
import net.gdface.thrift.BaseThriftUtils;
import net.gdface.thrift.exception.ServiceRuntimeException;
import net.gdface.utils.BeanRelativeUtilits;
import net.gdface.utils.ClassCommentProvider;
import net.gdface.utils.NameStringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class ThriftSchema
implements ThriftConstants {
    private final Set<ThriftStructDecorator> thriftStructDecorators = Sets.newLinkedHashSet();
    private final Set<ThriftStructDecorator> thriftStructs = Sets.newLinkedHashSet();
    private final Set<ErpcType> collectionStructs = Sets.newTreeSet();
    private final List<ThriftServiceDecorator<?>> thriftServiceDecorators = Lists.newLinkedList();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public ThriftSchema(Map<Class<?>, Class<?>> interfaceClasses) {
        for (Map.Entry<Class<?>, Class<?>> entry : interfaceClasses.entrySet()) {
            Class<?> interfaceClass = entry.getKey();
            Class<?> refClass = entry.getValue();
            if (refClass == ThriftServiceDecoratorConfiguration.DEF_REF_CLASS) {
                refClass = null;
            }
            ThriftServiceDecorator service = new ThriftServiceDecorator(interfaceClass, refClass);
            this.thriftServiceDecorators.add(service);
        }
        if (!this.compile()) {
            throw new IllegalStateException("compile fail");
        }
    }

    public List<ThriftStructDecorator> getAllStructDecorators() {
        return Lists.newArrayList(this.thriftStructDecorators);
    }

    public List<ThriftStructDecorator> getExceptionDecorators() {
        return Lists.newArrayList((Iterable)Sets.filter(this.thriftStructDecorators, ThriftStructDecorator::isException));
    }

    public List<ThriftStructDecorator> getEnumDecorators() {
        return Lists.newArrayList((Iterable)Sets.filter(this.thriftStructDecorators, ThriftStructDecorator::isEnum));
    }

    public List<ThriftStructDecorator> getBeanDecorators() {
        return Lists.newArrayList((Iterable)Sets.filter(this.thriftStructDecorators, ThriftStructDecorator::isBean));
    }

    public List<ThriftServiceDecorator<?>> getThriftServiceDecorators() {
        return this.thriftServiceDecorators;
    }

    private boolean compile() {
        for (ThriftServiceDecorator<?> thriftServiceDecorator : this.getThriftServiceDecorators()) {
            if (!thriftServiceDecorator.compile()) {
                return false;
            }
            this.thriftStructDecorators.addAll(thriftServiceDecorator.getDecorateTypes());
            this.thriftStructs.addAll(thriftServiceDecorator.getThriftTypes());
        }
        for (ThriftStructDecorator thriftStructDecorator : this.getAllStructDecorators()) {
            if (!thriftStructDecorator.compile()) {
                return false;
            }
            this.thriftStructDecorators.addAll(thriftStructDecorator.getDecorateTypes());
            this.thriftStructs.addAll(thriftStructDecorator.getThriftTypes());
        }
        return true;
    }

    public boolean isThriftBuildinType(Type type) {
        return BaseThriftUtils.isThriftBuildinType((Type)type);
    }

    public boolean isCastType(Type type) {
        return BaseThriftUtils.isCastType((Type)type);
    }

    public boolean isDecoratorType(Type type) {
        return this.getDecoratorType(type) != null;
    }

    public ThriftStructDecorator getDecoratorType(Type type) {
        return (ThriftStructDecorator)Iterables.tryFind(this.thriftStructDecorators, struct -> struct.getBaseClass().equals(type)).orNull();
    }

    public boolean isThriftStruct(Type type) {
        return BaseThriftUtils.isThriftStruct((Type)type);
    }

    public boolean isPrimitivefloat(Type type) {
        return BaseThriftUtils.isPrimitivefloat((Type)type);
    }

    public boolean isfloat(Type type) {
        return BaseThriftUtils.isfloat((Type)type);
    }

    public boolean isPrimitiveArray(Type type) {
        return BaseThriftUtils.isPrimitiveArray((Type)type);
    }

    public boolean isMap(Type type) {
        return TypeToken.of((Type)type).getRawType() == Map.class;
    }

    public boolean isList(Type type) {
        return TypeToken.of((Type)type).getRawType() == List.class;
    }

    public boolean isSet(Type type) {
        return TypeToken.of((Type)type).getRawType() == Set.class;
    }

    public boolean isCollection(Type type) {
        return this.isList(type) || this.isSet(type);
    }

    public boolean isArray(Type type) {
        return this.isList(type) || this.isSet(type);
    }

    public boolean isBinary(Type type) {
        return type == byte[].class;
    }

    public final Type wrap(Type type) {
        return TypeToken.of((Type)type).wrap().getType();
    }

    public String escapeThrift(String name) {
        return NameStringUtils.isThriftReserved((String)name) ? String.valueOf(name) + "_" : name;
    }

    public String escapeField(String name) {
        if (NameStringUtils.isJavaReserved((String)name)) {
            return "_" + name;
        }
        return this.escapeThrift(name);
    }

    public static boolean isIsLocalMethod(java.lang.reflect.Method method) {
        return BaseThriftUtils.isIsLocalMethod((java.lang.reflect.Method)method);
    }

    public static boolean isIsLocalMethod(Method method) {
        return BaseThriftUtils.isIsLocalMethod((java.lang.reflect.Method)method.delegate());
    }

    public Type[] getActualTypeArguments(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return new Type[0];
    }

    public Class<?> getServiceRuntimeExceptionClass() {
        return ServiceRuntimeException.class;
    }

    public String toStubType(Class<?> clazz) {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"clazz is null");
        if (this.isThriftStruct(clazz) || Enum.class.isAssignableFrom(clazz) || this.isDecoratorType(clazz)) {
            return String.valueOf(ThriftServiceDecoratorConfiguration.INSTANCE.getThriftClientPackage()) + "." + clazz.getSimpleName();
        }
        throw new IllegalArgumentException(String.format("%s is not thrift stub type", clazz.getName()));
    }

    public String toStubCxxType(Class<?> clazz) {
        return CxxHelper.cxxNamespace("::" + this.toStubType(clazz), true);
    }

    public List<ThriftStructDecorator> getThriftStructDecorator(String pkg) {
        ImmutableList list = FluentIterable.from(this.thriftStructDecorators).filter(struct -> struct.getBaseClass().getPackage().getName().equals(pkg)).toList();
        return Ordering.natural().sortedCopy((Iterable)list);
    }

    protected List<ThriftStructDecorator> getGenSequence(boolean thriftStructIncluded) {
        List<ThriftStructDecorator> types = this.getAllStructDecorators();
        if (thriftStructIncluded) {
            types.addAll(this.thriftStructs);
            for (Class<?> structType : ThriftServiceDecoratorConfiguration.INSTANCE.getExtStructs()) {
                types.add(TypeHelper.makeThriftStructDecorator(structType));
            }
        }
        List list = BeanRelativeUtilits.sortByField(types, (String)"name");
        ArrayDeque<ThriftStructDecorator> seq = new ArrayDeque<ThriftStructDecorator>();
        for (ThriftStructDecorator struct : list) {
            this.traverseMember(struct, seq, thriftStructIncluded);
        }
        return Lists.newArrayList(seq.descendingIterator());
    }

    private void traverseMember(ThriftStructDecorator parent, Deque<ThriftStructDecorator> seq, boolean thriftStructIncluded) {
        if (!seq.contains(parent)) {
            List decoratorMembers = BeanRelativeUtilits.sortByField(parent.getDecorateTypes(), (String)"name");
            for (ThriftStructDecorator struct : decoratorMembers) {
                this.traverseMember(struct, seq, thriftStructIncluded);
            }
            if (thriftStructIncluded) {
                List thriftMembers = BeanRelativeUtilits.sortByField(parent.getThriftTypes(), (String)"name");
                for (ThriftStructDecorator struct : thriftMembers) {
                    this.traverseMember(struct, seq, thriftStructIncluded);
                }
            }
            seq.push(parent);
        }
    }

    public ListMultimap<String, Collection<ThriftStructDecorator>> getStructGenSequenceAsMultimap(boolean thriftStructIncluded) {
        List<ThriftStructDecorator> seqlist = this.getGenSequence(thriftStructIncluded);
        seqlist.add(new ThriftStructDecorator(this.getServiceRuntimeExceptionClass()));
        LinkedListMultimap seq = LinkedListMultimap.create();
        String curPkg = null;
        List sub = null;
        for (ThriftStructDecorator struct : seqlist) {
            String pkg = struct.getPackage();
            if (!pkg.equals(curPkg)) {
                if (curPkg != null) {
                    seq.put(curPkg, (Object)sub);
                }
                sub = Lists.newLinkedList();
                curPkg = struct.getPackage();
            }
            sub.add(struct);
        }
        if (curPkg != null) {
            seq.put(curPkg, sub);
        }
        return seq;
    }

    public boolean isUseStringInServices() {
        return Iterables.tryFind(this.thriftServiceDecorators, ThriftServiceDecorator::isUseStringInService).isPresent();
    }

    public boolean isUseBinaryInServices() {
        return Iterables.tryFind(this.thriftServiceDecorators, ThriftServiceDecorator::isUseBinaryInService).isPresent();
    }

    public boolean isUseStringInTypes() {
        return Iterables.tryFind(this.thriftStructDecorators, ThriftStructDecorator::isUseString).isPresent();
    }

    public boolean isUseBinaryInTypes() {
        return Iterables.tryFind(this.thriftStructDecorators, ThriftStructDecorator::isUseBinary).isPresent();
    }

    public boolean isUseMapInTypes() {
        return Iterables.tryFind(this.thriftStructDecorators, ThriftStructDecorator::isUseMap).isPresent();
    }

    public boolean isUseSetInTypes() {
        return Iterables.tryFind(this.thriftStructDecorators, ThriftStructDecorator::isUseSet).isPresent();
    }

    public boolean isUseVectorInTypes() {
        return Iterables.tryFind(this.thriftStructDecorators, ThriftStructDecorator::isUseVector).isPresent() || this.isSql2java4x();
    }

    @AoCacheable
    public boolean isSql2java4x() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.booleanValue((Object)AocacheAnnotatedAspect.aspectOf().cacheRround(new ThriftSchema$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
    }

    public boolean isUseExceptionInTypes() {
        return Iterables.tryFind(this.thriftStructDecorators, ThriftStructDecorator::isException).isPresent();
    }

    @AoCacheable
    public boolean isCanMove(CxxType cxxType) {
        CxxType cxxType2 = cxxType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)cxxType2);
        Object[] objectArray = new Object[]{this, cxxType2, joinPoint};
        return Conversions.booleanValue((Object)AocacheAnnotatedAspect.aspectOf().cacheRround(new ThriftSchema$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @AoCacheable
    public boolean isCommonType(Type type) {
        Type type2 = type;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)type2);
        Object[] objectArray = new Object[]{this, type2, joinPoint};
        return Conversions.booleanValue((Object)AocacheAnnotatedAspect.aspectOf().cacheRround(new ThriftSchema$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648)));
    }

    public String getProgramName() {
        return ThriftServiceDecoratorConfiguration.INSTANCE.getProgramName();
    }

    public String getPortPrefix() {
        return ThriftServiceDecoratorConfiguration.INSTANCE.getPortPrefix();
    }

    public ThriftSchema setThriftServiceClasses(Map<Class<?>, Class<?>> thriftServiceClasses) {
        if (thriftServiceClasses != null) {
            for (ThriftServiceDecorator<?> decorator : this.thriftServiceDecorators) {
                decorator.setThriftServiceClass(thriftServiceClasses.get(decorator.getInterfaceClass())).erpcProxyInit();
            }
        }
        return this;
    }

    public DecoratorThriftEnumMetadata<?> getThriftEnumMetadata(Type type) {
        if (type instanceof Class) {
            return (DecoratorThriftEnumMetadata)ThriftCatalogWithTransformer.CATALOG.getThriftEnumMetadata((Class)type);
        }
        return null;
    }

    public DecoratorThriftEnumMetadata<?> getThriftEnumMetadata(String className) throws ClassNotFoundException {
        return this.getThriftEnumMetadata(Class.forName(className));
    }

    public DecoratorThriftStructMetadata getThriftStructMetadata(Type type) {
        return (DecoratorThriftStructMetadata)ThriftCatalogWithTransformer.CATALOG.getThriftStructMetadata(type);
    }

    public DecoratorThriftStructMetadata getThriftStructMetadata(String className) throws ClassNotFoundException {
        return this.getThriftStructMetadata(Class.forName(className));
    }

    public List<ErpcType> getCollectionStructs() {
        return Lists.newArrayList(this.collectionStructs);
    }

    public List<ErpcType> getCollectionStructs(boolean structElement) {
        Iterable filtered = Iterables.filter(this.collectionStructs, c -> {
            boolean isStruct = this.isThriftStruct(c.getValueType().getJavaType());
            return structElement ? isStruct : !isStruct;
        });
        ArrayList types = Lists.newArrayList((Iterable)filtered);
        return types;
    }

    public int getExistsListString() {
        return Iterables.tryFind(this.collectionStructs, c -> c.getValueType().getProtocolType().isString()).isPresent() ? 1 : 0;
    }

    public int getExistsListBinary() {
        return Iterables.tryFind(this.collectionStructs, c -> c.getValueType().getProtocolType().isBinary()).isPresent() ? 1 : 0;
    }

    public ThriftSchema erpcProxyInit() {
        if (ThriftServiceDecoratorConfiguration.TaskType.ERPC_PROXY.equals((Object)ThriftServiceDecoratorConfiguration.INSTANCE.getTaskType())) {
            for (ThriftServiceDecorator<?> newSourceInfo : this.getThriftServiceDecorators()) {
                this.collectionStructs.addAll(newSourceInfo.getCollectionTypes());
            }
            DecoratorThriftEnumMetadata.beforeExtensiveEnumItems = this.createBeforeExtensiveEnumItem();
            this.thriftStructs.add(new ThriftStructDecorator(ErpcProxyReturnCode.class));
        }
        return this;
    }

    private ImmutableMap<Class<? extends Enum<?>>, List<DecoratorThriftEnumMetadata.ExtensiveEnumItem>> createBeforeExtensiveEnumItem() {
        ArrayList items = Lists.newArrayList();
        for (ThriftStructDecorator type : this.thriftStructDecorators) {
            Class javaType = type.getBaseClass();
            if (!(javaType instanceof Class) || !Exception.class.isAssignableFrom(javaType)) continue;
            ImmutableList comment = null;
            if (Decorators.javadocCommentProviderFactory != null) {
                comment = ((ClassCommentProvider)Decorators.javadocCommentProviderFactory.apply((Object)javaType)).commentOfClass();
            }
            items.add(new DecoratorThriftEnumMetadata.ExtensiveEnumItem(javaType.getSimpleName(), null, comment));
        }
        return ImmutableMap.of(ErpcProxyReturnCode.class, (Object)items);
    }

    public int getErpcForwardPort() {
        return ThriftServiceDecoratorConfiguration.INSTANCE.getErpcForwardPort();
    }

    public int getErpcProxyPort() {
        return ThriftServiceDecoratorConfiguration.INSTANCE.getErpcProxyPort();
    }

    public int getDefaultMaxLength() {
        return ThriftServiceDecoratorConfiguration.INSTANCE.getDefaultMaxLength();
    }

    public int getErrmsgMaxLength() {
        return ThriftServiceDecoratorConfiguration.INSTANCE.getErrmsgMaxLength();
    }

    public int getBinaryOutputSize() {
        return ThriftServiceDecoratorConfiguration.INSTANCE.getBinaryOutputSize();
    }

    static {
        ThriftSchema.ajc$preClinit();
    }

    static final /* synthetic */ boolean isSql2java4x_aroundBody0(ThriftSchema ajc$this, JoinPoint joinPoint) {
        return ajc$this.thriftStructs.stream().anyMatch(ThriftStructDecorator::isSql2java4x);
    }

    static final /* synthetic */ boolean isCanMove_aroundBody2(ThriftSchema ajc$this, CxxType cxxType, JoinPoint joinPoint) {
        if (cxxType == null) {
            return false;
        }
        CxxTypeMeta uiType = cxxType.getUiType();
        if (uiType.isCanMove() && !uiType.isStruct()) {
            return true;
        }
        ThriftStructDecorator memSturct = ajc$this.getDecoratorType(cxxType.getJavaType());
        return memSturct != null && memSturct.isHasCanMoveField();
    }

    static final /* synthetic */ boolean isCommonType_aroundBody4(ThriftSchema ajc$this, Type type, JoinPoint joinPoint) {
        if (type instanceof Class) {
            Set<String> commonTypes = ThriftServiceDecoratorConfiguration.INSTANCE.getCommonTypes();
            return FluentIterable.from(commonTypes).anyMatch(str -> {
                Class clazz = (Class)type;
                return clazz.getName().equals(str) || clazz.getSimpleName().equals(str) || clazz.getPackage().getName().startsWith((String)str);
            });
        }
        return false;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ThriftSchema.java", ThriftSchema.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSql2java4x", "net.gdface.codegen.thrift.ThriftSchema", "", "", "", "boolean"), 288);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isCanMove", "net.gdface.codegen.thrift.ThriftSchema", "net.gdface.codegen.thrift.CxxType", "cxxType", "", "boolean"), 295);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isCommonType", "net.gdface.codegen.thrift.ThriftSchema", "java.lang.reflect.Type", "type", "", "boolean"), 307);
    }
}

