/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.thrift;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import gu.doc.JavadocReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.gdface.codegen.generator.CodeWriter;
import net.gdface.codegen.generator.CxxCodeWriter;
import net.gdface.codegen.generator.GeneratorConfiguration;
import net.gdface.codegen.generator.JavaCodeWriter;
import net.gdface.codegen.thrift.ThriftConstants;
import net.gdface.thrift.BaseThriftUtils;
import net.gdface.utils.ConditionChecks;
import net.gdface.utils.MiscellaneousUtils;
import net.gdface.utils.SimpleLog;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;

public class ThriftServiceDecoratorConfiguration
extends GeneratorConfiguration
implements ThriftConstants {
    private static final String ENCODING = "UTF-8";
    public static final String DEFAULT_TEMPLATE_FOLDER = "thrift";
    public static final String DEFAULT_LANGUAGE = "JAVA";
    public static final Class<?> DEF_REF_CLASS = Object.class;
    private static final String NO_REF_CLASS = "";
    private static final Map<String, String> defaultExcludeFields = ImmutableMap.of((Object)"gu.sql2java.BaseBean", (Object)"modified,initialized");
    private Map<Class<?>, Class<?>> interfaceClasses;
    private Map<Class<?>, Class<?>> thriftServiceClasses;
    private TaskType taskType;
    private LanguageType languageType;
    private String thriftClientPackage;
    private String sourcepath;
    private String classpath;
    private final PropertiesConfiguration config = new PropertiesConfiguration();
    private Set<String> reqiredTags = Collections.emptySet();
    private Set<String> commonTypes = Collections.emptySet();
    private String programName;
    private String portPrefix;
    private Map<Class<?>, List<String>> excludeMethods = Maps.newHashMap();
    private Map<Class<?>, List<String>> includeMethods = Maps.newHashMap();
    private final Map<Class<?>, List<String>> excludeFields;
    private int erpcForwardPort;
    private int erpcProxyPort;
    private int defaultMaxLength = 256;
    private int errmsgMaxLength = 256;
    private int binaryOutputSize = 256;
    private final List<Class<?>> extStructs;
    public static final ThriftServiceDecoratorConfiguration INSTANCE = new ThriftServiceDecoratorConfiguration();

    private ThriftServiceDecoratorConfiguration() {
        this.defaultValue.setProperty("template-folder", (Object)DEFAULT_TEMPLATE_FOLDER);
        this.defaultValue.setProperty("reference-class", (Object)NO_REF_CLASS);
        this.defaultValue.setProperty("thrift-package", (Object)NO_REF_CLASS);
        this.defaultValue.setProperty("language", (Object)DEFAULT_LANGUAGE);
        this.defaultValue.setProperty("config", null);
        this.defaultValue.setProperty("source-path", (Object)NO_REF_CLASS);
        this.defaultValue.setProperty("class-path", (Object)NO_REF_CLASS);
        this.defaultValue.setProperty("tags", (Object)NO_REF_CLASS);
        this.defaultValue.setProperty("common-types", (Object)NO_REF_CLASS);
        this.defaultValue.setProperty("erpc-program", (Object)NO_REF_CLASS);
        this.defaultValue.setProperty("erpc-port-prefix", (Object)NO_REF_CLASS);
        this.defaultValue.setProperty("exclude-methods", (Object)new String[0]);
        this.defaultValue.setProperty("include-methods", (Object)new String[0]);
        this.defaultValue.setProperty("exclude-fields", (Object)new String[0]);
        this.defaultValue.setProperty("thrift-service-class", (Object)NO_REF_CLASS);
        this.excludeFields = Maps.newHashMap();
        for (Map.Entry<String, String> entry : defaultExcludeFields.entrySet()) {
            try {
                this.excludeFields.put(Class.forName(entry.getKey()), MiscellaneousUtils.elementsOf((String)entry.getValue()));
            }
            catch (ClassNotFoundException e) {
                SimpleLog.log((String)e.toString(), (Object[])new Object[0]);
            }
        }
        this.defaultValue.setProperty("erpc-forward-port", (Object)0);
        this.defaultValue.setProperty("erpc-proxy-port", (Object)0);
        this.defaultValue.setProperty("erpc-default-max-length", (Object)256);
        this.defaultValue.setProperty("erpc-errmsg-max-length", (Object)256);
        this.defaultValue.setProperty("erpc-binary-output-size", (Object)256);
        this.defaultValue.setProperty("ext-structs", (Object)NO_REF_CLASS);
        this.extStructs = Lists.newArrayList();
    }

    public void loadConfig(Options options, CommandLine cmd) throws ParseException {
        String[] excludeFieldsEntry;
        String[] entry;
        String[] inludeMethodNames;
        String[] entry22;
        int n;
        String program;
        String types;
        super.loadConfig(options, cmd);
        try {
            List<Class<?>> interfaceList = this.toClassArray((String)this.getProperty("interface-class"));
            List<Class<?>> refList = this.toClassArray((String)this.getProperty("reference-class"));
            this.thriftClientPackage = (String)this.getProperty("thrift-package");
            if (refList.size() > 0 && refList.size() != interfaceList.size()) {
                throw new ParseException("mismatch number interface class and reference class");
            }
            this.interfaceClasses = Maps.newLinkedHashMap();
            int i = 0;
            while (i < interfaceList.size()) {
                Class<?> key = interfaceList.get(i);
                if (interfaceList.get(i) != DEF_REF_CLASS) {
                    try {
                        Class<?> value = refList.get(i);
                        this.interfaceClasses.put(key, value);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        this.interfaceClasses.put(key, DEF_REF_CLASS);
                    }
                }
                ++i;
            }
            if (interfaceList.isEmpty()) {
                throw new ParseException("NOT FOUND VALID interface class define");
            }
        }
        catch (ClassNotFoundException e) {
            throw new ParseException("ClassNotFoundException:" + e.getMessage());
        }
        try {
            this.taskType = TaskType.valueOf((String)this.getProperty("task-type"));
            if ((this.taskType == TaskType.CLIENT || this.taskType == TaskType.CLIENT_THRIFTY) && this.thriftClientPackage.isEmpty()) {
                throw new IllegalArgumentException(String.format("must set param :%s", "thrift-package"));
            }
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage());
        }
        try {
            this.languageType = LanguageType.valueOf((String)this.getProperty("language"));
            LanguageType.setCurrent(this.languageType);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage());
        }
        if (this.hasProperty("config")) {
            File configFile = new File((String)this.getProperty("config"));
            Preconditions.checkArgument((configFile.isFile() && configFile.getName().endsWith(".properties") ? 1 : 0) != 0, (String)"%s must be a .properties file", (Object)"config");
            try {
                FileBasedConfigurationBuilder.setDefaultEncoding(PropertiesConfiguration.class, (String)ENCODING);
                new FileHandler((FileBased)this.config).load(configFile);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        this.sourcepath = (String)this.getProperty("source-path");
        this.classpath = (String)this.getProperty("class-path");
        this.classpath = this.classpath.replaceAll(",", File.pathSeparator);
        if (File.pathSeparatorChar != ';') {
            this.classpath = this.classpath.replaceAll(";", File.pathSeparator);
        }
        JavadocReader.setSourcepath((String)this.sourcepath);
        JavadocReader.setClasspath((String)this.classpath);
        String tags = (String)this.getProperty("tags");
        if (!Strings.isNullOrEmpty((String)tags)) {
            this.reqiredTags = Sets.newHashSet((Iterable)MiscellaneousUtils.elementsOf((String)tags));
        }
        if (!Strings.isNullOrEmpty((String)(types = (String)this.getProperty("common-types")))) {
            this.commonTypes = Sets.newHashSet((Iterable)MiscellaneousUtils.elementsOf((String)types));
        }
        if (Strings.isNullOrEmpty((String)(program = (String)this.getProperty("erpc-program")))) {
            ConditionChecks.checkTrue((!this.taskType.equals((Object)TaskType.ERPC_PROXY) ? 1 : 0) != 0, ParseException.class, (String)"must define argument: %s", (Object)"erpc-program");
        } else {
            this.programName = program;
        }
        String prefix = (String)this.getProperty("erpc-port-prefix");
        if (Strings.isNullOrEmpty((String)prefix)) {
            ConditionChecks.checkTrue((!this.taskType.equals((Object)TaskType.ERPC_PROXY) ? 1 : 0) != 0, ParseException.class, (String)"must define argument: %s", (Object)"erpc-port-prefix");
        } else {
            this.portPrefix = prefix;
        }
        String[] excludeMethodNames = (String[])this.getProperty("exclude-methods");
        if (excludeMethodNames != null) {
            String[] stringArray = excludeMethodNames;
            n = excludeMethodNames.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                entry22 = str.split(":");
                try {
                    List names = MiscellaneousUtils.elementsOf((String)entry22[1]);
                    if (!names.isEmpty()) {
                        this.excludeMethods.put(Class.forName(entry22[0]), names);
                    }
                }
                catch (ClassNotFoundException e) {
                    SimpleLog.log((String)e.toString(), (Object[])new Object[0]);
                }
                ++n2;
            }
        }
        if ((inludeMethodNames = (String[])this.getProperty("include-methods")) != null) {
            entry22 = inludeMethodNames;
            int n3 = inludeMethodNames.length;
            n = 0;
            while (n < n3) {
                String str = entry22[n];
                entry = str.split(":");
                try {
                    List names = MiscellaneousUtils.elementsOf((String)entry[1]);
                    if (!names.isEmpty()) {
                        this.includeMethods.put(Class.forName(entry[0]), names);
                    }
                }
                catch (ClassNotFoundException e) {
                    SimpleLog.log((String)e.toString(), (Object[])new Object[0]);
                }
                ++n;
            }
        }
        if ((excludeFieldsEntry = (String[])this.getProperty("exclude-fields")) != null) {
            entry = excludeFieldsEntry;
            int entry22 = excludeFieldsEntry.length;
            int n4 = 0;
            while (n4 < entry22) {
                String str = entry[n4];
                String[] entry3 = str.split(":");
                try {
                    List names = MiscellaneousUtils.elementsOf((String)entry3[1]);
                    if (!names.isEmpty()) {
                        this.excludeFields.put(Class.forName(entry3[0]), names);
                    }
                }
                catch (ClassNotFoundException e) {
                    SimpleLog.log((String)e.toString(), (Object[])new Object[0]);
                }
                ++n4;
            }
        }
        try {
            List<Class<?>> interfaceList = this.toClassArray((String)this.getProperty("interface-class"));
            List<Class<?>> tsList = this.toClassArray((String)this.getProperty("thrift-service-class"));
            ImmutableMap.Builder builer = ImmutableMap.builder();
            if (!tsList.isEmpty()) {
                ConditionChecks.checkTrue((tsList.size() == interfaceList.size() ? 1 : 0) != 0, ParseException.class, (Object)"mismatch number interface class and thrift service class");
                int i = 0;
                while (i < tsList.size()) {
                    builer.put(interfaceList.get(i), tsList.get(i));
                    ++i;
                }
            } else {
                ConditionChecks.checkTrue((!this.taskType.equals((Object)TaskType.ERPC_PROXY) ? 1 : 0) != 0, ParseException.class, (String)"must define argument: %s for ERPC_PROXY task", (Object)"thrift-service-class");
            }
            this.thriftServiceClasses = builer.build();
        }
        catch (ClassNotFoundException e) {
            throw new ParseException("ClassNotFoundException:" + e.getMessage());
        }
        this.erpcForwardPort = ((Number)this.getProperty("erpc-forward-port")).intValue();
        ConditionChecks.checkTrue((!this.taskType.equals((Object)TaskType.ERPC_PROXY) || this.erpcForwardPort > 0 ? 1 : 0) != 0, ParseException.class, (String)"must define argument: %s for ERPC_PROXY task", (Object)"erpc-forward-port");
        this.erpcProxyPort = ((Number)this.getProperty("erpc-proxy-port")).intValue();
        ConditionChecks.checkTrue((!this.taskType.equals((Object)TaskType.ERPC_PROXY) || this.erpcProxyPort > 0 ? 1 : 0) != 0, ParseException.class, (String)"must define argument: %s for ERPC_PROXY task", (Object)"erpc-proxy-port");
        this.defaultMaxLength = ((Number)this.getProperty("erpc-default-max-length")).intValue();
        ConditionChecks.checkTrue((!this.taskType.equals((Object)TaskType.ERPC_PROXY) || this.defaultMaxLength > 0 ? 1 : 0) != 0, ParseException.class, (String)"must define argument: %s for ERPC_PROXY task", (Object)"erpc-default-max-length");
        this.errmsgMaxLength = ((Number)this.getProperty("erpc-errmsg-max-length")).intValue();
        ConditionChecks.checkTrue((!this.taskType.equals((Object)TaskType.ERPC_PROXY) || this.errmsgMaxLength > 0 ? 1 : 0) != 0, ParseException.class, (String)"must define argument: %s for ERPC_PROXY task", (Object)"erpc-errmsg-max-length");
        this.binaryOutputSize = ((Number)this.getProperty("erpc-binary-output-size")).intValue();
        ConditionChecks.checkTrue((!this.taskType.equals((Object)TaskType.ERPC_PROXY) || this.binaryOutputSize > 0 ? 1 : 0) != 0, ParseException.class, (String)"must define argument: %s for ERPC_PROXY task", (Object)"erpc-binary-output-size");
        String extStructNames = (String)this.getProperty("ext-structs");
        if (extStructNames != null) {
            for (String str : MiscellaneousUtils.elementsOf((String)extStructNames)) {
                try {
                    Class<?> clazz = Class.forName(str);
                    if (!BaseThriftUtils.isThriftStruct(clazz)) continue;
                    this.extStructs.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    SimpleLog.log((String)e.toString(), (Object[])new Object[0]);
                }
            }
        }
    }

    private List<Class<?>> toClassArray(String input) throws ClassNotFoundException {
        String[] classNames = input.split(",");
        ArrayList result = Lists.newArrayList();
        String[] stringArray = classNames;
        int n = classNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            result.add(name.isEmpty() ? DEF_REF_CLASS : Class.forName(name));
            ++n2;
        }
        return result;
    }

    public Map<Class<?>, Class<?>> getInterfaceClasses() {
        return this.interfaceClasses;
    }

    public Map<Class<?>, Class<?>> getThriftServiceClasses() {
        return this.thriftServiceClasses;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public LanguageType getLanguageType() {
        return this.languageType;
    }

    public String getTemplateFolder() {
        String folder = super.getTemplateFolder();
        StringBuilder sb = new StringBuilder(folder);
        if (DEFAULT_TEMPLATE_FOLDER.equals(folder)) {
            sb.append(this.getLanguageType().postfix);
        }
        sb.append("/").append(this.getTaskType().folder);
        return sb.toString();
    }

    public String getThriftClientPackage() {
        return this.thriftClientPackage;
    }

    public CodeWriter getCodeWriter() {
        return this.getLanguageType().getCodeWriter(this.getOutputLocation());
    }

    public Configuration getConfig() {
        return this.config;
    }

    public String getSourcepath() {
        return this.sourcepath;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public Set<String> getReqiredTags() {
        return this.reqiredTags;
    }

    public Set<String> getCommonTypes() {
        return this.commonTypes;
    }

    public String getProgramName() {
        return this.programName;
    }

    public String getPortPrefix() {
        return this.portPrefix;
    }

    public Map<Class<?>, List<String>> getExcludeMethods() {
        return this.excludeMethods;
    }

    public Map<Class<?>, List<String>> getIncludeMethods() {
        return this.includeMethods;
    }

    public Map<Class<?>, List<String>> getExcludeFields() {
        return this.excludeFields;
    }

    public int getErpcForwardPort() {
        return this.erpcForwardPort;
    }

    public int getErpcProxyPort() {
        return this.erpcProxyPort;
    }

    public int getDefaultMaxLength() {
        return this.defaultMaxLength;
    }

    public int getErrmsgMaxLength() {
        return this.errmsgMaxLength;
    }

    public int getBinaryOutputSize() {
        return this.binaryOutputSize;
    }

    public List<Class<?>> getExtStructs() {
        return this.extStructs;
    }

    public static enum LanguageType {
        JAVA(""),
        CPP("_cpp"),
        C_GLIB("_c_glib");

        private static LanguageType current;
        public final String postfix;

        static {
            current = null;
        }

        private LanguageType(String postfix) {
            this.postfix = postfix;
        }

        public CodeWriter getCodeWriter(File outputFolder) {
            switch (this) {
                case JAVA: {
                    return new JavaCodeWriter(outputFolder);
                }
                case CPP: {
                    return new CxxCodeWriter(outputFolder);
                }
                case C_GLIB: {
                    return new CxxCodeWriter(outputFolder);
                }
            }
            throw new UnsupportedOperationException("unsupported language type:" + this.name());
        }

        public static LanguageType getCurrent() {
            return current;
        }

        public static synchronized void setCurrent(LanguageType current) {
            Preconditions.checkState((LanguageType.current == null || LanguageType.current.equals((Object)current) ? 1 : 0) != 0, (Object)"LanguageType.current can be initialized only onece");
            LanguageType.current = current;
        }
    }

    public static enum TaskType {
        SERVICE("service", true),
        CLIENT("client", false),
        CLIENT_THRIFTY("client_thrifty", false),
        ERPC_PROXY("erpc_proxy", false);

        public final String folder;
        public final boolean castReferType;

        private TaskType(String folder, boolean castReferType) {
            this.folder = folder;
            this.castReferType = castReferType;
        }
    }
}

