/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.thrift;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.gdface.codegen.AbstractSchema;
import net.gdface.codegen.Method;
import net.gdface.codegen.thrift.ThriftConstants;
import net.gdface.codegen.thrift.ThriftServiceDecorator;
import net.gdface.codegen.thrift.ThriftServiceDecoratorConfiguration;
import net.gdface.codegen.thrift.ThriftStructDecorator;
import net.gdface.thrift.BaseThriftUtils;
import net.gdface.utils.BeanPropertyUtils;
import net.gdface.utils.ParameterizedTypeImpl;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeHelper
implements ThriftConstants {
    private static final Logger logger = LoggerFactory.getLogger(TypeHelper.class);
    private final Set<Class<?>> knownTypes = Sets.newHashSet();
    private final Set<Class<?>> referTypes = Sets.newHashSet();
    private final Map<Class<?>, ThriftStructDecorator> decorateTypes = Maps.newHashMap();
    private final List<ThriftStructDecorator> thriftTypes = Lists.newLinkedList();
    private final AbstractSchema parent;
    private static final ThreadLocal<Deque<Class<?>>> tlsStack = new ThreadLocal<Deque<Class<?>>>(){

        @Override
        protected Deque<Class<?>> initialValue() {
            return new ArrayDeque();
        }
    };
    public static final ThreadLocal<Predicate<Type>> VERIFYTYPE_MONITOR = new ThreadLocal();
    private final Predicate<PropertyDescriptor> expFieldfilter = new Predicate<PropertyDescriptor>(){

        public boolean apply(PropertyDescriptor input) {
            return input.getReadMethod().getDeclaringClass() != Throwable.class;
        }
    };
    private static final Map<Class<?>, Class<?>> thriftExtKnowntypes = ImmutableMap.of(ByteBuffer.class, byte[].class, byte[].class, byte[].class);
    private static final Map<Class<?>, Class<?>> thriftyExtKnowntypes = ImmutableMap.of(ByteBuffer.class, ByteString.class, byte[].class, ByteString.class, ByteString.class, ByteString.class);

    public TypeHelper(AbstractSchema parent) {
        this.parent = (AbstractSchema)Preconditions.checkNotNull((Object)parent, (Object)"parent is null");
        this.knownTypes.addAll(BaseThriftUtils.THRIFT_BUILTIN_KNOWNTYPES);
        this.knownTypes.addAll(BaseThriftUtils.CAST_TYPES.keySet());
    }

    public final boolean verifyType(Type type) {
        if (VERIFYTYPE_MONITOR.get() != null) {
            VERIFYTYPE_MONITOR.get().apply((Object)type);
        }
        if (this.knownTypes.contains(type)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type rawType = paramType.getRawType();
            Type[] typeArgs = paramType.getActualTypeArguments();
            if (rawType == Map.class) {
                return this.verifyType(typeArgs[0]) && this.verifyType(typeArgs[1]);
            }
            if (rawType == List.class) {
                return this.verifyType(typeArgs[0]);
            }
            if (rawType == Set.class) {
                return this.verifyType(typeArgs[0]);
            }
            throw new IllegalArgumentException(String.format("not allow parameterized type %s", type.toString()));
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.getDeclaringClass() != null && !Modifier.isStatic(clazz.getModifiers())) {
                logger.error("unsupport not static member class {}", (Object)clazz);
                return false;
            }
            if (clazz.isPrimitive() || Primitives.isWrapperType((Class)clazz)) {
                logger.error("unsupport primitive type {}", (Object)clazz);
                return false;
            }
            if (BaseThriftUtils.isThriftStruct((Type)clazz)) {
                this.knownTypes.add(clazz);
                this.thriftTypes.add(TypeHelper.makeThriftStructDecorator(clazz));
                return true;
            }
            if (Enum.class.isAssignableFrom(clazz)) {
                this.knownTypes.add(clazz);
                this.decorateTypes.put(clazz, TypeHelper.makeThriftStructDecorator(clazz));
                return true;
            }
            if (clazz.isArray()) {
                if (!clazz.getComponentType().isArray()) {
                    return this.verifyType(clazz.getComponentType());
                }
                logger.error("unsupport multi dimension array {}", (Object)clazz.toString());
                return false;
            }
            if (BaseThriftUtils.isException((Type)clazz)) {
                return this.verifyException(clazz);
            }
            if (Object.class == clazz) {
                logger.error("unsupport not type Object.class");
                return false;
            }
            String pkg = clazz.getPackage().getName();
            if (pkg.startsWith("java.") || pkg.startsWith("javax.")) {
                logger.error("not allow type {}", (Object)type);
                return false;
            }
            return this.verifyStruct(clazz);
        }
        throw new IllegalArgumentException(String.format("not allow type %s", type.toString()));
    }

    private boolean verifyException(Class<?> clazz) {
        if (!BaseThriftUtils.isException(clazz)) {
            return false;
        }
        if (!this.verifyFields(clazz)) {
            return false;
        }
        if (BaseThriftUtils.getConstructor(clazz, (Class[])new Class[0]) == null && BaseThriftUtils.getConstructor(clazz, (Class[])new Class[]{String.class}) == null) {
            logger.error("not found default constructor or consturctor with String.class argument for {}", (Object)clazz.getName());
            return false;
        }
        this.knownTypes.add(clazz);
        this.decorateTypes.put(clazz, TypeHelper.makeThriftStructDecorator(clazz));
        return true;
    }

    private boolean verifyStruct(Class<?> clazz) {
        if (clazz.getTypeParameters().length > 0) {
            logger.error("unsupport generic class {}", (Object)clazz.getName());
            return false;
        }
        try {
            clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.error("not found default consturctor for {}", (Object)clazz.getName());
            return false;
        }
        if (!this.verifyFields(clazz)) {
            return false;
        }
        this.knownTypes.add(clazz);
        this.decorateTypes.put(clazz, TypeHelper.makeThriftStructDecorator(clazz));
        return true;
    }

    private boolean verifyFields(Class<?> clazz) {
        Map<String, PropertyDescriptor> fields = this.getFields(clazz);
        for (PropertyDescriptor descriptor : fields.values()) {
            if (this.verifyType(descriptor.getReadMethod().getGenericReturnType())) continue;
            logger.warn("invalid type for {} in {}", (Object)descriptor.getName(), (Object)clazz.getName());
            return false;
        }
        return true;
    }

    public Map<String, PropertyDescriptor> getFields(Class<?> clazz, Predicate<PropertyDescriptor> filter, boolean lenient) {
        Map fields = BeanPropertyUtils.getProperties(clazz, (int)3, (boolean)lenient);
        Predicate f = (Predicate)Preconditions.checkNotNull(filter, (Object)"filter is null");
        if (BaseThriftUtils.isException(clazz) && f != this.expFieldfilter) {
            f = Predicates.and((Predicate)f, this.expFieldfilter);
        }
        return Maps.filterValues((Map)fields, (Predicate)f);
    }

    public Map<String, PropertyDescriptor> getFields(Class<?> clazz, Predicate<PropertyDescriptor> filter) {
        return this.getFields(clazz, filter, false);
    }

    public Map<String, PropertyDescriptor> getFields(Class<?> clazz) {
        return this.getFields(clazz, (Predicate<PropertyDescriptor>)Predicates.alwaysTrue());
    }

    private boolean isDecoratorType(Type type) {
        return this.decorateTypes.containsKey(type);
    }

    public List<ThriftStructDecorator> getDecorateTypes() {
        return ImmutableList.copyOf(this.decorateTypes.values());
    }

    public List<ThriftStructDecorator> getThriftTypes() {
        return ImmutableList.copyOf(this.thriftTypes);
    }

    public String toThriftType(Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type is null");
        if (BaseThriftUtils.THRIFT_BUILTIN_KNOWNTYPES.contains(type)) {
            return this.parent.getTypeName(type);
        }
        if (BaseThriftUtils.CAST_TYPES.containsKey(type)) {
            return this.parent.getTypeName((Type)BaseThriftUtils.CAST_TYPES.get(type));
        }
        if (this.isDecoratorType(type)) {
            if (Enum.class.isAssignableFrom((Class)type)) {
                return this.parent.getTypeName(type);
            }
            return this.toDecoratorType(type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type rawType = paramType.getRawType();
            Type[] typeArgs = paramType.getActualTypeArguments();
            if (rawType == Map.class) {
                return String.format("Map<%s,%s>", this.toThriftType(typeArgs[0]), this.toThriftType(typeArgs[1]));
            }
            if (rawType == List.class) {
                return String.format("List<%s>", this.toThriftType(typeArgs[0]));
            }
            if (rawType == Set.class) {
                return String.format("Set<%s>", this.toThriftType(typeArgs[0]));
            }
            throw new IllegalArgumentException(String.format("not allow parameterized type %s", type.toString()));
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isPrimitive() || Primitives.isWrapperType((Class)clazz)) {
                throw new IllegalArgumentException(String.format("not allow type %s", clazz.toString()));
            }
            if (BaseThriftUtils.isThriftStruct((Type)clazz)) {
                return this.parent.getTypeName((Type)clazz);
            }
            if (clazz.isArray()) {
                Class<?> conmponentType = clazz.getComponentType();
                if (!conmponentType.isArray()) {
                    return String.format("java.util.List<%s>", this.toThriftType(Primitives.wrap(conmponentType)));
                }
                throw new IllegalArgumentException("unsupported type multi dimension array");
            }
        }
        throw new IllegalArgumentException(String.format("not allow type %s", type.toString()));
    }

    private String toClientThriftType0(Type type, boolean toDecorator, boolean sameIfThriftStruct, boolean sameIfEnum, Map<Class<?>, Class<?>> extKnownTypes) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type is null");
        if (extKnownTypes != null && extKnownTypes.containsKey(type)) {
            return this.parent.getTypeName((Type)extKnownTypes.get(type));
        }
        if (BaseThriftUtils.THRIFT_BUILTIN_KNOWNTYPES.contains(type) || type == Void.class) {
            return this.parent.getTypeName(type);
        }
        if (BaseThriftUtils.CAST_TYPES.containsKey(type)) {
            return this.parent.getTypeName((Type)BaseThriftUtils.CAST_TYPES.get(type));
        }
        if (sameIfThriftStruct && BaseThriftUtils.isThriftStruct((Type)type)) {
            return this.parent.getTypeName(type);
        }
        if (sameIfEnum && type instanceof Class && ((Class)type).isEnum()) {
            return this.parent.getTypeName(type);
        }
        if (toDecorator && this.isDecoratorType(type) && !((Class)type).isEnum()) {
            return this.toDecoratorType(type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type rawType = paramType.getRawType();
            Type[] typeArgs = paramType.getActualTypeArguments();
            if (rawType == Map.class) {
                return String.format("Map<%s,%s>", this.toClientThriftType0(typeArgs[0], toDecorator, sameIfThriftStruct, sameIfEnum, extKnownTypes), this.toClientThriftType0(typeArgs[1], toDecorator, sameIfThriftStruct, sameIfEnum, extKnownTypes));
            }
            if (rawType == List.class) {
                return String.format("List<%s>", this.toClientThriftType0(typeArgs[0], toDecorator, sameIfThriftStruct, sameIfEnum, extKnownTypes));
            }
            if (rawType == Set.class) {
                return String.format("Set<%s>", this.toClientThriftType0(typeArgs[0], toDecorator, sameIfThriftStruct, sameIfEnum, extKnownTypes));
            }
            throw new IllegalArgumentException(String.format("not allow parameterized type %s", type.toString()));
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isPrimitive() || Primitives.isWrapperType((Class)clazz)) {
                throw new IllegalArgumentException(String.format("not allow type %s", clazz.toString()));
            }
            if (BaseThriftUtils.isThriftStruct((Type)clazz) || clazz.isEnum() || this.isDecoratorType(clazz)) {
                return String.valueOf(ThriftServiceDecoratorConfiguration.INSTANCE.getThriftClientPackage()) + "." + clazz.getSimpleName();
            }
            if (clazz.isArray()) {
                Class<?> conmponentType = clazz.getComponentType();
                if (!conmponentType.isArray()) {
                    return String.format("java.util.List<%s>", this.toClientThriftType0(Primitives.wrap(conmponentType), toDecorator, sameIfThriftStruct, sameIfEnum, extKnownTypes));
                }
                throw new IllegalArgumentException("unsupported type multi dimension array");
            }
        }
        throw new IllegalArgumentException(String.format("not allow type %s", type.toString()));
    }

    public String toClientThriftType(Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type is null");
        return this.toClientThriftType0(type, false, false, false, thriftExtKnowntypes);
    }

    public String toThriftDecoratorType(Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type is null");
        return this.toClientThriftType0(type, true, true, true, thriftExtKnowntypes);
    }

    public boolean sameWithClientThriftType(Type type) {
        String s1 = this.parent.getTypeName(type);
        String s2 = this.toClientThriftType(type);
        return Objects.equals(s1, s2);
    }

    public boolean sameWithThriftDecoratorType(Type type) {
        String s1 = this.parent.getTypeName(type);
        String s2 = this.toThriftDecoratorType(type);
        return Objects.equals(s1, s2);
    }

    public String toClientThriftyType(Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type is null");
        if (type instanceof ParameterizedType) {
            ParameterizedTypeImpl parameterizedType = new ParameterizedTypeImpl((ParameterizedType)type);
            parameterizedType = (ParameterizedTypeImpl)parameterizedType.transform(ByteBuffer.class, ByteString.class);
            parameterizedType = (ParameterizedTypeImpl)parameterizedType.transform(byte[].class, ByteString.class);
            type = parameterizedType;
        }
        return this.toClientThriftType0(type, false, false, false, thriftyExtKnowntypes);
    }

    public boolean isClientThriftType(Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type is null");
        if (type == ByteBuffer.class) {
            return false;
        }
        if (BaseThriftUtils.THRIFT_BUILTIN_KNOWNTYPES.contains(type) || type == byte[].class || type == Void.class) {
            return true;
        }
        if (BaseThriftUtils.CAST_TYPES.containsKey(type)) {
            return false;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type rawType = paramType.getRawType();
            Type[] typeArgs = paramType.getActualTypeArguments();
            if (rawType == Map.class) {
                return this.isClientThriftType(typeArgs[0]) && this.isClientThriftType(typeArgs[1]);
            }
            if (rawType == List.class) {
                return this.isClientThriftType(typeArgs[0]);
            }
            if (rawType == Set.class) {
                return this.isClientThriftType(typeArgs[0]);
            }
            throw new IllegalArgumentException(String.format("not allow parameterized type %s", type.toString()));
        }
        if (type instanceof Class) {
            return false;
        }
        throw new IllegalArgumentException(String.format("not allow type %s", type.toString()));
    }

    private String toDecoratorType(Type type) {
        if (this.isDecoratorType(type)) {
            ThriftStructDecorator decorator = this.decorateTypes.get(type);
            if (decorator.getDecoratorPackage().equals(this.getParentPackage()) && !this.parent.getImportedList().containsValue(type)) {
                return ((Class)type).getSimpleName();
            }
            return decorator.getDecoratorClassName();
        }
        return this.parent.getTypeName(type);
    }

    public String toThriftyDecoratorType(Type type) {
        if (type == ByteBuffer.class || type == byte[].class) {
            return this.parent.getTypeName(byte[].class);
        }
        return this.toClientThriftType0(type, true, true, true, null);
    }

    public boolean sameWithClientThriftyType(Type type) {
        String s1 = this.parent.getTypeName(type);
        String s2 = this.toClientThriftyType(type);
        return Objects.equals(s1, s2);
    }

    public boolean sameWithThriftyDecoratorType(Type type) {
        String s1 = this.parent.getTypeName(type);
        String s2 = this.toThriftyDecoratorType(type);
        return Objects.equals(s1, s2);
    }

    public void checkType(Type type) {
        if (!this.verifyType(type)) {
            throw new IllegalArgumentException(String.format("UNSUPPORTED TYPE %s", type.toString()));
        }
    }

    public void checkType(Method method) {
        this.checkParameter(method);
        this.checkReturnType(method);
        this.checkThrows(method);
    }

    public void checkParameter(Method method) {
        Method.Parameter[] parameterArray = method.getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method.Parameter param = parameterArray[n2];
            Type genericType = param.getGenericType();
            if (!this.verifyType(genericType)) {
                throw new IllegalArgumentException(String.format("UNSUPPORTED TYPE %s of parameter %s in %s", genericType.toString(), param.name, method.getName()));
            }
            ++n2;
        }
    }

    public void checkReturnType(Method method) {
        Type returnType = method.getGenericReturnType();
        if (!this.verifyType(returnType)) {
            throw new IllegalArgumentException(String.format("UNSUPPORTED TYPE %s of return type for %s", returnType.toString(), method.getName()));
        }
    }

    public void checkThrows(Method method) {
        Type[] typeArray = method.getGenericExceptionTypes();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type exp = typeArray[n2];
            if (!this.verifyType(exp)) {
                throw new IllegalArgumentException(String.format("UNSUPPORTED EXCEPTION TYPE %s in %s", exp.toString(), method.getName()));
            }
            ++n2;
        }
    }

    public static void checkNotGeneric(Class<?> clazz) {
        if (clazz.getTypeParameters().length > 0) {
            throw new IllegalArgumentException(String.format("%s must not be a generic class", clazz.getName()));
        }
    }

    public static void checkNotGeneric(java.lang.reflect.Method method) {
        if (method.getTypeParameters().length > 0) {
            throw new IllegalArgumentException(String.format("%s must not be a generic method", method.getName()));
        }
    }

    public static void checkNotGeneric(Method method) {
        if (method.getTypeParameters().length > 0) {
            throw new IllegalArgumentException(String.format("%s must not be a generic method", method.getName()));
        }
    }

    private String getParentPackage() {
        if (this.parent instanceof ThriftStructDecorator) {
            return ((ThriftStructDecorator)this.parent).getDecoratorPackage();
        }
        if (this.parent instanceof ThriftServiceDecorator) {
            return ((ThriftServiceDecorator)this.parent).getGeneratePackage();
        }
        return null;
    }

    public void addReferTypes(Type type) {
        BaseThriftUtils.traverseTypes((Type)type, (BaseThriftUtils.Action)new BaseThriftUtils.Action(){

            public void doClass(Class<?> clazz) {
                TypeHelper.this.referTypes.add(clazz);
                TypeHelper.this.parent.addImportedClass(new Type[]{clazz});
                if (ThriftServiceDecoratorConfiguration.INSTANCE.getTaskType().castReferType && BaseThriftUtils.CAST_TYPES.containsKey(clazz)) {
                    TypeHelper.this.parent.addImportedClass(new Type[]{(Type)BaseThriftUtils.CAST_TYPES.get(clazz)});
                    TypeHelper.this.referTypes.add((Class)BaseThriftUtils.CAST_TYPES.get(clazz));
                }
            }
        });
    }

    public void addReferTypes(Method method) {
        Object[] objectArray = method.getParameters();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method.Parameter param = objectArray[n2];
            this.addReferTypes(param.getGenericType());
            ++n2;
        }
        this.addReferTypes(method.getGenericReturnType());
        objectArray = method.getGenericExceptionTypes();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Method.Parameter exp = objectArray[n2];
            this.addReferTypes((Type)exp);
            ++n2;
        }
    }

    public boolean needTransformer() {
        return Iterators.tryFind(this.referTypes.iterator(), (Predicate)new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return BaseThriftUtils.needTransformer(input);
            }
        }).isPresent();
    }

    public List<Class<?>> getTypesWithDecorator() {
        return Lists.transform(this.getDecorateTypes(), (Function)new Function<ThriftStructDecorator, Class<?>>(){

            public Class<?> apply(ThriftStructDecorator input) {
                return input.getBaseClass();
            }
        });
    }

    public List<Class<?>> getReferExceptions() {
        Iterable iterable = Iterables.filter(this.referTypes, (Predicate)new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return Exception.class.isAssignableFrom(input);
            }
        });
        return Lists.newArrayList((Iterable)iterable);
    }

    static ThriftStructDecorator makeThriftStructDecorator(Class<?> structType) {
        Preconditions.checkNotNull(structType, (Object)"structType is null");
        Deque<Class<?>> stack = tlsStack.get();
        if (stack.contains(structType)) {
            String path = Joiner.on((String)"->").join(Iterables.transform((Iterable)Iterables.concat(stack, (Iterable)ImmutableList.of(structType)), (Function)new Function<Class<?>, Object>(){

                public Object apply(Class<?> input) {
                    return TypeToken.of(input).getRawType().getName();
                }
            }));
            throw new IllegalArgumentException("Circular references are not allowed: " + path);
        }
        stack.push(structType);
        try {
            ThriftStructDecorator thriftStructDecorator = new ThriftStructDecorator(structType);
            return thriftStructDecorator;
        }
        finally {
            Class<?> top = stack.pop();
            Preconditions.checkState((boolean)structType.equals(top), (String)"ThriftCatalog circularity detection stack is corrupt: expected %s, but got %s", structType, top);
        }
    }
}

