/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.webclient;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import net.gdface.codegen.AbstractSchema;
import net.gdface.codegen.webclient.KSoapConstants;
import net.gdface.codegen.wsdl.WebServiceInfo;
import net.gdface.utils.Assert;
import net.gdface.utils.BeanPropertyUtils;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.java2wsdl.TypeTable;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexType
extends AbstractSchema
implements KSoapConstants {
    private static final Logger logger = LoggerFactory.getLogger(ComplexType.class);
    private final ArrayList<XmlSchemaElement> fieldElements;
    private final XmlSchemaObject schemaObj;
    private final WebServiceInfo webServiceInfo;
    private final Object objectForPort;
    private final TypeTable typeTable;
    private KSoapConstants.TypePurpose purpose;
    private boolean used = false;
    private final AxisOperation operation;

    protected ComplexType(XmlSchemaObject schemaObj, WebServiceInfo webServiceInfo, Object objectForPort, AxisOperation operation) {
        Assert.notNull((Object)schemaObj, (String)"schemaObj");
        Assert.notNull((Object)webServiceInfo, (String)"webServiceInfo");
        this.objectForPort = objectForPort;
        this.schemaObj = schemaObj;
        this.webServiceInfo = webServiceInfo;
        this.typeTable = webServiceInfo.getAxisService().getTypeTable();
        this.operation = operation;
        if (schemaObj instanceof XmlSchemaComplexType) {
            this.fieldElements = webServiceInfo.getFieldElements(((XmlSchemaComplexType)this.schemaObj).getQName());
        } else if (schemaObj instanceof XmlSchemaElement) {
            this.fieldElements = webServiceInfo.getFieldElements(((XmlSchemaElement)schemaObj).getQName());
        } else {
            throw new IllegalArgumentException(String.format("invalid type,schemaObj must be  %s OR %s", XmlSchemaElement.class.getSimpleName(), XmlSchemaComplexType.class.getSimpleName()));
        }
        this.init();
    }

    private void addImportedBeanFieldClass(Class<?> beanClass) {
        this.addImportedClass(this.getReadablePropertiesReturnClass(beanClass).values().toArray(new Type[0]));
    }

    private void addImportedFieldElementsClass() {
        for (XmlSchemaElement element : this.getFieldElements()) {
            QName typeName = element.getSchemaTypeName();
            try {
                String className = this.typeTable.getClassNameForQName(typeName);
                if (className == null) continue;
                this.addImportedClass(new String[]{className});
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        block10: {
            try {
                if (this.schemaObj instanceof XmlSchemaComplexType) {
                    String className = this.typeTable.getClassNameForQName(((XmlSchemaComplexType)this.schemaObj).getQName());
                    if (className != null) {
                        this.baseClass = Class.forName(className);
                        this.addImportedClass(new Type[]{this.baseClass});
                        this.addImportedBeanFieldClass(this.baseClass);
                        this.purpose = KSoapConstants.TypePurpose.BEAN;
                    } else {
                        this.addImportedFieldElementsClass();
                        this.purpose = KSoapConstants.TypePurpose.OTHER;
                    }
                    break block10;
                }
                if (this.objectForPort.getClass().isArray()) {
                    this.addImportedClass((Type[])this.objectForPort);
                    this.purpose = KSoapConstants.TypePurpose.REQUEST;
                    break block10;
                }
                if (this.objectForPort instanceof Type) {
                    this.addImportedClass(new Type[]{(Type)this.objectForPort});
                    this.purpose = KSoapConstants.TypePurpose.RESPONSE;
                    break block10;
                }
                if (this.objectForPort == FAULT_MESSAGE) {
                    this.purpose = KSoapConstants.TypePurpose.FAULT;
                    break block10;
                }
                this.addImportedFieldElementsClass();
                this.purpose = KSoapConstants.TypePurpose.OTHER;
            }
            catch (ClassNotFoundException e) {
                logger.error(e.toString());
            }
        }
    }

    public boolean compile() {
        return true;
    }

    public ArrayList<XmlSchemaElement> getFieldElements() {
        return this.fieldElements;
    }

    public Map<String, PropertyDescriptor> getReadableProperties() {
        return BeanPropertyUtils.getProperties((Class)this.baseClass, (int)2);
    }

    public Map<String, PropertyDescriptor> getRwProperties() {
        return BeanPropertyUtils.getProperties((Class)this.baseClass, (int)3);
    }

    public Map<String, PropertyDescriptor> getAllProperties() {
        return BeanPropertyUtils.getProperties((Class)this.baseClass, (int)0);
    }

    public Map<String, Type> getReadablePropertiesReturnClass() {
        return this.getReadablePropertiesReturnClass(this.baseClass);
    }

    public Map<String, Type> getReadablePropertiesReturnClass(Class<?> beanClass) {
        try {
            Map properties = BeanPropertyUtils.getProperties(beanClass, (int)2);
            HashMap<String, Type> classMap = new HashMap<String, Type>(properties.size());
            for (Map.Entry entry : properties.entrySet()) {
                classMap.put((String)entry.getKey(), ((PropertyDescriptor)entry.getValue()).getReadMethod().getGenericReturnType());
            }
            return classMap;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isBean() {
        return this.purpose == KSoapConstants.TypePurpose.BEAN;
    }

    public boolean isRequest() {
        return this.purpose == KSoapConstants.TypePurpose.REQUEST;
    }

    public boolean isResponse() {
        return this.purpose == KSoapConstants.TypePurpose.RESPONSE;
    }

    public boolean isFault() {
        return this.purpose == KSoapConstants.TypePurpose.FAULT;
    }

    public boolean isOther() {
        return this.purpose == KSoapConstants.TypePurpose.OTHER;
    }

    public WebServiceInfo getWebServiceInfo() {
        return this.webServiceInfo;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public XmlSchemaObject getSchemaObj() {
        return this.schemaObj;
    }

    public Object getObjectForPort() {
        return this.objectForPort;
    }

    public AxisOperation getOperation() {
        return this.operation;
    }
}

