/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.webclient;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.gdface.codegen.Method;
import net.gdface.codegen.webclient.GSoapHeaderHelper;
import net.gdface.codegen.webclient.WebClient;
import net.gdface.exception.ServiceRuntime;
import net.gdface.utils.Assert;
import net.gdface.utils.Judge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSoapClient<T>
extends WebClient<T> {
    private static final Logger logger = LoggerFactory.getLogger(GSoapClient.class);
    private final String serviceName;
    private final GSoapHeaderHelper gsoapHelper;

    public GSoapClient(Class<T> interfaceClass, Class<? extends T> refClass, Class<?> serviceClass, String serviceName, File stubFolder, String stubPrefix) {
        super(interfaceClass, refClass, serviceClass);
        Assert.notNull((Object)stubFolder, (String)"stubFolder");
        if (!stubFolder.isDirectory()) {
            throw new IllegalArgumentException(String.format("%s must be a existing directory", stubFolder.getAbsolutePath()));
        }
        this.serviceName = Judge.isEmpty((String)serviceName) ? serviceClass.getSimpleName() : serviceName;
        this.gsoapHelper = new GSoapHeaderHelper(stubFolder, serviceClass, stubPrefix);
    }

    @Override
    protected void createMethodsNeedGenerated() {
        ArrayList<java.lang.reflect.Method> interfaceMethods = new ArrayList<java.lang.reflect.Method>(Arrays.asList(this.interfaceClass.getMethods()));
        try {
            for (java.lang.reflect.Method im : interfaceMethods) {
                this.methodsNeedGenerated.add(new Method(this.refClass.getMethod(im.getName(), im.getParameterTypes()), this.paramTable.getParameterNames(im.getName(), (Class[])im.getParameterTypes())));
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    protected void removeMethodsNotPort() {
        Iterator it = this.methodsNeedGenerated.iterator();
        while (it.hasNext()) {
            Method im = (Method)it.next();
            if (this.getServicePort(im) != null) continue;
            logger.info("remove method {}", (Object)im.getDocSignature());
            it.remove();
        }
    }

    @Override
    public boolean compile() {
        boolean compileOk = false;
        try {
            if (super.compile()) {
                this.removeMethodsNotPort();
                this.method2PortMap = this.createMethod2PortMapMap();
                this.addImportedClassFromMethods(this.method2PortMap.values());
                compileOk = true;
            }
        }
        catch (NoSuchMethodException e) {
            logger.error(e.toString());
        }
        return compileOk;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public GSoapHeaderHelper getGsoapHelper() {
        return this.gsoapHelper;
    }

    public Class<?> getServiceRuntimeClass() {
        return ServiceRuntime.class;
    }
}

