/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.webclient;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.gdface.codegen.CodeGenUtils;
import net.gdface.codegen.webclient.GSoapClient;
import net.gdface.codegen.webclient.GSoapConstants;
import net.gdface.codegen.webclient.GSoapProperties;
import net.gdface.codegen.webclient.WebClientConstants;
import net.gdface.utils.Assert;
import net.gdface.utils.BeanPropertyUtils;
import net.gdface.utils.Configuration;
import net.gdface.utils.FaceUtilits;
import net.gdface.utils.Judge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSoapHeaderHelper
implements GSoapConstants,
WebClientConstants {
    private static final Logger logger = LoggerFactory.getLogger(GSoapClient.class);
    private static final Configuration prop = GSoapProperties.getInstance();
    private static final String underscore = prop.getProperty("underscore").trim();
    private final String stubHeader;
    private final Map<String, String> gsoapNamespaceMap;
    private final Map<String, String> typeNameMap;
    private final Map<Class<?>, String> referenceClassMap;
    private final Map<Class<?>, Map<String, PropertyDescriptor>> refClassPropertiesMap;
    private Map<String, Map<String, String>> stubClassProppertiesMap;
    private final String stubPrefix;
    private final File stubFolder;
    private final Class<?> serviceClass;
    private static final Map<Class<?>, String> BASE_TYPE_MAP;
    private static ThreadLocal<String[]> _packageName;

    public GSoapHeaderHelper(File stubFolder, Class<?> serviceClass, String stubPrefix) {
        Assert.notNull((Object)stubFolder, (String)"stubFolder");
        Assert.notNull(serviceClass, (String)"serviceClass");
        this.serviceClass = serviceClass;
        this.stubFolder = stubFolder;
        this.stubPrefix = Judge.isEmpty((String)stubPrefix) ? this.serviceClass.getSimpleName().toLowerCase() : stubPrefix;
        this.stubHeader = GSoapHeaderHelper.load(new File(this.stubFolder, this.stubPrefix + "Stub.h"));
        this.gsoapNamespaceMap = GSoapHeaderHelper.createGSoapNamespaceMap(this.stubHeader);
        this.typeNameMap = GSoapHeaderHelper.createTypeNameMap(this.stubHeader);
        this.referenceClassMap = this.createReferenceClassMap(this.stubHeader);
        this.refClassPropertiesMap = GSoapHeaderHelper.createBeanClassPropertiesMap(this.referenceClassMap.keySet());
        this.stubClassProppertiesMap = this.createStubClassPropDefMap(CodeGenUtils.toSet(this.referenceClassMap.values()));
    }

    public Map<Class<?>, String> getReferenceClassMap() {
        return this.referenceClassMap;
    }

    public Map<Class<?>, String> getBeanClassMap() {
        HashMap beanMap = new HashMap();
        for (Map.Entry<Class<?>, String> entry : this.referenceClassMap.entrySet()) {
            if (Exception.class.isAssignableFrom(entry.getKey())) continue;
            beanMap.put(entry.getKey(), entry.getValue());
        }
        return beanMap;
    }

    public String getStubPortName(Method method, String prefix, String suffix) {
        Assert.notNull((Object)method, (String)"method");
        return this.getStubPortName(method.getName(), prefix, suffix);
    }

    public String getStubPortName(String methodName, String prefix, String suffix) {
        Assert.notEmpty((String)methodName, (String)"methodName");
        StringBuilder sb = new StringBuilder();
        if (!Judge.isEmpty((String)prefix)) {
            sb.append(prefix);
        }
        sb.append(methodName);
        if (!Judge.isEmpty((String)suffix)) {
            sb.append(suffix);
        }
        return this.typeNameMap.get(sb.toString());
    }

    private static String load(File gsoapHeader) {
        Assert.notNull((Object)gsoapHeader, (String)"gsoapHeader");
        Assert.isTrue((boolean)gsoapHeader.isFile(), (String)"gsoapHeader.isFile()");
        try {
            return new String(FaceUtilits.getBytesNotEmpty((Object)gsoapHeader));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getStubClassName(Class<?> clazz) {
        String prefix = this.getNamespacePrefix(clazz);
        if (null != prefix) {
            return String.format("%s__%s", prefix, clazz.getSimpleName());
        }
        return null;
    }

    public String getNamespacePrefix(Class<?> clazz) {
        Assert.notNull(clazz, (String)"clazz");
        String namespace = NAMESPACEGENERATOR.schemaNamespaceFromPackageName(clazz.getPackage().getName()).toString();
        String prefix = this.gsoapNamespaceMap.get(namespace);
        if (null == prefix) {
            namespace = NAMESPACEGENERATOR.namespaceFromPackageName(clazz.getPackage().getName()).toString();
            prefix = this.gsoapNamespaceMap.get(namespace);
        }
        return prefix;
    }

    protected static Map<String, String> createGSoapNamespaceMap(String header) {
        String regexpString = GSoapProperties.getInstance().getProperty("regexp.namespace").trim();
        Assert.notEmpty((String)regexpString, (String)"regexpString");
        Pattern pattern = Pattern.compile(regexpString, 8);
        Matcher matcher = pattern.matcher(header);
        HashMap<String, String> map = new HashMap<String, String>();
        while (matcher.find()) {
            map.put(matcher.group(2), matcher.group(1));
            logger.debug("namespace {} = {}", (Object)matcher.group(1), (Object)matcher.group(2));
        }
        Assert.isTrue((!map.isEmpty() ? 1 : 0) != 0, (String)"!map.isEmpty()");
        return map;
    }

    protected static Map<String, String> createTypeNameMap(String headerFile) {
        String regexpString = prop.getProperty("regexp.classmap").trim();
        Assert.notEmpty((String)regexpString, (String)"regexpString");
        Pattern pattern = Pattern.compile(regexpString, 8);
        Matcher matcher = pattern.matcher(headerFile);
        HashMap<String, String> map = new HashMap<String, String>();
        while (matcher.find()) {
            String stubClassName = matcher.group(1);
            String cppClassName = matcher.group(3).replace(underscore, "_");
            map.put(cppClassName, stubClassName);
            logger.debug("type name map {} = {}", (Object)cppClassName, (Object)stubClassName);
        }
        Assert.isTrue((!map.isEmpty() ? 1 : 0) != 0, (String)"!map.isEmpty()");
        return map;
    }

    protected Map<Class<?>, String> createReferenceClassMap(String headerFile) {
        String regexpString = prop.getProperty("regexp.refclass").trim();
        Assert.notEmpty((String)regexpString, (String)"regexpString");
        Pattern pattern = Pattern.compile(regexpString, 8);
        Matcher matcher = pattern.matcher(headerFile);
        HashMap map = new HashMap();
        while (matcher.find()) {
            String stubClassName = matcher.group(1);
            Class<?> clazz = this.classFromStubClassName(stubClassName.replace(underscore, "_"));
            map.put(clazz, stubClassName);
            logger.debug("reference class map {} = {}", (Object)clazz.getName(), (Object)stubClassName);
        }
        if (map.isEmpty()) {
            logger.info("no reference class defined");
        }
        return map;
    }

    private static Map<Class<?>, Map<String, PropertyDescriptor>> createBeanClassPropertiesMap(Set<Class<?>> classSet) {
        HashMap map = new HashMap();
        for (Class<?> refClass : classSet) {
            map.put(refClass, BeanPropertyUtils.getProperties(refClass, (int)3));
        }
        return map;
    }

    private Map<String, Map<String, String>> createStubClassPropDefMap(Set<String> stubClassSet) {
        Assert.notNull(stubClassSet, (String)"stubClassSet");
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        String regClassDef = prop.getProperty("regexp.classdef");
        String regPropDef = prop.getProperty("regexp.propdef");
        Assert.notEmpty((String)regClassDef, (String)"regClassDef");
        Assert.notEmpty((String)regPropDef, (String)"regPropDef");
        Pattern pattern = Pattern.compile(regPropDef, 8);
        for (String type : stubClassSet) {
            logger.debug("class {}{", (Object)type);
            Matcher mc = Pattern.compile(regClassDef.replace("$CLASS_NAME$", type), 8).matcher(this.stubHeader);
            if (!mc.find()) {
                throw new IllegalArgumentException(String.format("regexp not match Class Definition of  %s in header file", type));
            }
            String props = mc.group(1);
            Matcher matcher = pattern.matcher(props);
            HashMap<String, String> propMap = new HashMap<String, String>();
            while (matcher.find()) {
                propMap.put(matcher.group(2).trim(), matcher.group(1).trim());
                logger.debug("\t{} : {}", (Object)matcher.group(1), (Object)matcher.group(2));
            }
            logger.debug("}", (Object)type);
            map.put(type, propMap);
        }
        return map;
    }

    public Class<?> classFromStubClassName(String stubClassName) {
        Pattern pattern = Pattern.compile("^\\b([a-zA-Z\\d]+\\d+)__([a-zA-Z\\d]+)?$");
        Matcher matcher = pattern.matcher(stubClassName.replace(underscore, "_"));
        if (matcher.find()) {
            String namespace = (String)CodeGenUtils.getKey(this.gsoapNamespaceMap, (Object)matcher.group(1));
            return CodeGenUtils.classFromNamespaceAndClassName((String)namespace, (String)matcher.group(2));
        }
        throw new IllegalArgumentException("invalid stubClassName");
    }

    public String toStubName(String name) {
        Assert.notNull((Object)name, (String)"name");
        return name.replace("_", underscore);
    }

    public Map<String, String> getTypeNameMap() {
        return this.typeNameMap;
    }

    public Map<Class<?>, Map<String, PropertyDescriptor>> getRefClassPropertiesMap() {
        return this.refClassPropertiesMap;
    }

    boolean isPointer(String stubClassName) {
        Assert.notEmpty((String)stubClassName, (String)"stubClassName");
        return stubClassName.endsWith("*");
    }

    public static Class<?> getClassOfProperty(PropertyDescriptor prop) {
        Assert.notNull((Object)prop, (String)"prop");
        Method method = prop.getReadMethod();
        if (null == method) {
            throw new IllegalArgumentException(String.format("not found read method for %s", prop.getName()));
        }
        return method.getReturnType();
    }

    public Map.Entry<String, String> getStubPropertyDefine(String stubClassName, String prop) {
        Assert.notEmpty((String)stubClassName, (String)"className");
        Assert.notEmpty((String)prop, (String)"prop");
        Map<String, String> properties = this.stubClassProppertiesMap.get(stubClassName);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (!entry.getKey().matches("^" + prop + "_?$")) continue;
            return entry;
        }
        throw new IllegalArgumentException(String.format("not found property %s for %s", prop, stubClassName));
    }

    public PropertyDescriptor getPropertyDescriptor(Class<?> refClass, String stubProp) {
        Assert.notNull(refClass, (String)"refClass");
        Assert.notEmpty((String)stubProp, (String)"stubProp");
        Map<String, PropertyDescriptor> properties = this.refClassPropertiesMap.get(refClass);
        if (null == properties) {
            throw new IllegalArgumentException(String.format("%s not a reference class(\u4e0d\u662f\u5f15\u7528\u7c7b\u578b)", refClass.getName()));
        }
        String stubPropName = stubProp.replace(underscore, "_");
        for (Map.Entry<String, PropertyDescriptor> entry : properties.entrySet()) {
            if (!stubPropName.matches("^" + entry.getKey() + "_?$")) continue;
            return entry.getValue();
        }
        throw new IllegalArgumentException(String.format("not found property %s for %s", stubProp, refClass.getName()));
    }

    public static String toCppFullName(String className) {
        Assert.notEmpty((String)className, (String)"className");
        return className.replaceAll("\\.", "::");
    }

    public static String toCppFullName(Class<?> clazz) {
        Assert.notNull(clazz, (String)"className");
        return GSoapHeaderHelper.toCppFullName(clazz.getName());
    }

    public static String toCppType(Class<?> clazz, boolean full) {
        Assert.notNull(clazz, (String)"clazz");
        if (BASE_TYPE_MAP.containsKey(clazz)) {
            return BASE_TYPE_MAP.get(clazz);
        }
        if (clazz.isArray()) {
            return String.format("std::vector<%s>", GSoapHeaderHelper.toCppType(clazz.getComponentType(), full));
        }
        return String.format("std::shared_ptr<%s>", full ? GSoapHeaderHelper.toCppFullName(clazz) : clazz.getSimpleName());
    }

    public static String toCppType(Class<?> clazz) {
        return GSoapHeaderHelper.toCppType(clazz, false);
    }

    public static String toCppParameterType(Class<?> clazz, boolean full) {
        String typeName = GSoapHeaderHelper.toCppType(clazz, full);
        if (typeName.startsWith("std::")) {
            typeName = "const " + typeName + "&";
        }
        return typeName;
    }

    public static String toCppParameterType(Class<?> clazz) {
        return GSoapHeaderHelper.toCppParameterType(clazz, false);
    }

    public static String getBaseIndentTabs(String packageName) {
        if (Judge.isEmpty((String)packageName)) {
            return "";
        }
        String[] names = packageName.split("\\.");
        byte[] ba = new byte[names.length];
        for (int i = 0; i < ba.length; ++i) {
            ba[i] = 9;
        }
        return new String(ba, 0, ba.length - 1);
    }

    public static String getBaseIndentTabs(Class<?> clazz) {
        Assert.notNull(clazz, (String)"clazz");
        return GSoapHeaderHelper.getBaseIndentTabs(clazz.getPackage().getName());
    }

    public static String namespaceBegin(String packageName) {
        int i;
        if (Judge.isEmpty((String)packageName)) {
            return "";
        }
        String[] names = packageName.split("\\.");
        _packageName.set(names);
        StringBuilder builder = new StringBuilder();
        byte[] ba = new byte[names.length];
        for (i = 0; i < ba.length; ++i) {
            ba[i] = 9;
        }
        for (i = 0; i < names.length; ++i) {
            String tabs = new String(ba, 0, i);
            builder.append(String.format("%snamespace %s\n%s{\n", tabs, names[i], tabs));
        }
        return builder.toString();
    }

    public static String namespaceBegin(Class<?> clazz) {
        Assert.notNull(clazz, (String)"clazz");
        return GSoapHeaderHelper.namespaceBegin(clazz.getPackage().getName());
    }

    public static String namespaceEnd() {
        int i;
        Object[] names = _packageName.get();
        if (Judge.isEmpty((Object[])names)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        byte[] ba = new byte[names.length];
        for (i = 0; i < ba.length; ++i) {
            ba[i] = 9;
        }
        for (i = names.length; i > 0; --i) {
            String tabs = new String(ba, 0, i - 1);
            builder.append(String.format("%s} /* namespace %s */\n", tabs, names[i - 1]));
        }
        _packageName.set(null);
        return builder.toString();
    }

    public Map<String, Map<String, String>> getStubClassProppertiesMap() {
        return this.stubClassProppertiesMap;
    }

    public boolean isReferenceClass(Class<?> type) {
        Assert.notNull(type, (String)"type");
        return this.referenceClassMap.containsKey(type);
    }

    public String getStubPrefix() {
        return this.stubPrefix;
    }

    public File getStubFolder() {
        return this.stubFolder;
    }

    public final String toStubExpectionClassName(Class<? extends Throwable> expection) {
        Assert.notNull(expection, (String)"expection");
        return String.format("%s__%s%s", this.getNamespacePrefix(this.serviceClass), this.serviceClass.getSimpleName(), expection.getSimpleName());
    }

    static {
        Assert.notEmpty((String)underscore, (String)"underscore");
        BASE_TYPE_MAP = new HashMap<Class<?>, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(Void.TYPE, "void");
                this.put(Integer.TYPE, "int");
                this.put(Long.TYPE, "long");
                this.put(Byte.TYPE, "char");
                this.put(Double.TYPE, "double");
                this.put(Float.TYPE, "");
                this.put(Character.TYPE, "char");
                this.put(Short.TYPE, "short");
                this.put(Boolean.TYPE, "bool");
                this.put(Integer.class, "std::shared_ptr<int>");
                this.put(Long.class, "std::shared_ptr<long>");
                this.put(Byte.class, "std::shared_ptr<char>");
                this.put(Double.class, "std::shared_ptr<double>");
                this.put(Float.class, "std::shared_ptr<float>");
                this.put(Character.class, "std::shared_ptr<<char>");
                this.put(Short.class, "std::shared_ptr<short>");
                this.put(Boolean.class, "std::shared_ptr<bool>");
                this.put(String.class, "std::string");
                this.put(byte[].class, "std::shared_ptr<std::vector<char>>");
            }
        };
        _packageName = new ThreadLocal();
    }
}

