/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.webclient;

import java.io.File;
import net.gdface.codegen.webclient.GSoapHeaderHelper;
import net.gdface.utils.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSoapStub {
    private static final Logger logger = LoggerFactory.getLogger(GSoapStub.class);
    private final String serviceName;
    private final GSoapHeaderHelper gsoapHelper;

    public GSoapStub(Class<?> serviceClass, File stubFolder, String stubPrefix) {
        Assert.notNull(serviceClass, (String)"serviceClass");
        Assert.notNull((Object)stubFolder, (String)"stubFolder");
        if (!stubFolder.isDirectory()) {
            throw new IllegalArgumentException(String.format("%s must be a existing directory", stubFolder.getAbsolutePath()));
        }
        this.serviceName = serviceClass.getSimpleName();
        this.gsoapHelper = new GSoapHeaderHelper(stubFolder, serviceClass, stubPrefix);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public GSoapHeaderHelper getGsoapHelper() {
        return this.gsoapHelper;
    }
}

