/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.webclient;

import net.gdface.codegen.webclient.KSoapConstants;
import net.gdface.codegen.webclient.WebClient;
import net.gdface.utils.Assert;
import net.gdface.utils.Judge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KSoapClient<T>
extends WebClient<T>
implements KSoapConstants {
    private static final Logger logger = LoggerFactory.getLogger(KSoapClient.class);
    private final String serviceName;
    private final String stubPackage;
    private final String stubClassSimpleName;
    private final String stubClassName;

    public KSoapClient(Class<T> interfaceClass, Class<? extends T> refClass, Class<?> serviceClass, String serviceName, String stubPackage) {
        super(interfaceClass, refClass, serviceClass);
        Assert.notEmpty((String)stubPackage, (String)"stubPackage");
        this.serviceName = Judge.isEmpty((String)serviceName) ? serviceClass.getSimpleName() : serviceName;
        this.stubPackage = stubPackage;
        this.stubClassSimpleName = serviceName + "Stub";
        this.stubClassName = this.stubPackage + "." + this.stubClassSimpleName;
    }

    @Override
    public boolean compile() {
        boolean compileOk = false;
        try {
            if (super.compile()) {
                this.method2PortMap = this.createMethod2PortMapMap();
                this.addImportedClassFromMethods(this.method2PortMap.values());
                compileOk = true;
            }
        }
        catch (NoSuchMethodException e) {
            logger.error(e.toString());
        }
        return compileOk;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getStubPackage() {
        return this.stubPackage;
    }

    public String getStubClassSimpleName() {
        return this.stubClassSimpleName;
    }

    public String getStubClassName() {
        return this.stubClassName;
    }
}

