/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.webclient;

import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import net.gdface.codegen.AbstractSchema;
import net.gdface.codegen.CodeGenUtils;
import net.gdface.codegen.Method;
import net.gdface.codegen.webclient.ComplexType;
import net.gdface.codegen.webclient.KSoapConstants;
import net.gdface.codegen.wsdl.WebServiceInfo;
import net.gdface.utils.Assert;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.java2wsdl.TypeTable;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaObject;

public class KSoapStub<T>
extends AbstractSchema
implements KSoapConstants {
    private final WebServiceInfo webServiceInfo;
    private final AxisService service;
    protected final Class<?> serviceClass;
    private final Map<QName, ComplexType> complexTypeBeans = new HashMap<QName, ComplexType>();
    private final Map<QName, ComplexType> complexTypeRequests = new HashMap<QName, ComplexType>();
    private final Map<QName, ComplexType> complexTypeResponses = new HashMap<QName, ComplexType>();
    private final Map<QName, ComplexType> complexTypeFaults = new HashMap<QName, ComplexType>();
    private final Map<QName, ComplexType> complexTypeOthers = new HashMap<QName, ComplexType>();
    private final Map<String, Map<QName, ComplexType>> schemaMap = new HashMap<String, Map<QName, ComplexType>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(KSoapConstants.TypePurpose.BEAN.name(), KSoapStub.this.complexTypeBeans);
            this.put(KSoapConstants.TypePurpose.REQUEST.name(), KSoapStub.this.complexTypeRequests);
            this.put(KSoapConstants.TypePurpose.RESPONSE.name(), KSoapStub.this.complexTypeResponses);
            this.put(KSoapConstants.TypePurpose.FAULT.name(), KSoapStub.this.complexTypeFaults);
            this.put(KSoapConstants.TypePurpose.OTHER.name(), KSoapStub.this.complexTypeOthers);
        }
    };

    public KSoapStub(Class<?> serviceClass, URI wsdlURI, String serviceName) {
        Assert.notNull((Object)wsdlURI, (String)"wsdlURI");
        Assert.notNull(serviceClass, (String)"serviceClass");
        this.serviceClass = serviceClass;
        this.webServiceInfo = new WebServiceInfo(wsdlURI, serviceClass, serviceName);
        this.service = this.webServiceInfo.getAxisService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compile() {
        boolean compileOk = false;
        this.addImportedClassFromMethods(this.webServiceInfo.getPorts().values());
        this.createSchemaForBeans();
        this.createSchemaForPorts();
        this.createSchemaForOthers();
        compileOk = true;
        return compileOk;
    }

    private void createSchemaForBeans() {
        for (Map.Entry entry : this.webServiceInfo.getQNameToClassMap().entrySet()) {
            this.complexTypeBeans.put((QName)entry.getKey(), new ComplexType((XmlSchemaObject)this.webServiceInfo.getXmlSchemaComplexType((QName)entry.getKey()), this.webServiceInfo, null, null));
        }
    }

    private void createSchemaForOthers() {
        for (XmlSchema schema : this.webServiceInfo.getSchema()) {
            Iterator it = schema.getSchemaTypes().getNames();
            while (it.hasNext()) {
                QName name = (QName)it.next();
                if (this.hasComplexType(name)) continue;
                this.complexTypeOthers.put(name, new ComplexType((XmlSchemaObject)this.webServiceInfo.getXmlSchemaComplexType(name), this.webServiceInfo, null, null));
            }
        }
    }

    private final void setComplexTypeUsedRelatedBy(Class<?> ... classes) {
        TypeTable typeTable = this.service.getTypeTable();
        for (Class<?> clazz : classes) {
            Class clazz2;
            String className;
            if (null == clazz || typeTable.isSimpleType(className = (clazz2 = CodeGenUtils.getElementClass(clazz)).getName())) continue;
            QName name = typeTable.getQNamefortheType(className);
            if (null != name) {
                ComplexType complexType = this.complexTypeBeans.get(name);
                if (null != complexType) {
                    complexType.setUsed(true);
                    continue;
                }
                throw new IllegalArgumentException(String.format("can't found complex type for QName [%s]", name));
            }
            throw new IllegalArgumentException(String.format("can't found QName for [%s] in typeTable", className));
        }
    }

    private final void setComplexTypeUsedRelatedBy(Type ... types) {
        for (Type type : types) {
            if (null == type) continue;
            if (type instanceof Class) {
                this.setComplexTypeUsedRelatedBy((Class)type);
                continue;
            }
            this.setComplexTypeUsedRelatedBy(Method.getAllClassForGenericType((String)type.toString()));
        }
    }

    private void createSchemaForPorts() {
        boolean used = true;
        for (Map.Entry entry : this.webServiceInfo.getPorts().entrySet()) {
            ComplexType complexType;
            QName qn;
            AxisMessage msg;
            AxisOperation op = this.service.getOperation(new QName(this.service.getTargetNamespace(), (String)entry.getKey()));
            try {
                msg = op.getMessage("In");
                qn = msg.getElementQName();
                complexType = new ComplexType((XmlSchemaObject)msg.getSchemaElement(), this.webServiceInfo, ((Method)entry.getValue()).getGenericParameterTypes(), op);
                complexType.setUsed(used);
                this.setComplexTypeUsedRelatedBy(((Method)entry.getValue()).getGenericParameterTypes());
                this.complexTypeRequests.put(qn, complexType);
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
            try {
                msg = op.getMessage("Out");
                qn = msg.getElementQName();
                complexType = new ComplexType((XmlSchemaObject)msg.getSchemaElement(), this.webServiceInfo, ((Method)entry.getValue()).getGenericReturnType(), op);
                complexType.setUsed(used);
                this.setComplexTypeUsedRelatedBy(((Method)entry.getValue()).getGenericReturnType());
                this.complexTypeResponses.put(qn, complexType);
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
            this.setComplexTypeUsedRelatedBy(((Method)entry.getValue()).getGenericExceptionTypes());
            for (AxisMessage fault : op.getFaultMessages()) {
                qn = fault.getElementQName();
                if (this.complexTypeFaults.containsKey(qn)) continue;
                complexType = new ComplexType((XmlSchemaObject)fault.getSchemaElement(), this.webServiceInfo, FAULT_MESSAGE, op);
                complexType.setUsed(used);
                this.complexTypeFaults.put(qn, complexType);
            }
        }
    }

    public ComplexType getComplexType(QName name) {
        ComplexType complexType = null;
        for (Map<QName, ComplexType> schema : this.schemaMap.values()) {
            complexType = schema.get(name);
            if (null == complexType) continue;
            return complexType;
        }
        return complexType;
    }

    public WebServiceInfo getWebServiceInfo() {
        return this.webServiceInfo;
    }

    public boolean hasComplexType(QName name) {
        return this.getComplexType(name) != null;
    }

    public Map<QName, ComplexType> getComplexTypeBeans() {
        return this.complexTypeBeans;
    }

    public Map<QName, ComplexType> getComplexTypeRequests() {
        return this.complexTypeRequests;
    }

    public Map<QName, ComplexType> getComplexTypeResponses() {
        return this.complexTypeResponses;
    }

    public Map<QName, ComplexType> getComplexTypeFaults() {
        return this.complexTypeFaults;
    }

    public Map<QName, ComplexType> getComplexTypeOthers() {
        return this.complexTypeOthers;
    }

    public Map<String, Map<QName, ComplexType>> getSchemaMap() {
        return this.schemaMap;
    }

    public Map<QName, ComplexType> getSchema(String name) {
        return this.schemaMap.get(name);
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }
}

