/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.webclient;

import java.io.File;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import net.gdface.cli.Context;
import net.gdface.codegen.AbstractSchema;
import net.gdface.codegen.generator.Generator;
import net.gdface.codegen.generator.GeneratorConfiguration;
import net.gdface.codegen.webclient.ComplexType;
import net.gdface.codegen.webclient.KSoapConstants;
import net.gdface.codegen.webclient.KSoapStub;
import net.gdface.codegen.webclient.KSoapStubConfiguration;
import net.gdface.codegen.webclient.KSoapStubOptions;
import org.apache.commons.cli.Options;

public class KSoapStubGenerator
extends Generator
implements KSoapConstants {
    private KSoapStubConfiguration config = new KSoapStubConfiguration();
    private final KSoapStubOptions options = KSoapStubOptions.getInstance();
    private AbstractSchema schema = null;
    private AbstractSchema parent = null;
    private Map<String, Map<QName, ComplexType>> schemaMap = null;
    private boolean inlineSource = false;
    private String templateFolder = "";

    public static void main(String[] args) {
        KSoapStubGenerator g = (KSoapStubGenerator)new KSoapStubGenerator().parseCommandLine(args).initEngine().generate();
        g.parent = g.schema;
        g.generateSchemas();
    }

    public void generateSchemas() {
        if (null == this.schemaMap) {
            throw new IllegalArgumentException("schemaMap not initialized");
        }
        Set<String> independentSchemas = this.config.getIndependentSchemas();
        if (independentSchemas.size() == 0) {
            return;
        }
        for (String schema : independentSchemas) {
            try {
                KSoapConstants.TypePurpose.valueOf(schema);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("UNKNOW schema name%s", schema));
            }
        }
        this.inlineSource = false;
        for (KSoapConstants.TypePurpose value : KSoapConstants.TypePurpose.values()) {
            if (!independentSchemas.contains(value.name())) continue;
            Map<QName, ComplexType> complexTypeMap = this.schemaMap.get(value.name());
            this.config.setTemplateFolder(new File(new File(this.templateFolder, "schema"), value.name().toLowerCase() + ".vm").getPath());
            for (ComplexType complexType : complexTypeMap.values()) {
                this.schema = complexType;
                this.initEngine().generate();
            }
        }
    }

    protected Context createEngineContext() {
        Context context = super.createEngineContext();
        if (null == this.schema) {
            this.schema = new KSoapStub(this.config.getServiceClass(), this.config.getWsdlLocatoin().toURI(), this.config.getServiceName());
            this.schemaMap = ((KSoapStub)this.schema).getSchemaMap();
            this.templateFolder = this.config.getTemplateFolder();
        } else if (this.schema instanceof KSoapStub) {
            throw new IllegalArgumentException(String.format("error type %s", this.schema.getClass().getName()));
        }
        if (!this.schema.compile()) {
            System.exit(1);
        }
        context.setProperty("sourceinfo", (Object)this.schema);
        context.setProperty("parentSchema", (Object)this.parent);
        context.setProperty("inline", (Object)this.inlineSource);
        return context;
    }

    protected GeneratorConfiguration getGeneratorConfiguration() {
        return this.config;
    }

    protected Options getOptions() {
        return this.options.getOptions();
    }
}

