/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.webclient;

import java.rmi.RemoteException;
import net.gdface.codegen.CodeGenUtils;
import net.gdface.codegen.Method;
import net.gdface.codegen.webclient.WebClient;
import net.gdface.exception.ServiceRuntime;
import net.gdface.utils.Assert;
import org.apache.axis2.AxisFault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StubClient<T>
extends WebClient<T> {
    private static final Logger logger = LoggerFactory.getLogger(StubClient.class);
    private final String stubPackage;
    private final String serviceName;
    private final String stubClassSimpleName;
    private final String stubClassName;

    public StubClient(Class<T> interfaceClass, Class<? extends T> refClass, Class<?> serviceClass, String stubPackage) {
        super(interfaceClass, refClass, serviceClass);
        Assert.notEmpty((String)stubPackage, (String)"stubPackage");
        this.stubPackage = stubPackage;
        this.getImportedList().put("AxisFault", AxisFault.class);
        this.getImportedList().put("RemoteException", RemoteException.class);
        this.serviceName = serviceClass.getSimpleName();
        this.stubClassSimpleName = this.serviceName + "Stub";
        this.stubClassName = stubPackage + "." + this.stubClassSimpleName;
    }

    public final Class<?> toStubClass(Method method) throws ClassNotFoundException {
        return this.toStubClass(method.getName());
    }

    public final Class<?> toStubClass(String methodName) throws ClassNotFoundException {
        return Class.forName(this.toStubClassName(methodName));
    }

    public final String toStubClassName(Method method) throws ClassNotFoundException {
        return this.toStubClassName(method.getName());
    }

    public final String toStubClassName(String methodName) {
        Assert.notEmpty((String)methodName, (String)"methodName");
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.stubPackage).append(".").append(this.stubClassSimpleName).append(".");
        buffer.append(CodeGenUtils.firstUpperCase((String)methodName));
        return buffer.toString();
    }

    public final String toStubClassName(Class<?> parameterClass) {
        Assert.notNull(parameterClass, (String)"parameterClass");
        if (parameterClass.isArray()) {
            return this.toStubClassName(parameterClass.getComponentType()) + "[]";
        }
        StringBuffer buffer = new StringBuffer();
        if (!CodeGenUtils.isBaseDataType(parameterClass)) {
            buffer.append(this.stubPackage).append(".").append(this.stubClassSimpleName).append(".");
        }
        buffer.append(parameterClass.getSimpleName());
        return buffer.toString();
    }

    public final Class<?> getParmameterClassForSetMethod(Class<?> methodClazz, String setMethod) throws NoSuchMethodException {
        Assert.notNull(methodClazz, (String)"methodClazz");
        for (java.lang.reflect.Method set : methodClazz.getDeclaredMethods()) {
            if (!set.getName().equals(setMethod)) continue;
            return set.getParameterTypes()[0];
        }
        throw new NoSuchMethodException();
    }

    public final String toSetMethod(String parameterName) {
        Assert.notEmpty((String)parameterName, (String)"parameterName");
        StringBuffer buffer = new StringBuffer("set");
        buffer.append(CodeGenUtils.firstUpperCase((String)parameterName));
        return buffer.toString();
    }

    public final Class<?> toStubExpection(Class<? extends Throwable> expection) throws ClassNotFoundException {
        return Class.forName(this.toStubExpectionClassName(expection));
    }

    public final String toStubExpectionClassName(Class<? extends Throwable> expection) throws ClassNotFoundException {
        Assert.notNull(expection, (String)"expection");
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.stubPackage).append(".");
        buffer.append(this.serviceName).append(expection.getSimpleName()).append("Exception");
        return buffer.toString();
    }

    public final Class<?> toExpection(Method method, Class<? extends Throwable> exception) throws ClassNotFoundException {
        Assert.notNull(exception, (String)"exception");
        String name = exception.getSimpleName().replaceAll(this.serviceName + "(\\w+)Exception", "$1");
        if (ServiceRuntime.class.getSimpleName().equals(name)) {
            return ServiceRuntime.class;
        }
        for (Class exp : CodeGenUtils.toSet((Object[])method.getExceptionTypes())) {
            if (!exp.getSimpleName().equals(name)) continue;
            return exp;
        }
        throw new ClassNotFoundException(String.format("Cant found Exception Class [%s] map to %s", name, exception.getSimpleName()));
    }

    @Override
    public boolean compile() {
        boolean compileOk = false;
        try {
            if (super.compile()) {
                this.method2PortMap = this.createMethod2PortMapMap();
                this.addImportedClassFromMethods(this.method2PortMap.values());
                compileOk = true;
            }
        }
        catch (NoSuchMethodException e) {
            logger.error(e.toString());
        }
        return compileOk;
    }

    public String getStubClassSimpleName() {
        return this.stubClassSimpleName;
    }

    public String getStubClassName() {
        return this.stubClassName;
    }
}

