/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.codegen.webclient;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.gdface.annotation.AnnotationException;
import net.gdface.annotation.AnnotationRuntimeException;
import net.gdface.annotation.Remote;
import net.gdface.annotation.Service;
import net.gdface.annotation.ServicePort;
import net.gdface.codegen.AnnotationUtils;
import net.gdface.codegen.Method;
import net.gdface.codegen.MethodException;
import net.gdface.codegen.NewSourceInfoAbstract;
import net.gdface.codegen.ServiceInfo;
import net.gdface.codegen.webclient.DuplicatedNameMethodException;
import net.gdface.exception.ServiceRuntime;
import net.gdface.utils.Assert;
import net.gdface.utils.ParameterNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebClient<T>
extends NewSourceInfoAbstract<T> {
    private static final Logger logger = LoggerFactory.getLogger(WebClient.class);
    protected ServiceInfo serviceInfo;
    protected final Class<?> serviceClass;
    public final ParameterNames serviceParamTable;
    protected Map<Method, Method> method2PortMap = new HashMap<Method, Method>();
    private final Map<String, java.lang.reflect.Method> servicePorts;

    public WebClient(Class<T> interfaceClass, Class<? extends T> refClass, Class<?> serviceClass) {
        super(interfaceClass, refClass, refClass.getSuperclass());
        Assert.notNull(serviceClass, (String)"serviceClass");
        this.serviceClass = serviceClass;
        try {
            this.servicePorts = this.getServicePorts(this.serviceClass);
        }
        catch (DuplicatedNameMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
        this.serviceParamTable = new ParameterNames(serviceClass);
        this.getImportedList().put("ServiceRuntime", ServiceRuntime.class);
    }

    protected void createMethodsNeedGenerated() {
        ArrayList<java.lang.reflect.Method> interfaceMethods = new ArrayList<java.lang.reflect.Method>(Arrays.asList(this.interfaceClass.getMethods()));
        java.lang.reflect.Method[] baseMethods = null != this.baseClass ? this.baseClass.getMethods() : new java.lang.reflect.Method[]{};
        try {
            for (java.lang.reflect.Method im : interfaceMethods) {
                if (!this.needImpl(im) && WebClient.isImplemented((java.lang.reflect.Method[])baseMethods, (java.lang.reflect.Method)im)) continue;
                this.methodsNeedGenerated.add(new Method(this.refClass.getMethod(im.getName(), im.getParameterTypes()), this.paramTable.getParameterNames(im.getName(), (Class[])im.getParameterTypes())));
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int c = 0;
        builder.append("//classes need imported in new Class:\n");
        for (Class clazz : this.importedList.values()) {
            builder.append("//[" + ++c + "]\nimported ").append(clazz.getName()).append(";\n");
        }
        builder.append("public class NewClass");
        if (null != this.baseClass) {
            builder.append("extends " + this.baseClass.getSimpleName());
        } else {
            builder.append(" implements " + this.interfaceClass.getSimpleName());
        }
        builder.append("{\n");
        c = 0;
        builder.append("//methods thad need generated in new Class:\n");
        for (Method m : this.methodsNeedGenerated) {
            builder.append("//[" + ++c + "]\n").append(m.toGenericString()).append("{}\n");
        }
        builder.append("}\n");
        return builder.toString();
    }

    public boolean compile() {
        boolean compileOk = false;
        try {
            if (super.compile()) {
                Service service = AnnotationUtils.getServiceAnnotation((Class)this.interfaceClass);
                this.addImportedClass(new Type[]{this.interfaceClass});
                this.serviceInfo = new ServiceInfo(service);
                compileOk = true;
            }
        }
        catch (AnnotationException e) {
            logger.error(e.toString());
        }
        catch (AnnotationRuntimeException e) {
            logger.error(e.toString());
        }
        return compileOk;
    }

    protected Map<Method, Method> createMethod2PortMapMap() throws NoSuchMethodException {
        HashMap<Method, Method> method2PortMap = new HashMap<Method, Method>();
        String portPrefix = this.serviceInfo.getPortPrefix();
        for (Method method : this.methodsNeedGenerated) {
            StringBuilder builder = new StringBuilder(portPrefix);
            try {
                ServicePort portDesc;
                if (this.needImpl(method)) {
                    Remote remoteAnnotation = this.getRemoteAnnotation(method);
                    Method m = this.getPrimitiveMethod(this.refClass, method);
                    portDesc = (ServicePort)m.getAnnotation(ServicePort.class);
                    if (portDesc != null) {
                        String suffix = method.getName().substring(remoteAnnotation.primtiveName().length());
                        builder.append(remoteAnnotation.primtiveName()).append(portDesc.suffix()).append(suffix);
                    } else {
                        builder.append(method.getName());
                    }
                } else {
                    portDesc = (ServicePort)method.getAnnotation(ServicePort.class);
                    builder.append(method.getName());
                    if (portDesc != null) {
                        builder.append(portDesc.suffix());
                    }
                }
            }
            catch (MethodException e) {
                throw new RuntimeException(e);
            }
            String portName = builder.toString();
            java.lang.reflect.Method portMethod = this.servicePorts.get(portName);
            if (portMethod == null) {
                throw new NoSuchMethodException(String.format("not found webservice port %s for method %s ", portName, method.getDocSignature()));
            }
            method2PortMap.put(method, new Method(portMethod, this.getPortParameterNames(portMethod)));
        }
        return method2PortMap;
    }

    protected java.lang.reflect.Method getServicePort(Method method) {
        String portPrefix = this.serviceInfo.getPortPrefix();
        StringBuilder builder = new StringBuilder(portPrefix);
        try {
            if (this.needImpl(method)) {
                Remote remoteAnnotation = this.getRemoteAnnotation(method);
                Method m = this.getPrimitiveMethod(this.refClass, method);
                ServicePort portDesc = (ServicePort)m.getAnnotation(ServicePort.class);
                if (portDesc != null) {
                    String suffix = method.getName().substring(remoteAnnotation.primtiveName().length());
                    builder.append(remoteAnnotation.primtiveName()).append(portDesc.suffix()).append(suffix);
                } else {
                    builder.append(method.getName());
                }
            } else {
                ServicePort portDesc = (ServicePort)method.getAnnotation(ServicePort.class);
                builder.append(method.getName());
                if (portDesc != null) {
                    builder.append(portDesc.suffix());
                }
            }
        }
        catch (MethodException e) {
            throw new RuntimeException(e);
        }
        String portName = builder.toString();
        return this.servicePorts.get(portName);
    }

    private final String[] getPortParameterNames(java.lang.reflect.Method portMethod) throws NoSuchMethodException {
        return this.serviceParamTable.getParameterNames(portMethod.getName(), (Class[])portMethod.getParameterTypes());
    }

    protected final Map<String, java.lang.reflect.Method> getServicePorts(Class<?> serviceClass) throws DuplicatedNameMethodException {
        java.lang.reflect.Method[] methods = serviceClass.getDeclaredMethods();
        HashMap<String, java.lang.reflect.Method> servicePorts = new HashMap<String, java.lang.reflect.Method>(methods.length << 1);
        for (java.lang.reflect.Method method : methods) {
            int modifier = method.getModifiers();
            if (!Modifier.isPublic(modifier)) continue;
            if (servicePorts.keySet().contains(method.getName())) {
                throw new DuplicatedNameMethodException(serviceClass, method.getName());
            }
            servicePorts.put(method.getName(), method);
        }
        return servicePorts;
    }

    public ServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    public Map<Method, Method> getMethod2PortMap() {
        return this.method2PortMap;
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    public boolean isServiceRuntime(Class<?> exp) {
        return ServiceRuntime.class.isAssignableFrom(exp);
    }

    public boolean needImpl(Method method) {
        return this.getRemoteAnnotation(method) != null;
    }

    public boolean needImpl(java.lang.reflect.Method method) {
        return this.getRemoteAnnotation(method) != null;
    }

    public Remote getRemoteAnnotation(Method method) {
        return (Remote)method.getAnnotation(Remote.class);
    }

    public Remote getRemoteAnnotation(java.lang.reflect.Method method) {
        return method.getAnnotation(Remote.class);
    }

    public boolean isGenericTypeClass(Method method, Class<?> parameterType) {
        Remote remoteAnnotation = this.getRemoteAnnotation(method);
        return this.serviceInfo.getBridgeType() == String.class && remoteAnnotation != null && remoteAnnotation.value() && remoteAnnotation.genericTypeClass() == parameterType;
    }

    public Method getPrimitiveMethod(Class<?> from, Method deriveMethod) throws MethodException {
        Remote remoteAnnotation = this.getRemoteAnnotation(deriveMethod);
        return this.getMatchedGenericMethod(from, deriveMethod, this.serviceInfo.getTargetType(), remoteAnnotation.genericParam(), remoteAnnotation.genericTypeClass(), remoteAnnotation.primtiveName());
    }
}

