package net.gdface.codegen.webclient;

import java.io.File;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class GSoapClientConfiguration extends WebClientConfiguration implements GSoapConstants {
	private File stubFolder;
	private String stubPrefix;
	public GSoapClientConfiguration() {
		// stubPrefix默认值为空
		defaultValue.setProperty(GSOAP_STUBPREFIX_OPTION_LONG, "");
	}

	@Override
	public void loadConfig(Options options, CommandLine cmd) throws ParseException {
		super.loadConfig(options, cmd);
		stubFolder = getProperty(GSOAP_STUB_FOLDER_OPTION_LONG);
		stubPrefix = getProperty(GSOAP_STUBPREFIX_OPTION_LONG);
	}

	/**
	 * @return stubFolder
	 */
	public File getStubFolder() {
		return stubFolder;
	}

	/**
	 * @return stubPrefix
	 */
	public String getStubPrefix() {
		return stubPrefix;
	}

}
