package net.gdface.codegen.webclient;

public interface GSoapConstants{
    final String GSOAP_STUB_FOLDER_OPTION = "gf";
    final String GSOAP_STUB_FOLDER_OPTION_LONG = "stubFolder";
    final String GSOAP_STUB_FOLDER_OPTION_DESC = "gsoap stub source folder";
    final String GSOAP_STUBPREFIX_OPTION = "gp";
    final String GSOAP_STUBPREFIX_OPTION_LONG = "stubPrefix";
    final String GSOAP_STUBPREFIX_OPTION_DESC = "gsoap source code file stubPrefix";

    /**
     * 查找名字空间映射的正则表达式
     */
    final String PROP_REGEXP_NAMESPACE="regexp.namespace";
    /**
     * 查找类名映射的正则表达式
     */
    final String PROP_REGEXP_CLASSMAP="regexp.classmap";
    /**
     * 查找stub类型定义的正则表达式
     */
    final String PROP_REGEXP_CLASSDEF="regexp.classdef";
    /**
     * 匹配stub类型中属性定义的正则表达式
     */
    final String PROP_REGEXP_PROPDEF="regexp.propdef";
    /**
     * 下划线替换属性<br>
     * gsoap本身不能直接支持下划线 "_"  ， 所以如果wsdl中的类型名字出现了下划线，则 wsdl2h在编译的时候，会自动将下划线变为 _USCORE
     */
    final String PROP_UNDERSCORE="underscore";
    /**
     * soap stub代码中rpc调用函数名的前缀,soap_call__
     */
    final String PROP_CALL_PREFIX="callPrefix";
    /**
     * 所有引用类型映射
     */
    final String PROP_REFERENCE_CLASS="regexp.refclass";
    /**
     * 字节数组对应的gsoapstub类型
     */
    final String PROP_ARRAYOFBYTE_STUBCLASS="arrayofbyte.stubclass";
    /**
     * 字节数组对应的C++接口类型
     */
    final String PROP_ARRAYOFBYTE_CPPCLASS="arrayofbyte.cppclass";
}
