package net.gdface.codegen.webclient;

import net.gdface.utils.Assert;
import net.gdface.utils.Judge;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KSoapClient<T> extends WebClient<T> implements KSoapConstants {
	private static final Logger logger = LoggerFactory.getLogger(KSoapClient.class);
	private final String serviceName;
	private final String stubPackage;
	private final String stubClassSimpleName;
	private final String stubClassName;

	public KSoapClient(Class<T> interfaceClass, Class<? extends T> refClass, Class<?> serviceClass, String serviceName,
			String stubPackage) {
		super(interfaceClass, refClass, serviceClass);
		Assert.notEmpty(stubPackage, "stubPackage");
		this.serviceName = Judge.isEmpty(serviceName) ? serviceClass.getSimpleName() : serviceName;
		this.stubPackage = stubPackage;
		this.stubClassSimpleName = serviceName + "Stub";
		this.stubClassName = new StringBuilder(this.stubPackage).append(".").append(stubClassSimpleName).toString();
	}

	@Override
	public boolean compile() {
		boolean compileOk = false;
		try {
			if (super.compile()) {
				method2PortMap = createMethod2PortMapMap();
				addImportedClassFromMethods(method2PortMap.values());
				compileOk = true;
			}
		} catch (NoSuchMethodException e) {
			logger.error(e.toString());
		}
		return compileOk;
	}

	/**
	 * @return serviceName
	 */
	public String getServiceName() {
		return serviceName;
	}

	/**
	 * @return stubPackage
	 */
	public String getStubPackage() {
		return stubPackage;
	}

	/**
	 * @return stubClassSimpleName
	 */
	public String getStubClassSimpleName() {
		return stubClassSimpleName;
	}

	/**
	 * @return stubClassName
	 */
	public String getStubClassName() {
		return stubClassName;
	}

}
