package net.gdface.codegen.webclient;

import java.io.File;
import java.util.Map;
import java.util.Set;

import javax.xml.namespace.QName;

import org.apache.commons.cli.Options;

import net.gdface.cli.Context;
import net.gdface.codegen.AbstractSchema;
import net.gdface.codegen.generator.Generator;
import net.gdface.codegen.generator.GeneratorConfiguration;

public class KSoapStubGenerator extends Generator implements KSoapConstants {
	private KSoapStubConfiguration config;
	private final KSoapStubOptions options;
	private AbstractSchema schema=null;
	private AbstractSchema parent=null;
	private Map<String, Map<QName, ComplexType>> schemaMap=null;
	private boolean inlineSource=false;
	private String templateFolder="";
	public KSoapStubGenerator() {
		config=new KSoapStubConfiguration();
		options=KSoapStubOptions.getInstance();
	}

	public static void main(String[] args) {
		KSoapStubGenerator g = (KSoapStubGenerator) new KSoapStubGenerator().parseCommandLine(args).initEngine().generate();//先生成共用代码
		g.parent=g.schema;
		g.generateSchemas();//生成独立的数据类型代码
	}
	public void generateSchemas(){
		if(null==schemaMap)
			throw new IllegalArgumentException("schemaMap not initialized");
		Map<QName, ComplexType> complexTypeMap;		
		Set<String> independentSchemas = config.getIndependentSchemas();
		if(independentSchemas.size()==0)return;
		//检查参数合法性
		for (String schema : independentSchemas) {
			try {
				TypePurpose.valueOf(schema);
			} catch (Exception e) {
				throw new IllegalArgumentException(String.format("UNKNOW schema name%s", schema));
			}
		}
		inlineSource=false;
		//按TypePurpose定义的顺序来生成
		for(TypePurpose value:TypePurpose.values()){
			if(independentSchemas.contains(value.name())){				
				complexTypeMap=schemaMap.get(value.name());
				config.setTemplateFolder(new File(new File(templateFolder,SCHEMA_FOLDER),value.name().toLowerCase()+".vm").getPath());
				for(ComplexType complexType:complexTypeMap.values()){
					//if(complexType.isUsed()){
						this.schema=complexType;
						initEngine().generate();
					//}
				}
			}
		}

	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	protected Context createEngineContext() {
		Context context = super.createEngineContext();
		if(null==schema){
			schema = new KSoapStub(config.getServiceClass(), config.getWsdlLocatoin().toURI(),
					config.getServiceName());			
			schemaMap=((KSoapStub)schema).getSchemaMap();
			templateFolder=config.getTemplateFolder();
		}else if(schema instanceof KSoapStub){//KSoapClient执行两次没意义
			throw new IllegalArgumentException(String.format("error type %s",schema.getClass().getName()));	
		}
		if (!schema.compile())
			System.exit(1);
		context.setProperty(SOURCE_INFO, schema);
		context.setProperty(PARENT_SCHEMA, parent);
		context.setProperty(INLINE_SOURCE, inlineSource);
		return context;
	}


	@Override
	protected GeneratorConfiguration getGeneratorConfiguration() {
		return config;
	}

	@Override
	protected Options getOptions() {
		return options.getOptions();
	}


}
