package net.gdface.codegen.webclient;

import net.gdface.cli.Context;

public class RPCClientGenerator extends WebClientGenerator {
	public static void main(String[] args) {
		new RPCClientGenerator().parseCommandLine(args).initEngine().generate();
	}


	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	protected Context createEngineContext() {
		Context context = super.createEngineContext();
		RPCClient newSourceInfo = new RPCClient(config.getInterfaceClass(), config.getRefClass(),
				config.getServiceClass());
		if (!newSourceInfo.compile())
			System.exit(1);
		context.setProperty(SOURCE_INFO, newSourceInfo);
		return context;
	}

}
