package net.gdface.codegen.webclient;

import java.io.File;
import net.gdface.utils.Assert;
import net.gdface.utils.Judge;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * 用于生成gsoap stub相关的支持代码
 * @author guyadong
 *
 */
public class GSoapStub{
	private static final Logger logger = LoggerFactory.getLogger(GSoapStub.class);
	private final String serviceName;
	private final GSoapHeaderHelper gsoapHelper;
	/**
	 * @param serviceClass webservice 服务实现类
	 * @param stubPrefix gsoap stub代码文件前缀
	 * @param stubFolder gsoap stub代码文件夹 
	 */
	public GSoapStub(Class<?> serviceClass, File stubFolder, String stubPrefix) {
		Assert.notNull(serviceClass, "serviceClass");
		Assert.notNull(stubFolder, "stubFolder");
		// stubFolder不是文件夹则抛出异常
		if(!stubFolder.isDirectory())
			throw new IllegalArgumentException(String.format("%s must be a existing directory",stubFolder.getAbsolutePath()));
		this.serviceName = serviceClass.getSimpleName();
		this.gsoapHelper=new GSoapHeaderHelper(stubFolder,serviceClass, stubPrefix);
	}

	/**
	 * @return serviceName
	 */
	public String getServiceName() {
		return serviceName;
	}

	/**
	 * @return gsoapHelper
	 */
	public GSoapHeaderHelper getGsoapHelper() {
		return gsoapHelper;
	}

}
